/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.framework.domain.entity.DefaultEntity;
import is.codion.framework.domain.entity.DefaultEntityBuilder;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.ThrowIfNonUnique;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface Entity
extends Comparable<Entity> {
    public EntityType entityType();

    public EntityDefinition definition();

    public <T> T put(Attribute<T> var1, T var2);

    public <T> T get(Attribute<T> var1);

    public <T> Optional<T> optional(Attribute<T> var1);

    public <T> T original(Attribute<T> var1);

    public <T> String string(Attribute<T> var1);

    public void revert(Attribute<?> var1);

    public void revert();

    public void save(Attribute<?> var1);

    public void save();

    public <T> T remove(Attribute<T> var1);

    public boolean isNull(Attribute<?> var1);

    public boolean isNotNull(Attribute<?> var1);

    public boolean contains(Attribute<?> var1);

    public Entity entity(ForeignKey var1);

    public Key key(ForeignKey var1);

    public boolean modified(Attribute<?> var1);

    public boolean modified();

    public boolean exists();

    public Entity clearPrimaryKey();

    public boolean equalValues(Entity var1);

    public boolean equalValues(Entity var1, Collection<? extends Attribute<?>> var2);

    public Map<Attribute<?>, Object> set(Entity var1);

    public Entity copy();

    public Builder copyBuilder();

    public Entity deepCopy();

    public Entity immutable();

    public boolean mutable();

    public Key primaryKey();

    public Key originalPrimaryKey();

    public Set<Map.Entry<Attribute<?>, Object>> entrySet();

    public Set<Map.Entry<Attribute<?>, Object>> originalEntrySet();

    public static Entity entity(Key key) {
        return new DefaultEntity(key);
    }

    public static Builder builder(Key key) {
        return new DefaultEntityBuilder(key);
    }

    public static Collection<Key> primaryKeys(Collection<Entity> entities) {
        return Objects.requireNonNull(entities).stream().map(Entity::primaryKey).collect(Collectors.toList());
    }

    public static Collection<Key> keys(ForeignKey foreignKey, Collection<Entity> entities) {
        return Objects.requireNonNull(entities).stream().map(entity -> entity.key(foreignKey)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Collection<Key> originalPrimaryKeys(Collection<Entity> entities) {
        return Objects.requireNonNull(entities).stream().map(Entity::originalPrimaryKey).collect(Collectors.toList());
    }

    public static <T> Collection<T> values(Collection<Key> keys) {
        return Objects.requireNonNull(keys).stream().map(key -> key.get()).collect(Collectors.toList());
    }

    public static <T> Collection<T> values(Attribute<T> attribute, Collection<Entity> entities) {
        Objects.requireNonNull(attribute, "attribute");
        return Objects.requireNonNull(entities).stream().map(entity -> entity.get(attribute)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> Collection<T> distinct(Attribute<T> attribute, Collection<Entity> entities) {
        Objects.requireNonNull(attribute, "attribute");
        return Objects.requireNonNull(entities).stream().map(entity -> entity.get(attribute)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Map<Key, Entity> primaryKeyMap(Collection<Entity> entities) {
        return Objects.requireNonNull(entities).stream().collect(Collectors.toMap(Entity::primaryKey, Function.identity(), ThrowIfNonUnique.INSTANCE));
    }

    public static <T> LinkedHashMap<T, List<Entity>> groupByValue(Attribute<T> attribute, Collection<Entity> entities) {
        return Objects.requireNonNull(entities).stream().collect(Collectors.groupingBy(entity -> entity.get(attribute), LinkedHashMap::new, Collectors.toList()));
    }

    public static LinkedHashMap<EntityType, List<Entity>> groupByType(Collection<Entity> entities) {
        return Objects.requireNonNull(entities).stream().collect(Collectors.groupingBy(Entity::entityType, LinkedHashMap::new, Collectors.toList()));
    }

    public static LinkedHashMap<EntityType, List<Key>> groupKeysByType(Collection<Key> keys) {
        return Objects.requireNonNull(keys).stream().collect(Collectors.groupingBy(Key::entityType, LinkedHashMap::new, Collectors.toList()));
    }

    public static interface Key {
        public EntityType entityType();

        public EntityDefinition entityDefinition();

        public Collection<Column<?>> columns();

        public boolean primaryKey();

        public boolean isNull();

        public boolean isNotNull();

        public boolean isNull(Column<?> var1);

        public boolean isNotNull(Column<?> var1);

        public <T> Column<T> column();

        public <T> T get();

        public <T> Optional<T> optional();

        public <T> T get(Column<T> var1);

        public <T> Optional<T> optional(Column<T> var1);

        public Builder copyBuilder();

        public static interface Builder {
            public <T> Builder with(Column<T> var1, T var2);

            public Key build();
        }
    }

    public static interface Builder {
        public <T> Builder with(Attribute<T> var1, T var2);

        public Builder withDefaults();

        public Entity build();
    }
}

