/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain;

import is.codion.common.Text;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.EntityType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

final class DefaultDomainType
implements DomainType,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, DefaultDomainType> DOMAIN_TYPES = new ConcurrentHashMap<String, DefaultDomainType>();
    private static final Map<DomainType, Map<String, EntityType>> DOMAIN_ENTITY_TYPES = new ConcurrentHashMap<DomainType, Map<String, EntityType>>();
    private final String domainName;

    private DefaultDomainType(String domainName) {
        if (Text.nullOrEmpty((String)domainName)) {
            throw new IllegalArgumentException("domainName must be a non-empty string");
        }
        this.domainName = domainName;
    }

    @Override
    public String name() {
        return this.domainName;
    }

    @Override
    public EntityType entityType(String name) {
        return this.entityType(name, null);
    }

    @Override
    public EntityType entityType(String name, String resourceBundleName) {
        return this.entityTypes().computeIfAbsent(Objects.requireNonNull(name, "name"), entityTypeName -> EntityType.entityType(entityTypeName, this, resourceBundleName));
    }

    @Override
    public boolean contains(EntityType entityType) {
        return this.entityTypes().containsKey(Objects.requireNonNull(entityType).name());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultDomainType that = (DefaultDomainType)object;
        return this.domainName.equals(that.domainName);
    }

    public int hashCode() {
        return this.domainName.hashCode();
    }

    public String toString() {
        return this.domainName;
    }

    private Map<String, EntityType> entityTypes() {
        return DOMAIN_ENTITY_TYPES.computeIfAbsent(this, k -> new ConcurrentHashMap());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        DOMAIN_TYPES.put(this.domainName, this);
    }

    static DomainType getOrCreateDomainType(String domainName) {
        return DOMAIN_TYPES.computeIfAbsent(Objects.requireNonNull(domainName), DefaultDomainType::new);
    }

    static DomainType getDomainType(String domainName) {
        DomainType domainType = DOMAIN_TYPES.get(Objects.requireNonNull(domainName, "domainName"));
        if (domainType == null) {
            throw new IllegalArgumentException("Domain: " + domainName + " has not been defined");
        }
        return domainType;
    }
}

