/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.attribute;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.DefaultAttribute;
import is.codion.framework.domain.entity.attribute.DerivedAttribute;
import is.codion.framework.domain.entity.attribute.TransientAttributeDefinition;
import is.codion.framework.domain.entity.attribute.TypeReference;
import java.util.Objects;

public interface Attribute<T> {
    public AttributeDefiner<T> define();

    public Type<T> type();

    public String name();

    public EntityType entityType();

    public static <T> Attribute<T> attribute(EntityType entityType, String name, TypeReference<T> typeReference) {
        return Attribute.attribute(entityType, name, Objects.requireNonNull(typeReference).rawType());
    }

    public static <T> Attribute<T> attribute(EntityType entityType, String name, Class<T> valueClass) {
        return new DefaultAttribute<T>(name, valueClass, entityType);
    }

    public static interface AttributeDefiner<T> {
        public <B extends TransientAttributeDefinition.Builder<T, B>> TransientAttributeDefinition.Builder<T, B> attribute();

        public <B extends AttributeDefinition.Builder<T, B>> AttributeDefinition.Builder<T, B> denormalized(Attribute<Entity> var1, Attribute<T> var2);

        public <B extends AttributeDefinition.Builder<T, B>> AttributeDefinition.Builder<T, B> derived(DerivedAttribute.Provider<T> var1, Attribute<?> ... var2);
    }

    public static interface Type<T> {
        public Class<T> valueClass();

        public T validateType(T var1);

        public boolean isNumerical();

        public boolean isTemporal();

        public boolean isLocalDate();

        public boolean isLocalDateTime();

        public boolean isLocalTime();

        public boolean isOffsetDateTime();

        public boolean isCharacter();

        public boolean isString();

        public boolean isLong();

        public boolean isInteger();

        public boolean isShort();

        public boolean isDouble();

        public boolean isBigDecimal();

        public boolean isDecimal();

        public boolean isBoolean();

        public boolean isByteArray();

        public boolean isEnum();

        public boolean isEntity();
    }
}

