/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.attribute;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.DefaultAttribute;
import is.codion.framework.domain.entity.attribute.DefaultForeignKeyDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.domain.entity.condition.ForeignKeyCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class DefaultForeignKey
implements ForeignKey,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Attribute<Entity> attribute;
    private final List<ForeignKey.Reference<?>> references;

    DefaultForeignKey(String name, EntityType entityType, List<ForeignKey.Reference<?>> references) {
        this.attribute = new DefaultAttribute<Entity>(name, Entity.class, entityType);
        this.references = this.validate(Objects.requireNonNull(references));
    }

    @Override
    public Attribute.Type<Entity> type() {
        return this.attribute.type();
    }

    @Override
    public String name() {
        return this.attribute.name();
    }

    @Override
    public EntityType entityType() {
        return this.attribute.entityType();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultForeignKey)) {
            return false;
        }
        DefaultForeignKey that = (DefaultForeignKey)object;
        return this.attribute.equals(that.attribute);
    }

    public int hashCode() {
        return this.attribute.hashCode();
    }

    public String toString() {
        return this.attribute.toString();
    }

    @Override
    public ForeignKey.ForeignKeyDefiner define() {
        return new DefaultForeignKeyDefiner(this);
    }

    @Override
    public EntityType referencedType() {
        return this.references.get(0).foreign().entityType();
    }

    @Override
    public List<ForeignKey.Reference<?>> references() {
        return this.references;
    }

    @Override
    public <T> ForeignKey.Reference<T> reference(Column<T> column) {
        Objects.requireNonNull(column);
        for (int i = 0; i < this.references.size(); ++i) {
            ForeignKey.Reference<?> reference = this.references.get(i);
            if (!reference.column().equals(column)) continue;
            return reference;
        }
        throw new IllegalArgumentException("Column " + column + " is not part of foreign key " + this.name());
    }

    @Override
    public Condition equalTo(Entity value) {
        return ForeignKeyCondition.factory(this).equalTo(value);
    }

    @Override
    public Condition notEqualTo(Entity value) {
        return ForeignKeyCondition.factory(this).notEqualTo(value);
    }

    @Override
    public Condition in(Entity ... values) {
        return ForeignKeyCondition.factory(this).in(values);
    }

    @Override
    public Condition notIn(Entity ... values) {
        return ForeignKeyCondition.factory(this).notIn(values);
    }

    @Override
    public Condition in(Collection<Entity> values) {
        return ForeignKeyCondition.factory(this).in(values);
    }

    @Override
    public Condition notIn(Collection<Entity> values) {
        return ForeignKeyCondition.factory(this).notIn(values);
    }

    @Override
    public Condition isNull() {
        return ForeignKeyCondition.factory(this).isNull();
    }

    @Override
    public Condition isNotNull() {
        return ForeignKeyCondition.factory(this).isNotNull();
    }

    private List<ForeignKey.Reference<?>> validate(List<ForeignKey.Reference<?>> references) {
        if (references.isEmpty()) {
            throw new IllegalArgumentException("No references provided for foreign key: " + this.name());
        }
        EntityType referencedEntityType = references.get(0).foreign().entityType();
        ArrayList referenceList = new ArrayList(references.size());
        for (ForeignKey.Reference<?> reference : references) {
            if (!this.entityType().equals(reference.column().entityType())) {
                throw new IllegalArgumentException("Entity type " + this.entityType() + " expected, got " + reference.column().entityType());
            }
            if (!referencedEntityType.equals(reference.foreign().entityType())) {
                throw new IllegalArgumentException("Entity type " + referencedEntityType + " expected, got " + reference.foreign().entityType());
            }
            if (referenceList.stream().anyMatch(existingReference -> existingReference.column().equals(reference.column()))) {
                throw new IllegalArgumentException("Foreign key already contains a reference for column: " + reference.column());
            }
            referenceList.add(reference);
        }
        return Collections.unmodifiableList(referenceList);
    }

    private static final class DefaultForeignKeyDefiner
    extends DefaultAttribute.DefaultAttributeDefiner<Entity>
    implements ForeignKey.ForeignKeyDefiner {
        private final ForeignKey foreignKey;

        private DefaultForeignKeyDefiner(ForeignKey foreignKey) {
            super(foreignKey);
            this.foreignKey = foreignKey;
        }

        @Override
        public ForeignKeyDefinition.Builder foreignKey() {
            return this.foreignKey((Integer)ForeignKeyDefinition.FOREIGN_KEY_FETCH_DEPTH.get());
        }

        @Override
        public ForeignKeyDefinition.Builder foreignKey(int fetchDepth) {
            return new DefaultForeignKeyDefinition.DefaultForeignKeyDefinitionBuilder(this.foreignKey, fetchDepth, false);
        }

        @Override
        public ForeignKeyDefinition.Builder softForeignKey() {
            return this.softForeignKey((Integer)ForeignKeyDefinition.FOREIGN_KEY_FETCH_DEPTH.get());
        }

        @Override
        public ForeignKeyDefinition.Builder softForeignKey(int fetchDepth) {
            return new DefaultForeignKeyDefinition.DefaultForeignKeyDefinitionBuilder(this.foreignKey, fetchDepth, true);
        }
    }

    static final class DefaultReference<T>
    implements ForeignKey.Reference<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Column<T> column;
        private final Column<T> foreign;

        DefaultReference(Column<T> column, Column<T> foreign) {
            if (Objects.requireNonNull(column, "column").equals(Objects.requireNonNull(foreign, "foreign"))) {
                throw new IllegalArgumentException("column and foreign column may not be the same");
            }
            this.column = column;
            this.foreign = foreign;
        }

        @Override
        public Column<T> column() {
            return this.column;
        }

        @Override
        public Column<T> foreign() {
            return this.foreign;
        }
    }
}

