/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.attribute;

import is.codion.common.Configuration;
import is.codion.common.format.LocaleDateTimePattern;
import is.codion.common.item.Item;
import is.codion.common.property.PropertyValue;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.AbstractAttributeDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;

public interface AttributeDefinition<T> {
    public static final int DEFAULT_MAXIMUM_FRACTION_DIGITS = 10;
    public static final PropertyValue<Integer> MAXIMUM_FRACTION_DIGITS = Configuration.integerValue((String)"codion.domain.maximumFractionDigits", (int)10);
    public static final PropertyValue<RoundingMode> DECIMAL_ROUNDING_MODE = Configuration.enumValue((String)"codion.domain.decimalRoundingMode", RoundingMode.class, (Enum)RoundingMode.HALF_EVEN);
    public static final PropertyValue<String> TIME_FORMAT = Configuration.stringValue((String)"codion.domain.timeFormat", (String)((String)LocaleDateTimePattern.builder().hoursMinutes().build().timePattern().orElseThrow(IllegalStateException::new)));
    public static final PropertyValue<String> DATE_TIME_FORMAT = Configuration.stringValue((String)"codion.domain.dateTimeFormat", (String)LocaleDateTimePattern.builder().delimiterDash().yearFourDigits().hoursMinutes().build().dateTimePattern());
    public static final PropertyValue<String> DATE_FORMAT = Configuration.stringValue((String)"codion.domain.dateFormat", (String)LocaleDateTimePattern.builder().delimiterDash().yearFourDigits().build().datePattern());
    public static final PropertyValue<Boolean> NUMBER_FORMAT_GROUPING = Configuration.booleanValue((String)"codion.domain.numberFormatGrouping", (boolean)false);
    public static final PropertyValue<Character> GROUPING_SEPARATOR = Configuration.characterValue((String)"codion.domain.groupingSeparator", (char)DecimalFormatSymbols.getInstance().getGroupingSeparator());
    public static final PropertyValue<Character> DECIMAL_SEPARATOR = Configuration.characterValue((String)"codion.domain.decimalSeparator", (char)DecimalFormatSymbols.getInstance().getDecimalSeparator());
    public static final PropertyValue<Boolean> USE_LEXICAL_STRING_COMPARATOR = Configuration.booleanValue((String)"codion.domain.useLexicalStringComparator", (boolean)true);

    public Attribute<T> attribute();

    public EntityType entityType();

    public String caption();

    public String description();

    public T prepareValue(T var1);

    public String string(T var1);

    public boolean hasDefaultValue();

    public T defaultValue();

    public boolean hidden();

    public Number maximumValue();

    public Number minimumValue();

    public int maximumFractionDigits();

    public RoundingMode decimalRoundingMode();

    public boolean nullable();

    public boolean derived();

    public boolean denormalized();

    public int maximumLength();

    public char mnemonic();

    public Format format();

    public String dateTimePattern();

    public DateTimeFormatter dateTimeFormatter();

    public Comparator<T> comparator();

    public boolean validItem(T var1);

    public List<Item<T>> items();

    public static Comparator<AttributeDefinition<?>> definitionComparator() {
        return new AbstractAttributeDefinition.DefinitionComparator();
    }

    public static interface Builder<T, B extends Builder<T, B>> {
        public Attribute<T> attribute();

        public B caption(String var1);

        public B captionResourceKey(String var1);

        public B defaultValue(T var1);

        public B defaultValue(ValueSupplier<T> var1);

        public B hidden(boolean var1);

        public B minimumValue(Number var1);

        public B maximumValue(Number var1);

        public B valueRange(Number var1, Number var2);

        public B maximumFractionDigits(int var1);

        public B decimalRoundingMode(RoundingMode var1);

        public B numberFormatGrouping(boolean var1);

        public B nullable(boolean var1);

        public B maximumLength(int var1);

        public B mnemonic(char var1);

        public B description(String var1);

        public B comparator(Comparator<T> var1);

        public B format(Format var1);

        public B dateTimePattern(String var1);

        public B localeDateTimePattern(LocaleDateTimePattern var1);

        public B items(List<Item<T>> var1);

        public AttributeDefinition<T> build();
    }

    public static interface ValueSupplier<T>
    extends Supplier<T>,
    Serializable {
    }
}

