/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Column;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class DefaultOrderBy
implements OrderBy,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<OrderBy.OrderByColumn> orderByColumns;

    private DefaultOrderBy(DefaultOrderByBuilder builder) {
        this.orderByColumns = Collections.unmodifiableList(builder.orderByColumns);
    }

    @Override
    public List<OrderBy.OrderByColumn> orderByColumns() {
        return this.orderByColumns;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultOrderBy)) {
            return false;
        }
        DefaultOrderBy that = (DefaultOrderBy)object;
        return this.orderByColumns.equals(that.orderByColumns);
    }

    public int hashCode() {
        return this.orderByColumns.hashCode();
    }

    public String toString() {
        return "OrderBy{orderByColumns=" + this.orderByColumns + "}";
    }

    static final class DefaultOrderByBuilder
    implements OrderBy.Builder {
        private final List<OrderBy.OrderByColumn> orderByColumns = new ArrayList<OrderBy.OrderByColumn>(1);

        DefaultOrderByBuilder() {
        }

        @Override
        public OrderBy.Builder ascending(Column<?> ... columns) {
            this.add(true, OrderBy.NullOrder.DEFAULT, false, Objects.requireNonNull(columns));
            return this;
        }

        @Override
        public OrderBy.Builder ascendingIgnoreCase(Column<String> ... columns) {
            this.add(true, OrderBy.NullOrder.DEFAULT, true, Objects.requireNonNull(columns));
            return this;
        }

        @Override
        public OrderBy.Builder ascending(OrderBy.NullOrder nullOrder, Column<?> ... columns) {
            this.add(true, Objects.requireNonNull(nullOrder), false, Objects.requireNonNull(columns));
            return this;
        }

        @Override
        public OrderBy.Builder ascendingIgnoreCase(OrderBy.NullOrder nullOrder, Column<String> ... columns) {
            this.add(true, Objects.requireNonNull(nullOrder), true, Objects.requireNonNull(columns));
            return this;
        }

        @Override
        public OrderBy.Builder descending(Column<?> ... columns) {
            this.add(false, OrderBy.NullOrder.DEFAULT, false, Objects.requireNonNull(columns));
            return this;
        }

        @Override
        public OrderBy.Builder descendingIgnoreCase(Column<?> ... columns) {
            this.add(false, OrderBy.NullOrder.DEFAULT, true, Objects.requireNonNull(columns));
            return this;
        }

        @Override
        public OrderBy.Builder descending(OrderBy.NullOrder nullOrder, Column<?> ... columns) {
            this.add(false, Objects.requireNonNull(nullOrder), false, Objects.requireNonNull(columns));
            return this;
        }

        @Override
        public OrderBy.Builder descendingIgnoreCase(OrderBy.NullOrder nullOrder, Column<String> ... columns) {
            this.add(false, Objects.requireNonNull(nullOrder), true, Objects.requireNonNull(columns));
            return this;
        }

        @Override
        public OrderBy build() {
            return new DefaultOrderBy(this);
        }

        private void add(boolean ascending, OrderBy.NullOrder nullOrder, boolean ignoreCase, Column<?> ... columns) {
            if (columns.length == 0) {
                throw new IllegalArgumentException("One or more columns required for order by");
            }
            for (Column<?> column : columns) {
                for (OrderBy.OrderByColumn orderByColumn : this.orderByColumns) {
                    if (!Objects.requireNonNull(column).equals(orderByColumn.column())) continue;
                    throw new IllegalArgumentException("Order by already contains column: " + column);
                }
                this.orderByColumns.add(new DefaultOrderByColumn(column, nullOrder, ascending, ignoreCase));
            }
        }
    }

    private static final class DefaultOrderByColumn
    implements OrderBy.OrderByColumn,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Column<?> column;
        private final OrderBy.NullOrder nullOrder;
        private final boolean ascending;
        private final boolean ignoreCase;

        private DefaultOrderByColumn(Column<?> column, OrderBy.NullOrder nullOrder, boolean ascending, boolean ignoreCase) {
            this.column = Objects.requireNonNull(column, "column");
            this.nullOrder = Objects.requireNonNull(nullOrder, "nullOrder");
            this.ascending = ascending;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public Column<?> column() {
            return this.column;
        }

        @Override
        public OrderBy.NullOrder nullOrder() {
            return this.nullOrder;
        }

        @Override
        public boolean ascending() {
            return this.ascending;
        }

        @Override
        public boolean ignoreCase() {
            return this.ignoreCase;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DefaultOrderByColumn that = (DefaultOrderByColumn)object;
            return this.column.equals(that.column) && this.nullOrder.equals((Object)that.nullOrder) && this.ascending == that.ascending && this.ignoreCase == that.ignoreCase;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.column, this.nullOrder, this.ascending, this.ignoreCase});
        }

        public String toString() {
            return "OrderByColumn{column=" + this.column + ", nullOrder=" + this.nullOrder + ", ascending=" + this.ascending + ", ignoreCase=" + this.ignoreCase + "}";
        }
    }
}

