/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain;

import is.codion.common.db.connection.DatabaseConnection;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.operation.DatabaseFunction;
import is.codion.common.db.operation.DatabaseProcedure;
import is.codion.common.db.operation.FunctionType;
import is.codion.common.db.operation.ProcedureType;
import is.codion.common.db.report.Report;
import is.codion.common.db.report.ReportType;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.Entities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public interface Domain {
    public DomainType type();

    public Entities entities();

    public Map<ReportType<?, ?, ?>, Report<?, ?, ?>> reports();

    public Map<ProcedureType<?, ?>, DatabaseProcedure<?, ?>> procedures();

    public Map<FunctionType<?, ?, ?>, DatabaseFunction<?, ?, ?>> functions();

    public <T, R, P> Report<T, R, P> report(ReportType<T, R, P> var1);

    public <C, T> DatabaseProcedure<C, T> procedure(ProcedureType<C, T> var1);

    public <C, T, R> DatabaseFunction<C, T, R> function(FunctionType<C, T, R> var1);

    default public void configureConnection(DatabaseConnection connection) throws DatabaseException {
    }

    default public void configureDatabase(Database database) throws DatabaseException {
    }

    public static List<Domain> domains() {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        try {
            ServiceLoader<Domain> loader = ServiceLoader.load(Domain.class);
            for (Domain domain : loader) {
                domains.add(domain);
            }
            return Collections.unmodifiableList(domains);
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

