/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.condition;

import is.codion.common.Operator;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.AbstractColumnCondition;
import java.util.Arrays;

final class DualValueColumnCondition<T>
extends AbstractColumnCondition<T> {
    private static final long serialVersionUID = 1L;

    DualValueColumnCondition(Column<T> column, T lowerBound, T upperBound, Operator operator) {
        super(column, operator, Arrays.asList(lowerBound, upperBound), true);
        this.validateOperator(operator);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DualValueColumnCondition)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "DualValueColumnCondition{column=" + this.column() + ", operator=" + this.operator() + ", values=" + this.values() + ", caseSensitive=" + this.caseSensitive() + "}";
    }

    @Override
    protected String toString(String columnExpression) {
        switch (this.operator()) {
            case BETWEEN: {
                return "(" + columnExpression + " >= ? AND " + columnExpression + " <= ?)";
            }
            case NOT_BETWEEN: {
                return "(" + columnExpression + " < ? OR " + columnExpression + " > ?)";
            }
            case BETWEEN_EXCLUSIVE: {
                return "(" + columnExpression + " > ? AND " + columnExpression + " < ?)";
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return "(" + columnExpression + " <= ? OR " + columnExpression + " >= ?)";
            }
        }
        throw new IllegalStateException("Unsupported dual value operator: " + this.operator());
    }

    @Override
    protected void validateOperator(Operator operator) {
        switch (operator) {
            case BETWEEN: 
            case NOT_BETWEEN: 
            case BETWEEN_EXCLUSIVE: 
            case NOT_BETWEEN_EXCLUSIVE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported dual value operator: " + operator);
            }
        }
    }
}

