/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.common.db.connection.DatabaseConnection;
import is.codion.framework.domain.entity.AutomaticKeyGenerator;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.IdentityKeyGenerator;
import is.codion.framework.domain.entity.QueryKeyGenerator;
import is.codion.framework.domain.entity.SequenceKeyGenerator;
import java.sql.SQLException;
import java.sql.Statement;

public interface KeyGenerator {
    default public boolean inserted() {
        return true;
    }

    default public void beforeInsert(Entity entity, DatabaseConnection connection) throws SQLException {
    }

    default public void afterInsert(Entity entity, DatabaseConnection connection, Statement insertStatement) throws SQLException {
    }

    default public boolean returnGeneratedKeys() {
        return false;
    }

    public static KeyGenerator sequence(String sequenceName) {
        return new SequenceKeyGenerator(sequenceName);
    }

    public static KeyGenerator queried(String query) {
        return new QueryKeyGenerator(query);
    }

    public static KeyGenerator automatic(String valueSource) {
        return new AutomaticKeyGenerator(valueSource);
    }

    public static KeyGenerator identity() {
        return IdentityKeyGenerator.INSTANCE;
    }
}

