/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.framework.domain.entity.DefaultEntity;
import is.codion.framework.domain.entity.DefaultKey;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class EntitySerializer {
    private final Entities entities;
    private final boolean strictDeserialization;

    EntitySerializer(Entities entities, boolean strictDeserialization) {
        this.entities = Objects.requireNonNull(entities);
        this.strictDeserialization = strictDeserialization;
    }

    static void serialize(DefaultEntity entity, ObjectOutputStream stream) throws IOException {
        stream.writeObject(entity.definition.entityType().name());
        EntitySerializer.serializeValues(entity, stream);
    }

    void deserialize(DefaultEntity entity, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        entity.definition = this.entities.definition((String)stream.readObject());
        this.deserializeValues(entity, stream);
    }

    static void serialize(DefaultKey key, ObjectOutputStream stream) throws IOException {
        stream.writeObject(key.definition.entityType().name());
        EntitySerializer.serializeValues(key, stream);
    }

    void deserialize(DefaultKey key, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        key.definition = this.entities.definition((String)stream.readObject());
        this.deserializeValues(key, stream);
    }

    private void deserializeValues(DefaultEntity entity, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        entity.values = this.deserializeValues(entity.definition, stream.readInt(), stream);
        if (stream.readBoolean()) {
            entity.originalValues = this.deserializeValues(entity.definition, stream.readInt(), stream);
        }
    }

    private Map<Attribute<?>, Object> deserializeValues(EntityDefinition definition, int valueCount, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        HashMap map = new HashMap(valueCount);
        for (int i = 0; i < valueCount; ++i) {
            Attribute<Object> attribute = this.attributeByName(definition, (String)stream.readObject());
            Object value = stream.readObject();
            if (attribute == null) continue;
            map.put(attribute, attribute.type().validateType(value));
        }
        return map;
    }

    private void deserializeValues(DefaultKey key, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        key.primaryKey = stream.readBoolean();
        int valueCount = stream.readInt();
        key.columns = new ArrayList(valueCount);
        key.values = new HashMap(valueCount);
        for (int i = 0; i < valueCount; ++i) {
            Column attribute = (Column)this.attributeByName(key.definition, (String)stream.readObject());
            Object value = stream.readObject();
            if (attribute == null) continue;
            key.columns.add(attribute);
            key.values.put(attribute, attribute.type().validateType(value));
        }
        key.columns = Collections.unmodifiableList(key.columns);
        key.values = Collections.unmodifiableMap(key.values);
        key.singleIntegerKey = valueCount == 1 && EntitySerializer.singleIntegerKey(key);
        key.hashCodeDirty = true;
    }

    private Attribute<Object> attributeByName(EntityDefinition definition, String attributeName) throws IOException {
        Attribute<Object> attribute = definition.attributes().get(attributeName);
        if (attribute == null && this.strictDeserialization) {
            throw new IOException("Attribute '" + attributeName + "' not found in entity '" + definition.entityType().name() + "'");
        }
        return attribute;
    }

    private static void serializeValues(DefaultEntity entity, ObjectOutputStream stream) throws IOException {
        entity.clearDerivedCache();
        EntitySerializer.serializeValues(entity.values, stream);
        boolean modified = entity.originalValues != null;
        stream.writeBoolean(modified);
        if (modified) {
            EntitySerializer.serializeValues(entity.originalValues, stream);
        }
    }

    private static void serializeValues(Map<Attribute<?>, Object> valueMap, ObjectOutputStream stream) throws IOException {
        stream.writeInt(valueMap.size());
        for (Map.Entry<Attribute<?>, Object> entry : valueMap.entrySet()) {
            stream.writeObject(entry.getKey().name());
            stream.writeObject(entry.getValue());
        }
    }

    private static void serializeValues(DefaultKey key, ObjectOutputStream stream) throws IOException {
        stream.writeBoolean(key.primaryKey);
        stream.writeInt(key.columns.size());
        for (int i = 0; i < key.columns.size(); ++i) {
            Attribute attribute = key.columns.get(i);
            stream.writeObject(attribute.name());
            stream.writeObject(key.values.get(attribute));
        }
    }

    private static boolean singleIntegerKey(DefaultKey key) {
        return key.columns.size() == 1 && key.columns.get(0).type().isInteger();
    }
}

