/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.framework.domain.entity.DefaultEntityBuilder;
import is.codion.framework.domain.entity.DefaultEntityExists;
import is.codion.framework.domain.entity.DefaultEntityValidator;
import is.codion.framework.domain.entity.DefaultKey;
import is.codion.framework.domain.entity.DefaultKeyGenerator;
import is.codion.framework.domain.entity.DefaultStringFactory;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntitySerializer;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.EntityValidator;
import is.codion.framework.domain.entity.ImmutableEntity;
import is.codion.framework.domain.entity.NullColorProvider;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.DerivedAttribute;
import is.codion.framework.domain.entity.attribute.DerivedAttributeDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.attribute.TransientAttributeDefinition;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

class DefaultEntity
implements Entity,
Serializable {
    private static final long serialVersionUID = 1L;
    static final DefaultKeyGenerator DEFAULT_KEY_GENERATOR = new DefaultKeyGenerator();
    static final DefaultStringFactory DEFAULT_STRING_FACTORY = new DefaultStringFactory();
    static final NullColorProvider NULL_COLOR_PROVIDER = new NullColorProvider();
    static final EntityValidator DEFAULT_VALIDATOR = new DefaultEntityValidator();
    static final Predicate<Entity> DEFAULT_EXISTS = new DefaultEntityExists();
    protected EntityDefinition definition;
    protected Map<Attribute<?>, Object> values;
    protected Map<Attribute<?>, Object> originalValues;
    private String toString;
    private Map<ForeignKey, Entity.Key> keyCache;
    private Entity.Key primaryKey;

    protected DefaultEntity() {
    }

    DefaultEntity(Entity.Key key) {
        this(Objects.requireNonNull(key).entityDefinition(), DefaultEntity.createValueMap(key), null);
        if (key.primaryKey()) {
            this.primaryKey = key;
        }
    }

    DefaultEntity(EntityDefinition definition, Map<Attribute<?>, Object> values, Map<Attribute<?>, Object> originalValues) {
        this.values = DefaultEntity.validateTypes(Objects.requireNonNull(definition), values == null ? new HashMap() : new HashMap(values));
        this.originalValues = DefaultEntity.validateTypes(definition, originalValues == null ? null : new HashMap(originalValues));
        this.definition = definition;
    }

    @Override
    public final EntityType entityType() {
        return this.definition.entityType();
    }

    @Override
    public final EntityDefinition definition() {
        return this.definition;
    }

    @Override
    public final Entity.Key primaryKey() {
        if (this.primaryKey == null) {
            this.primaryKey = this.createPrimaryKey(false);
        }
        return this.primaryKey;
    }

    @Override
    public final Entity.Key originalPrimaryKey() {
        return this.createPrimaryKey(true);
    }

    @Override
    public final boolean modified() {
        if (this.originalValues != null) {
            for (Attribute<?> attribute : this.originalValues.keySet()) {
                ColumnDefinition columnDefinition;
                AttributeDefinition<?> attributeDefinition = this.definition.attributes().definition(attribute);
                if (attributeDefinition instanceof ColumnDefinition && (columnDefinition = (ColumnDefinition)attributeDefinition).insertable() && columnDefinition.updatable()) {
                    return true;
                }
                if (!(attributeDefinition instanceof TransientAttributeDefinition) || !((TransientAttributeDefinition)attributeDefinition).modifiesEntity()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final <T> T get(Attribute<T> attribute) {
        return this.cached(this.definition.attributes().definition(attribute));
    }

    @Override
    public final <T> Optional<T> optional(Attribute<T> attribute) {
        return Optional.ofNullable(this.get(attribute));
    }

    @Override
    public final <T> T original(Attribute<T> attribute) {
        return this.original(this.definition.attributes().definition(attribute));
    }

    @Override
    public final boolean isNull(Attribute<?> attribute) {
        return this.isNull(this.definition.attributes().definition(attribute));
    }

    @Override
    public final boolean isNotNull(Attribute<?> attribute) {
        return !this.isNull(attribute);
    }

    @Override
    public final boolean modified(Attribute<?> attribute) {
        this.definition.attributes().definition(attribute);
        return this.isModified(attribute);
    }

    @Override
    public final boolean exists() {
        return this.definition.exists().test(this);
    }

    @Override
    public final Entity entity(ForeignKey foreignKey) {
        Entity.Key key;
        Entity entity = (Entity)this.values.get(Objects.requireNonNull(foreignKey));
        if (entity == null && (key = this.key(foreignKey)) != null) {
            return new DefaultEntity(key);
        }
        return entity;
    }

    @Override
    public final <T> String string(Attribute<T> attribute) {
        Entity.Key key;
        AttributeDefinition<T> attributeDefinition = this.definition.attributes().definition(attribute);
        if (attribute instanceof ForeignKey && this.values.get(attribute) == null && (key = this.key((ForeignKey)attribute)) != null) {
            return key.toString();
        }
        return attributeDefinition.string(this.cached(attributeDefinition));
    }

    @Override
    public <T> T put(Attribute<T> attribute, T value) {
        return this.put(this.definition.attributes().definition(attribute), value);
    }

    @Override
    public Entity clearPrimaryKey() {
        this.definition.primaryKey().columns().forEach(this::remove);
        this.primaryKey = null;
        return this;
    }

    @Override
    public void save(Attribute<?> attribute) {
        this.removeOriginalValue(Objects.requireNonNull(attribute));
    }

    @Override
    public void save() {
        this.originalValues = null;
    }

    @Override
    public void revert(Attribute<?> attribute) {
        AttributeDefinition<?> attributeDefinition = this.definition.attributes().definition(attribute);
        if (this.isModified(attribute)) {
            this.put(attributeDefinition, this.original(attributeDefinition));
        }
    }

    @Override
    public void revert() {
        if (this.originalValues != null) {
            for (Attribute<?> attribute : new ArrayList(this.originalValues.keySet())) {
                this.revert(attribute);
            }
        }
    }

    @Override
    public <T> T remove(Attribute<T> attribute) {
        AttributeDefinition<T> attributeDefinition = this.definition.attributes().definition(attribute);
        Object value = null;
        if (this.values.containsKey(attribute)) {
            value = this.values.remove(attribute);
            this.removeOriginalValue(attribute);
            if (attributeDefinition instanceof ColumnDefinition && ((ColumnDefinition)attributeDefinition).primaryKey()) {
                this.primaryKey = null;
            }
            if (attribute instanceof Column) {
                this.definition.foreignKeys().definitions((Column)attribute).forEach(foreignKey -> this.remove(foreignKey.attribute()));
            }
        }
        return (T)value;
    }

    @Override
    public Map<Attribute<?>, Object> set(Entity entity) {
        if (entity == this) {
            return Collections.emptyMap();
        }
        if (entity != null && !this.definition.entityType().equals(entity.entityType())) {
            throw new IllegalArgumentException("Entity of type: " + this.definition.entityType() + " expected, got: " + entity.entityType());
        }
        return this.populateValues(entity);
    }

    @Override
    public final Entity copy() {
        DefaultEntity entity = new DefaultEntity(this.definition, null, null);
        entity.set(this);
        return entity;
    }

    @Override
    public final Entity.Builder copyBuilder() {
        return new DefaultEntityBuilder(this.definition, this.values, this.originalValues);
    }

    @Override
    public final Entity deepCopy() {
        return this.deepCopy(new HashMap<Entity.Key, Entity>());
    }

    @Override
    public final Entity immutable() {
        if (!this.mutable()) {
            return this;
        }
        return new ImmutableEntity(this);
    }

    @Override
    public final boolean mutable() {
        return !(this instanceof ImmutableEntity);
    }

    @Override
    public boolean equalValues(Entity entity) {
        return this.equalValues(entity, this.definition.attributes().get());
    }

    @Override
    public final boolean equalValues(Entity entity, Collection<? extends Attribute<?>> attributes) {
        if (!this.definition.entityType().equals(Objects.requireNonNull(entity).entityType())) {
            throw new IllegalArgumentException("Entity of type: " + this.definition.entityType() + " expected, got: " + entity.entityType());
        }
        return Objects.requireNonNull(attributes).stream().allMatch(attribute -> this.valueEqual(entity, (Attribute<?>)attribute));
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof Entity && this.primaryKey().equals(((Entity)obj).primaryKey());
    }

    @Override
    public final int compareTo(Entity entity) {
        return this.definition.comparator().compare(this, entity);
    }

    public final int hashCode() {
        return this.primaryKey().hashCode();
    }

    public final String toString() {
        if (this.toString == null) {
            this.toString = this.createToString();
        }
        return this.toString;
    }

    @Override
    public final Entity.Key key(ForeignKey foreignKey) {
        this.definition.foreignKeys().definition(foreignKey);
        Entity.Key cachedReferencedKey = this.cachedKey(foreignKey);
        if (cachedReferencedKey != null) {
            return cachedReferencedKey;
        }
        return this.createAndCacheReferencedKey(foreignKey);
    }

    @Override
    public final boolean contains(Attribute<?> attribute) {
        return this.values.containsKey(Objects.requireNonNull(attribute));
    }

    @Override
    public final Set<Map.Entry<Attribute<?>, Object>> entrySet() {
        return Collections.unmodifiableSet(this.values.entrySet());
    }

    @Override
    public final Set<Map.Entry<Attribute<?>, Object>> originalEntrySet() {
        if (this.originalValues == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.originalValues.entrySet());
    }

    void clearDerivedCache() {
        this.definition.attributes().get().forEach(this::clearDerivedCache);
    }

    private String createToString() {
        String string = this.definition.stringFactory().apply(this);
        if (string == null) {
            return DEFAULT_STRING_FACTORY.apply(this);
        }
        return string;
    }

    private void clear() {
        this.values.clear();
        this.originalValues = null;
        this.primaryKey = null;
        this.keyCache = null;
        this.toString = null;
    }

    private Map<Attribute<?>, Object> populateValues(Entity entity) {
        Map<Attribute<?>, Object> previousValues = this.currentValues();
        this.clear();
        if (entity != null) {
            entity.entrySet().forEach(entry -> this.values.put((Attribute)entry.getKey(), entry.getValue()));
            Set<Map.Entry<Attribute<?>, Object>> originalEntrySet = entity.originalEntrySet();
            if (!originalEntrySet.isEmpty()) {
                this.originalValues = new HashMap();
                originalEntrySet.forEach(entry -> this.originalValues.put((Attribute)entry.getKey(), entry.getValue()));
            }
        }
        previousValues.entrySet().removeIf(new Unmodified());
        return Collections.unmodifiableMap(previousValues);
    }

    private Map<Attribute<?>, Object> currentValues() {
        return this.definition.attributes().definitions().stream().collect(HashMap::new, (map, attributeDefinition) -> map.put(attributeDefinition.attribute(), this.get((AttributeDefinition)attributeDefinition)), HashMap::putAll);
    }

    private <T> T get(AttributeDefinition<T> attributeDefinition) {
        if (attributeDefinition.derived()) {
            return this.derived((DerivedAttributeDefinition)attributeDefinition);
        }
        return (T)this.values.get(attributeDefinition.attribute());
    }

    private <T> T cached(AttributeDefinition<T> attributeDefinition) {
        if (attributeDefinition.derived()) {
            return this.derivedCached((DerivedAttributeDefinition)attributeDefinition);
        }
        return (T)this.values.get(attributeDefinition.attribute());
    }

    private <T> T original(AttributeDefinition<T> attributeDefinition) {
        if (attributeDefinition.derived()) {
            return this.derivedOriginal((DerivedAttributeDefinition)attributeDefinition);
        }
        if (this.isModified(attributeDefinition.attribute())) {
            return (T)this.originalValues.get(attributeDefinition.attribute());
        }
        return this.get(attributeDefinition);
    }

    private <T> T put(AttributeDefinition<T> attributeDefinition, T value) {
        T newValue = this.validateAndPrepareValue(attributeDefinition, value);
        Attribute<T> attribute = attributeDefinition.attribute();
        boolean initialization = !this.values.containsKey(attribute);
        Object previousValue = this.values.put(attribute, newValue);
        if (!initialization && Objects.equals(previousValue, newValue)) {
            return newValue;
        }
        if (!initialization) {
            this.updateOriginalValue(attribute, newValue, previousValue);
        }
        if (attributeDefinition instanceof ColumnDefinition) {
            this.updateRelatedKeys((ColumnDefinition)attributeDefinition, newValue);
        }
        if (attributeDefinition instanceof ForeignKeyDefinition) {
            this.updateReferencedColumns((ForeignKeyDefinition)attributeDefinition, (Entity)newValue);
        }
        this.clearDerivedCache(attribute);
        this.toString = null;
        return (T)previousValue;
    }

    private void clearDerivedCache(Attribute<? extends Object> sourceAttribute) {
        Collection<Attribute<?>> derivedFrom = this.definition.attributes().derivedFrom(sourceAttribute);
        if (!derivedFrom.isEmpty()) {
            derivedFrom.forEach(this.values::remove);
            derivedFrom.forEach(this::clearDerivedCache);
        }
    }

    private <T> boolean isNull(AttributeDefinition<T> attributeDefinition) {
        if (attributeDefinition instanceof ForeignKeyDefinition) {
            return this.isReferenceNull(((ForeignKeyDefinition)attributeDefinition).attribute());
        }
        return this.cached(attributeDefinition) == null;
    }

    private boolean isReferenceNull(ForeignKey foreignKey) {
        List<ForeignKey.Reference<?>> references = foreignKey.references();
        if (references.size() == 1) {
            return this.isNull(references.get(0).column());
        }
        EntityDefinition referencedEntity = this.definition.foreignKeys().referencedBy(foreignKey);
        for (int i = 0; i < references.size(); ++i) {
            ForeignKey.Reference<?> reference = references.get(i);
            ColumnDefinition<?> referencedColumn = referencedEntity.columns().definition(reference.foreign());
            if (referencedColumn.nullable() || !this.isNull(reference.column())) continue;
            return true;
        }
        return false;
    }

    private <T> T validateAndPrepareValue(AttributeDefinition<T> attributeDefinition, T value) {
        if (attributeDefinition.derived()) {
            throw new IllegalArgumentException("Can not set the value of a derived attribute");
        }
        if (value != null && !attributeDefinition.validItem(value)) {
            throw new IllegalArgumentException("Invalid item value: " + value + " for attribute " + attributeDefinition.attribute());
        }
        if (value != null && attributeDefinition instanceof ForeignKeyDefinition) {
            this.validateForeignKeyValue((ForeignKeyDefinition)attributeDefinition, (Entity)value);
        }
        return attributeDefinition.prepareValue(attributeDefinition.attribute().type().validateType(value));
    }

    private void validateForeignKeyValue(ForeignKeyDefinition foreignKeyDefinition, Entity foreignKeyValue) {
        EntityType referencedType = foreignKeyDefinition.attribute().referencedType();
        if (!Objects.equals(referencedType, foreignKeyValue.entityType())) {
            throw new IllegalArgumentException("Entity of type " + referencedType + " expected for foreign key " + foreignKeyDefinition + ", got: " + foreignKeyValue.entityType());
        }
        for (ForeignKey.Reference<?> reference : foreignKeyDefinition.references()) {
            this.throwIfModifiesReadOnlyReference(foreignKeyDefinition, foreignKeyValue, reference);
        }
    }

    private void throwIfModifiesReadOnlyReference(ForeignKeyDefinition foreignKeyDefinition, Entity foreignKeyValue, ForeignKey.Reference<?> reference) {
        Object newReferenceValue;
        Object currentReferenceValue;
        boolean containsValue;
        boolean readOnlyReference = foreignKeyDefinition.readOnly(reference.column());
        if (readOnlyReference && (containsValue = this.contains(reference.column())) && !Objects.equals(currentReferenceValue = this.get(reference.column()), newReferenceValue = foreignKeyValue.get(reference.foreign()))) {
            throw new IllegalArgumentException("Foreign key " + foreignKeyDefinition + " is not allowed to modify read-only reference: " + reference.column() + " from " + currentReferenceValue + " to " + newReferenceValue);
        }
    }

    private <T> void updateRelatedKeys(ColumnDefinition<T> columnDefinition, T newValue) {
        if (columnDefinition.primaryKey()) {
            this.primaryKey = null;
        }
        if (this.definition.foreignKeys().foreignKeyColumn((Column<?>)columnDefinition.attribute())) {
            this.removeInvalidForeignKeyValues((Column<T>)columnDefinition.attribute(), newValue);
        }
    }

    private <T> void removeInvalidForeignKeyValues(Column<T> column, T value) {
        for (ForeignKeyDefinition foreignKeyDefinition : this.definition.foreignKeys().definitions(column)) {
            ForeignKey foreignKey;
            Entity foreignKeyEntity = this.get(foreignKeyDefinition);
            if (foreignKeyEntity == null || Objects.equals(value, foreignKeyEntity.get((foreignKey = foreignKeyDefinition.attribute()).reference(column).foreign()))) continue;
            this.remove(foreignKey);
            this.removeCachedKey(foreignKey);
        }
    }

    private void updateReferencedColumns(ForeignKeyDefinition foreignKeyDefinition, Entity referencedEntity) {
        this.removeCachedKey(foreignKeyDefinition.attribute());
        List<ForeignKey.Reference<?>> references = foreignKeyDefinition.references();
        for (int i = 0; i < references.size(); ++i) {
            ForeignKey.Reference<?> reference = references.get(i);
            if (foreignKeyDefinition.readOnly(reference.column())) continue;
            ColumnDefinition<?> columnDefinition = this.definition.columns().definition(reference.column());
            this.put(columnDefinition, referencedEntity == null ? null : (Object)referencedEntity.get(reference.foreign()));
        }
    }

    private Entity.Key createAndCacheReferencedKey(ForeignKey foreignKey) {
        EntityDefinition referencedEntity = this.definition.foreignKeys().referencedBy(foreignKey);
        List<ForeignKey.Reference<?>> references = foreignKey.references();
        if (references.size() > 1) {
            return this.createAndCacheCompositeReferenceKey(foreignKey, references, referencedEntity);
        }
        return this.createAndCacheSingleReferenceKey(foreignKey, references.get(0), referencedEntity);
    }

    private Entity.Key createAndCacheCompositeReferenceKey(ForeignKey foreignKey, List<ForeignKey.Reference<?>> references, EntityDefinition referencedEntity) {
        HashMap keyValues = new HashMap(references.size());
        for (int i = 0; i < references.size(); ++i) {
            ForeignKey.Reference<?> reference = references.get(i);
            ColumnDefinition<?> referencedColumn = referencedEntity.columns().definition(reference.foreign());
            Object value = this.values.get(reference.column());
            if (value == null && !referencedColumn.nullable()) {
                return null;
            }
            keyValues.put(reference.foreign(), value);
        }
        Set referencedColumns = keyValues.keySet();
        List<Column<?>> primaryKeyColumns = referencedEntity.primaryKey().columns();
        boolean isPrimaryKey = referencedColumns.size() == primaryKeyColumns.size() && referencedColumns.containsAll(primaryKeyColumns);
        return this.cacheKey(foreignKey, new DefaultKey(referencedEntity, keyValues, isPrimaryKey));
    }

    private Entity.Key createAndCacheSingleReferenceKey(ForeignKey foreignKey, ForeignKey.Reference<?> reference, EntityDefinition referencedEntityDefinition) {
        Object value = this.values.get(reference.column());
        if (value == null) {
            return null;
        }
        List<Column<?>> primaryKeyColumns = referencedEntityDefinition.primaryKey().columns();
        boolean isPrimaryKey = primaryKeyColumns.size() == 1 && reference.foreign().equals(primaryKeyColumns.get(0));
        return this.cacheKey(foreignKey, new DefaultKey(this.definition.foreignKeys().referencedBy(foreignKey), reference.foreign(), value, isPrimaryKey));
    }

    private Entity.Key cacheKey(ForeignKey foreignKey, Entity.Key key) {
        if (this.keyCache == null) {
            this.keyCache = new HashMap<ForeignKey, Entity.Key>();
        }
        this.keyCache.put(foreignKey, key);
        return key;
    }

    private Entity.Key cachedKey(ForeignKey foreignKey) {
        if (this.keyCache == null) {
            return null;
        }
        return this.keyCache.get(foreignKey);
    }

    private void removeCachedKey(ForeignKey foreignKey) {
        if (this.keyCache != null) {
            this.keyCache.remove(foreignKey);
            if (this.keyCache.isEmpty()) {
                this.keyCache = null;
            }
        }
    }

    private Entity.Key createPrimaryKey(boolean originalValues) {
        if (this.definition.primaryKey().columns().isEmpty()) {
            return this.createPseudoPrimaryKey(originalValues);
        }
        List<Column<?>> primaryKeyColumns = this.definition.primaryKey().columns();
        if (primaryKeyColumns.size() == 1) {
            return this.createSingleColumnPrimaryKey(primaryKeyColumns.get(0), originalValues);
        }
        return this.createMultiColumnPrimaryKey(primaryKeyColumns, originalValues);
    }

    private DefaultKey createPseudoPrimaryKey(boolean originalValues) {
        HashMap allColumnValues = new HashMap();
        this.values.keySet().stream().map(attribute -> this.definition.attributes().definition(attribute)).filter(ColumnDefinition.class::isInstance).map(attributeDefinition -> (ColumnDefinition)attributeDefinition).forEach(columnDefinition -> allColumnValues.put((Column<?>)columnDefinition.attribute(), originalValues ? this.original(columnDefinition.attribute()) : this.values.get(columnDefinition.attribute())));
        return new DefaultKey(this.definition, allColumnValues, false);
    }

    private DefaultKey createSingleColumnPrimaryKey(Column<?> column, boolean originalValues) {
        return new DefaultKey(this.definition, column, originalValues ? this.original(column) : this.values.get(column), true);
    }

    private DefaultKey createMultiColumnPrimaryKey(List<Column<?>> primaryKeyColumn, boolean originalValues) {
        HashMap keyValues = new HashMap(primaryKeyColumn.size());
        for (int i = 0; i < primaryKeyColumn.size(); ++i) {
            Column<?> column = primaryKeyColumn.get(i);
            keyValues.put(column, originalValues ? this.original(column) : this.values.get(column));
        }
        return new DefaultKey(this.definition, keyValues, true);
    }

    private <T> T derivedCached(DerivedAttributeDefinition<T> attributeDefinition) {
        if (this.values.containsKey(attributeDefinition.attribute())) {
            return (T)this.values.get(attributeDefinition.attribute());
        }
        T derivedValue = this.derived(attributeDefinition);
        if (!attributeDefinition.denormalized()) {
            this.values.put(attributeDefinition.attribute(), derivedValue);
        }
        return derivedValue;
    }

    private <T> T derived(DerivedAttributeDefinition<T> derivedDefinition) {
        return derivedDefinition.valueProvider().get(this.sourceValues(derivedDefinition, false));
    }

    private <T> T derivedOriginal(DerivedAttributeDefinition<T> derivedDefinition) {
        return derivedDefinition.valueProvider().get(this.sourceValues(derivedDefinition, true));
    }

    private DerivedAttribute.SourceValues sourceValues(DerivedAttributeDefinition<?> derivedDefinition, boolean originalValue) {
        List<Attribute<?>> sourceAttributes = derivedDefinition.sourceAttributes();
        if (sourceAttributes.isEmpty()) {
            return new DefaultSourceValues(derivedDefinition.attribute(), Collections.emptyMap());
        }
        if (sourceAttributes.size() == 1) {
            return new DefaultSourceValues(derivedDefinition.attribute(), this.createSingleAttributeSourceValueMap(sourceAttributes.get(0), originalValue));
        }
        return new DefaultSourceValues(derivedDefinition.attribute(), this.createMultiAttributeSourceValueMap(sourceAttributes, originalValue));
    }

    private Map<Attribute<?>, Object> createSingleAttributeSourceValueMap(Attribute<?> sourceAttribute, boolean originalValue) {
        return Collections.singletonMap(sourceAttribute, originalValue ? this.original(sourceAttribute) : this.get(sourceAttribute));
    }

    private Map<Attribute<?>, Object> createMultiAttributeSourceValueMap(List<Attribute<?>> sourceAttributes, boolean originalValue) {
        HashMap valueMap = new HashMap(sourceAttributes.size());
        for (int i = 0; i < sourceAttributes.size(); ++i) {
            Attribute<?> sourceAttribute = sourceAttributes.get(i);
            valueMap.put(sourceAttribute, originalValue ? this.original(sourceAttribute) : this.get(sourceAttribute));
        }
        return valueMap;
    }

    private <T> void setOriginalValue(Attribute<T> attribute, T originalValue) {
        if (this.originalValues == null) {
            this.originalValues = new HashMap();
        }
        this.originalValues.put(attribute, originalValue);
    }

    private <T> void removeOriginalValue(Attribute<T> attribute) {
        if (this.originalValues != null) {
            this.originalValues.remove(attribute);
            if (this.originalValues.isEmpty()) {
                this.originalValues = null;
            }
        }
    }

    private <T> void updateOriginalValue(Attribute<T> attribute, T value, T previousValue) {
        boolean modified = this.isModified(attribute);
        if (modified && Objects.equals(this.originalValues.get(attribute), value)) {
            this.removeOriginalValue(attribute);
        } else if (!modified) {
            this.setOriginalValue(attribute, previousValue);
        }
    }

    private boolean valueEqual(Entity entity, Attribute<?> attribute) {
        if (this.contains(attribute) != entity.contains(attribute)) {
            return false;
        }
        Object value = this.get(attribute);
        Object other = entity.get(attribute);
        if (attribute.type().isByteArray()) {
            return Arrays.equals((byte[])value, (byte[])other);
        }
        return Objects.equals(value, other);
    }

    private boolean isModified(Attribute<?> attribute) {
        return this.originalValues != null && this.originalValues.containsKey(attribute);
    }

    private Entity deepCopy(Map<Entity.Key, Entity> copiedEntities) {
        Entity copy = this.copy();
        copiedEntities.put(copy.primaryKey(), copy);
        for (ForeignKey foreignKey : this.definition.foreignKeys().get()) {
            Entity foreignKeyValue = copy.get(foreignKey);
            if (!(foreignKeyValue instanceof DefaultEntity)) continue;
            Entity copiedForeignKeyValue = copiedEntities.get(foreignKeyValue.primaryKey());
            if (copiedForeignKeyValue == null) {
                copiedForeignKeyValue = ((DefaultEntity)foreignKeyValue).deepCopy(copiedEntities);
                copiedEntities.put(copiedForeignKeyValue.primaryKey(), copiedForeignKeyValue);
            }
            copy.put(foreignKey, copiedForeignKeyValue);
        }
        return copy;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.definition.entityType().domainType().name());
        EntitySerializer.serialize(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        DefaultKey.serializerForDomain((String)stream.readObject()).deserialize(this, stream);
    }

    private static Map<Attribute<?>, Object> validateTypes(EntityDefinition definition, Map<Attribute<?>, Object> values) {
        if (values != null && !values.isEmpty()) {
            for (Map.Entry<Attribute<?>, Object> valueEntry : values.entrySet()) {
                definition.attributes().definition(valueEntry.getKey()).attribute().type().validateType(valueEntry.getValue());
            }
        }
        return values;
    }

    private static Map<Attribute<?>, Object> createValueMap(Entity.Key key) {
        Collection<Column<?>> columns = key.columns();
        HashMap values = new HashMap(columns.size());
        for (Column<?> column : columns) {
            values.put(column, key.get(column));
        }
        return values;
    }

    private final class Unmodified
    implements Predicate<Map.Entry<Attribute<?>, Object>> {
        private Unmodified() {
        }

        @Override
        public boolean test(Map.Entry<Attribute<?>, Object> entry) {
            return Objects.equals(entry.getValue(), DefaultEntity.this.get(DefaultEntity.this.definition.attributes().definition(entry.getKey())));
        }
    }

    private static final class DefaultSourceValues
    implements DerivedAttribute.SourceValues {
        private final Attribute<?> derivedAttribute;
        private final Map<Attribute<?>, Object> values;

        private DefaultSourceValues(Attribute<?> derivedAttribute, Map<Attribute<?>, Object> values) {
            this.derivedAttribute = derivedAttribute;
            this.values = values;
        }

        @Override
        public <T> T get(Attribute<T> attribute) {
            if (!this.values.containsKey(attribute)) {
                throw new IllegalArgumentException("Attribute " + attribute + " is not specified as a source attribute for derived attribute: " + this.derivedAttribute);
            }
            return (T)this.values.get(attribute);
        }
    }
}

