/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.framework.domain.entity.DefaultKey;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import java.util.HashMap;
import java.util.Map;

final class DefaultKeyBuilder
implements Entity.Key.Builder {
    private final EntityDefinition definition;
    private final Map<Column<?>, Object> values = new HashMap();
    private boolean primaryKey = true;

    DefaultKeyBuilder(Entity.Key key) {
        this(key.entityDefinition());
        this.primaryKey = key.primaryKey();
        key.columns().forEach(column -> this.values.put((Column<?>)column, key.get(column)));
    }

    DefaultKeyBuilder(EntityDefinition definition) {
        this.definition = definition;
    }

    @Override
    public <T> Entity.Key.Builder with(Column<T> column, T value) {
        ColumnDefinition<T> columnDefinition = this.definition.columns().definition(column);
        if (!columnDefinition.primaryKey()) {
            this.primaryKey = false;
        }
        this.values.put(column, value);
        return this;
    }

    @Override
    public Entity.Key build() {
        return new DefaultKey(this.definition, this.initializeValues(new HashMap(this.values)), this.primaryKey);
    }

    private Map<Column<?>, Object> initializeValues(Map<Column<?>, Object> values) {
        if (this.primaryKey && !values.isEmpty()) {
            this.definition.primaryKey().columns().forEach(attribute -> values.putIfAbsent((Column<?>)attribute, null));
        }
        return values;
    }
}

