/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.common.NullOrEmpty;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.DefaultEntityDefinition;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.TypeReference;
import is.codion.framework.domain.entity.condition.ConditionType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;

final class DefaultEntityType
implements EntityType,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DomainType domainType;
    private final String name;
    private final String resourceBundleName;
    private final int hashCode;

    DefaultEntityType(DomainType domainType, String name, String resourceBundleName) {
        this.domainType = Objects.requireNonNull(domainType);
        if (NullOrEmpty.nullOrEmpty((String)name)) {
            throw new IllegalArgumentException("name must be a non-empty string");
        }
        this.name = name;
        if (resourceBundleName != null) {
            ResourceBundle.getBundle(resourceBundleName);
        }
        this.resourceBundleName = resourceBundleName;
        this.hashCode = Objects.hash(name, domainType);
    }

    @Override
    public DomainType domainType() {
        return this.domainType;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String resourceBundleName() {
        return this.resourceBundleName;
    }

    @Override
    public EntityDefinition.Builder define(AttributeDefinition.Builder<?, ?> ... definitionBuilders) {
        return this.define(Arrays.asList(Objects.requireNonNull(definitionBuilders)));
    }

    @Override
    public EntityDefinition.Builder define(List<AttributeDefinition.Builder<?, ?>> definitionBuilders) {
        return new DefaultEntityDefinition.DefaultBuilder(this, Objects.requireNonNull(definitionBuilders));
    }

    @Override
    public <T> Attribute<T> attribute(String name, Class<T> valueClass) {
        return Attribute.attribute((EntityType)this, name, valueClass);
    }

    @Override
    public <T> Attribute<T> attribute(String name, TypeReference<T> typeReference) {
        return Attribute.attribute((EntityType)this, name, typeReference);
    }

    @Override
    public Attribute<Long> longAttribute(String name) {
        return this.attribute(name, Long.class);
    }

    @Override
    public Attribute<Integer> integerAttribute(String name) {
        return this.attribute(name, Integer.class);
    }

    @Override
    public Attribute<Short> shortAttribute(String name) {
        return this.attribute(name, Short.class);
    }

    @Override
    public Attribute<Double> doubleAttribute(String name) {
        return this.attribute(name, Double.class);
    }

    @Override
    public Attribute<BigDecimal> bigDecimalAttribute(String name) {
        return this.attribute(name, BigDecimal.class);
    }

    @Override
    public Attribute<LocalDate> localDateAttribute(String name) {
        return this.attribute(name, LocalDate.class);
    }

    @Override
    public Attribute<LocalTime> localTimeAttribute(String name) {
        return this.attribute(name, LocalTime.class);
    }

    @Override
    public Attribute<LocalDateTime> localDateTimeAttribute(String name) {
        return this.attribute(name, LocalDateTime.class);
    }

    @Override
    public Attribute<OffsetDateTime> offsetDateTimeAttribute(String name) {
        return this.attribute(name, OffsetDateTime.class);
    }

    @Override
    public Attribute<String> stringAttribute(String name) {
        return this.attribute(name, String.class);
    }

    @Override
    public Attribute<Character> characterAttribute(String name) {
        return this.attribute(name, Character.class);
    }

    @Override
    public Attribute<Boolean> booleanAttribute(String name) {
        return this.attribute(name, Boolean.class);
    }

    @Override
    public Attribute<Entity> entityAttribute(String name) {
        return this.attribute(name, Entity.class);
    }

    @Override
    public Attribute<byte[]> byteArrayAttribute(String name) {
        return this.attribute(name, byte[].class);
    }

    @Override
    public <T> Column<T> column(String name, Class<T> valueClass) {
        return Column.column((EntityType)this, name, valueClass);
    }

    @Override
    public <T> Column<T> column(String name, TypeReference<T> typeReference) {
        return Column.column((EntityType)this, name, typeReference);
    }

    @Override
    public Column<Long> longColumn(String name) {
        return this.column(name, Long.class);
    }

    @Override
    public Column<Integer> integerColumn(String name) {
        return this.column(name, Integer.class);
    }

    @Override
    public Column<Short> shortColumn(String name) {
        return this.column(name, Short.class);
    }

    @Override
    public Column<Double> doubleColumn(String name) {
        return this.column(name, Double.class);
    }

    @Override
    public Column<BigDecimal> bigDecimalColumn(String name) {
        return this.column(name, BigDecimal.class);
    }

    @Override
    public Column<LocalDate> localDateColumn(String name) {
        return this.column(name, LocalDate.class);
    }

    @Override
    public Column<LocalTime> localTimeColumn(String name) {
        return this.column(name, LocalTime.class);
    }

    @Override
    public Column<LocalDateTime> localDateTimeColumn(String name) {
        return this.column(name, LocalDateTime.class);
    }

    @Override
    public Column<OffsetDateTime> offsetDateTimeColumn(String name) {
        return this.column(name, OffsetDateTime.class);
    }

    @Override
    public Column<String> stringColumn(String name) {
        return this.column(name, String.class);
    }

    @Override
    public Column<Character> characterColumn(String name) {
        return this.column(name, Character.class);
    }

    @Override
    public Column<Boolean> booleanColumn(String name) {
        return this.column(name, Boolean.class);
    }

    @Override
    public Column<byte[]> byteArrayColumn(String name) {
        return this.column(name, byte[].class);
    }

    @Override
    public <A> ForeignKey foreignKey(String name, Column<A> column, Column<A> referencedColumn) {
        return this.foreignKey(name, Collections.singletonList(ForeignKey.reference(column, referencedColumn)));
    }

    @Override
    public <A, B> ForeignKey foreignKey(String name, Column<A> firstColumn, Column<A> firstReferencedColumn, Column<B> secondColumn, Column<B> secondReferencedColumn) {
        return this.foreignKey(name, Arrays.asList(ForeignKey.reference(firstColumn, firstReferencedColumn), ForeignKey.reference(secondColumn, secondReferencedColumn)));
    }

    @Override
    public <A, B, C> ForeignKey foreignKey(String name, Column<A> firstColumn, Column<A> firstReferencedColumn, Column<B> secondColumn, Column<B> secondReferencedColumn, Column<C> thirdColumn, Column<C> thirdReferencedColumn) {
        return this.foreignKey(name, Arrays.asList(ForeignKey.reference(firstColumn, firstReferencedColumn), ForeignKey.reference(secondColumn, secondReferencedColumn), ForeignKey.reference(thirdColumn, thirdReferencedColumn)));
    }

    @Override
    public ForeignKey foreignKey(String name, List<ForeignKey.Reference<?>> references) {
        return ForeignKey.foreignKey(this, name, references);
    }

    @Override
    public ConditionType conditionType(String name) {
        return ConditionType.conditionType(this, name);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultEntityType that = (DefaultEntityType)object;
        return this.hashCode == that.hashCode && this.name.equals(that.name) && this.domainType.equals(that.domainType);
    }
}

