/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.condition;

import is.codion.common.Operator;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.AbstractCondition;
import is.codion.framework.domain.entity.condition.ColumnCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

abstract class AbstractColumnCondition<T>
extends AbstractCondition
implements ColumnCondition<T> {
    private static final long serialVersionUID = 1L;
    private final Column<T> column;
    private final Operator operator;
    private final boolean caseSensitive;

    protected AbstractColumnCondition(Column<T> column, Operator operator, Collection<? extends T> values, boolean caseSensitive) {
        super(Objects.requireNonNull(column).entityType(), Collections.nCopies(Objects.requireNonNull(values).size(), Objects.requireNonNull(column)), values);
        if (!(caseSensitive || column.type().isString() || column.type().isCharacter())) {
            throw new IllegalStateException("Case insensitivity only applies to String and Character based columns: " + column);
        }
        this.column = column;
        this.operator = Objects.requireNonNull(operator);
        this.caseSensitive = caseSensitive;
    }

    @Override
    public final Column<T> column() {
        return this.column;
    }

    @Override
    public final Operator operator() {
        return this.operator;
    }

    @Override
    public final boolean caseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public final String toString(EntityDefinition definition) {
        return this.toString(Objects.requireNonNull(definition).columns().definition(this.column).expression());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractColumnCondition)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractColumnCondition that = (AbstractColumnCondition)object;
        return Objects.equals(this.operator, that.operator) && this.caseSensitive == that.caseSensitive;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.operator, this.caseSensitive);
    }

    protected abstract String toString(String var1);

    protected abstract void validateOperator(Operator var1);
}

