/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.attribute;

import is.codion.common.NullOrEmpty;
import is.codion.common.Rounder;
import is.codion.common.Text;
import is.codion.common.format.LocaleDateTimePattern;
import is.codion.common.item.Item;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;

abstract class AbstractAttributeDefinition<T>
implements AttributeDefinition<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String INVALID_ITEM_SUFFIX_KEY = "invalid_item_suffix";
    private static final String INVALID_ITEM_SUFFIX = ResourceBundle.getBundle(AbstractAttributeDefinition.class.getName()).getString("invalid_item_suffix");
    private static final Comparator<?> LEXICAL_COMPARATOR = Text.collator();
    private static final Comparator<Comparable<Object>> COMPARABLE_COMPARATOR = new DefaultComparator();
    private static final Comparator<Object> TO_STRING_COMPARATOR = new ToStringComparator();
    private static final AttributeDefinition.ValueSupplier<Object> DEFAULT_VALUE_SUPPLIER = new NullDefaultValueSupplier();
    private final Attribute<T> attribute;
    private final String caption;
    private final String captionResourceKey;
    private final AttributeDefinition.ValueSupplier<T> defaultValueSupplier;
    private final boolean nullable;
    private final boolean hidden;
    private final int maximumLength;
    private final Number maximumValue;
    private final Number minimumValue;
    private final String description;
    private final char mnemonic;
    private final Format format;
    private final LocaleDateTimePattern localeDateTimePattern;
    private final RoundingMode decimalRoundingMode;
    private final Comparator<T> comparator;
    private final List<Item<T>> items;
    private final Map<T, Item<T>> itemMap;
    private transient String resourceCaption;
    private transient String dateTimePattern;
    private transient DateTimeFormatter dateTimeFormatter;

    protected AbstractAttributeDefinition(AbstractAttributeDefinitionBuilder<T, ?> builder) {
        Objects.requireNonNull(builder, "builder");
        this.attribute = builder.attribute;
        this.caption = builder.caption;
        this.captionResourceKey = builder.captionResourceKey;
        this.defaultValueSupplier = builder.defaultValueSupplier;
        this.nullable = builder.nullable;
        this.hidden = builder.hidden;
        this.maximumLength = builder.maximumLength;
        this.maximumValue = builder.maximumValue;
        this.minimumValue = builder.minimumValue;
        this.description = builder.description;
        this.mnemonic = builder.mnemonic;
        this.format = builder.format;
        this.localeDateTimePattern = builder.localeDateTimePattern;
        this.decimalRoundingMode = builder.decimalRoundingMode;
        this.comparator = builder.comparator;
        this.dateTimePattern = builder.dateTimePattern;
        this.dateTimeFormatter = builder.dateTimeFormatter;
        this.items = builder.items;
        this.itemMap = this.items == null ? null : this.items.stream().collect(Collectors.toMap(Item::get, Function.identity()));
    }

    public final String toString() {
        return this.caption();
    }

    @Override
    public Attribute<T> attribute() {
        return this.attribute;
    }

    @Override
    public boolean derived() {
        return false;
    }

    @Override
    public final EntityType entityType() {
        return this.attribute.entityType();
    }

    @Override
    public final boolean hidden() {
        return this.hidden;
    }

    @Override
    public final boolean hasDefaultValue() {
        return !(this.defaultValueSupplier instanceof NullDefaultValueSupplier);
    }

    @Override
    public final T defaultValue() {
        return this.defaultValueSupplier.get();
    }

    @Override
    public final boolean nullable() {
        return this.nullable;
    }

    @Override
    public final int maximumLength() {
        return this.maximumLength;
    }

    @Override
    public final Number maximumValue() {
        return this.maximumValue;
    }

    @Override
    public final Number minimumValue() {
        return this.minimumValue;
    }

    @Override
    public final String description() {
        return this.description;
    }

    @Override
    public final char mnemonic() {
        return this.mnemonic;
    }

    @Override
    public final Format format() {
        return this.format;
    }

    @Override
    public final String dateTimePattern() {
        if (this.dateTimePattern == null) {
            this.dateTimePattern = this.localeDateTimePattern == null ? this.defaultDateTimePattern() : this.localeDateTimePattern.dateTimePattern();
        }
        return this.dateTimePattern;
    }

    @Override
    public final DateTimeFormatter dateTimeFormatter() {
        if (this.dateTimeFormatter == null) {
            String pattern = this.dateTimePattern();
            this.dateTimeFormatter = pattern == null ? null : DateTimeFormatter.ofPattern(pattern);
        }
        return this.dateTimeFormatter;
    }

    @Override
    public final Comparator<T> comparator() {
        return this.comparator;
    }

    @Override
    public final boolean validItem(T value) {
        return this.itemMap == null || this.itemMap.containsKey(value);
    }

    @Override
    public final List<Item<T>> items() {
        return this.items == null ? Collections.emptyList() : this.items;
    }

    @Override
    public final int maximumFractionDigits() {
        if (!(this.format instanceof NumberFormat)) {
            return -1;
        }
        return ((NumberFormat)this.format).getMaximumFractionDigits();
    }

    @Override
    public final RoundingMode decimalRoundingMode() {
        return this.decimalRoundingMode;
    }

    @Override
    public final String caption() {
        if (this.attribute.entityType().resourceBundleName() != null) {
            if (this.resourceCaption == null) {
                ResourceBundle bundle = ResourceBundle.getBundle(this.attribute.entityType().resourceBundleName());
                String string = this.resourceCaption = bundle.containsKey(this.captionResourceKey) ? bundle.getString(this.captionResourceKey) : "";
            }
            if (!this.resourceCaption.isEmpty()) {
                return this.resourceCaption;
            }
        }
        return this.caption == null ? this.attribute.name() : this.caption;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAttributeDefinition that = (AbstractAttributeDefinition)obj;
        return this.attribute.equals(that.attribute);
    }

    public final int hashCode() {
        return this.attribute.hashCode();
    }

    @Override
    public final T prepareValue(T value) {
        if (value instanceof Double) {
            return (T)Rounder.roundDouble((Double)((Double)value), (int)this.maximumFractionDigits(), (RoundingMode)this.decimalRoundingMode);
        }
        if (value instanceof BigDecimal) {
            return (T)((BigDecimal)value).setScale(this.maximumFractionDigits(), this.decimalRoundingMode).stripTrailingZeros();
        }
        return value;
    }

    @Override
    public final String string(T value) {
        DateTimeFormatter formatter;
        if (this.itemMap != null) {
            return this.itemString(value);
        }
        if (value == null) {
            return "";
        }
        if (this.attribute.type().isTemporal() && (formatter = this.dateTimeFormatter()) != null) {
            return formatter.format((TemporalAccessor)value);
        }
        if (this.format != null) {
            return this.format.format(value);
        }
        return value.toString();
    }

    private String itemString(T value) {
        Item<T> item = this.itemMap.get(value);
        if (item == null) {
            if (value == null && this.nullable()) {
                return "";
            }
            return value + " <" + INVALID_ITEM_SUFFIX + ">";
        }
        return item.caption();
    }

    private String defaultDateTimePattern() {
        if (this.attribute.type().isLocalDate()) {
            return (String)DATE_FORMAT.get();
        }
        if (this.attribute.type().isLocalTime()) {
            return (String)TIME_FORMAT.get();
        }
        if (this.attribute.type().isLocalDateTime()) {
            return (String)DATE_TIME_FORMAT.get();
        }
        if (this.attribute.type().isOffsetDateTime()) {
            return (String)DATE_TIME_FORMAT.get();
        }
        return null;
    }

    static abstract class AbstractAttributeDefinitionBuilder<T, B extends AttributeDefinition.Builder<T, B>>
    implements AttributeDefinition.Builder<T, B> {
        protected final Attribute<T> attribute;
        private String caption;
        private AttributeDefinition.ValueSupplier<T> defaultValueSupplier;
        private String captionResourceKey;
        private boolean nullable;
        private boolean hidden;
        private int maximumLength;
        private Number maximumValue;
        private Number minimumValue;
        private String description;
        private char mnemonic;
        private Format format;
        private LocaleDateTimePattern localeDateTimePattern;
        private RoundingMode decimalRoundingMode;
        private Comparator<T> comparator;
        private String dateTimePattern;
        private DateTimeFormatter dateTimeFormatter;
        private List<Item<T>> items;

        AbstractAttributeDefinitionBuilder(Attribute<T> attribute) {
            this.attribute = Objects.requireNonNull(attribute);
            this.format = AbstractAttributeDefinitionBuilder.defaultFormat(attribute);
            this.comparator = AbstractAttributeDefinitionBuilder.defaultComparator(attribute);
            this.captionResourceKey = attribute.name();
            this.hidden = AbstractAttributeDefinitionBuilder.resourceNotFound(attribute.entityType().resourceBundleName(), this.captionResourceKey);
            this.nullable = true;
            this.maximumLength = attribute.type().isCharacter() ? 1 : -1;
            this.defaultValueSupplier = DEFAULT_VALUE_SUPPLIER;
            this.decimalRoundingMode = (RoundingMode)((Object)AttributeDefinition.DECIMAL_ROUNDING_MODE.get());
            this.minimumValue = this.defaultMinimumValue();
            this.maximumValue = this.defaultMaximumValue();
        }

        @Override
        public final Attribute<T> attribute() {
            return this.attribute;
        }

        @Override
        public final B caption(String caption) {
            this.caption = caption;
            this.hidden = caption == null;
            return (B)this;
        }

        @Override
        public final B captionResourceKey(String captionResourceKey) {
            if (this.caption != null) {
                throw new IllegalStateException("Caption has already been set for attribute: " + this.attribute);
            }
            String resourceBundleName = this.attribute.entityType().resourceBundleName();
            if (resourceBundleName == null) {
                throw new IllegalStateException("No resource bundle specified for entity: " + this.attribute.entityType());
            }
            if (AbstractAttributeDefinitionBuilder.resourceNotFound(resourceBundleName, Objects.requireNonNull(captionResourceKey, "captionResourceKey"))) {
                throw new IllegalArgumentException("Resource " + captionResourceKey + " not found in bundle: " + resourceBundleName);
            }
            this.captionResourceKey = captionResourceKey;
            this.hidden = false;
            return (B)this;
        }

        @Override
        public final B hidden(boolean hidden) {
            this.hidden = hidden;
            return (B)this;
        }

        @Override
        public final B defaultValue(T defaultValue) {
            return this.defaultValue(new DefaultValueSupplier<T>(defaultValue));
        }

        @Override
        public B defaultValue(AttributeDefinition.ValueSupplier<T> supplier) {
            if (supplier != null) {
                this.attribute.type().validateType(supplier.get());
            }
            this.defaultValueSupplier = supplier == null ? DEFAULT_VALUE_SUPPLIER : supplier;
            return (B)this;
        }

        @Override
        public B nullable(boolean nullable) {
            this.nullable = nullable;
            return (B)this;
        }

        @Override
        public B maximumLength(int maximumLength) {
            if (!this.attribute.type().isString()) {
                throw new IllegalStateException("maximumLength is only applicable to string attributes: " + this.attribute);
            }
            if (maximumLength <= 0) {
                throw new IllegalArgumentException("maximumLength must be a positive integer: " + this.attribute);
            }
            this.maximumLength = maximumLength;
            return (B)this;
        }

        @Override
        public final B minimumValue(Number minimumValue) {
            return this.valueRange(minimumValue, null);
        }

        @Override
        public final B maximumValue(Number maximumValue) {
            return this.valueRange(null, maximumValue);
        }

        @Override
        public B valueRange(Number minimumValue, Number maximumValue) {
            if (!this.attribute.type().isNumerical()) {
                throw new IllegalStateException("valueRange is only applicable to numerical attributes");
            }
            if (maximumValue != null && minimumValue != null && maximumValue.doubleValue() < minimumValue.doubleValue()) {
                throw new IllegalArgumentException("minimum value must be smaller than maximum value: " + this.attribute);
            }
            this.minimumValue = minimumValue;
            this.maximumValue = maximumValue;
            return (B)this;
        }

        @Override
        public final B numberFormatGrouping(boolean numberFormatGrouping) {
            if (!this.attribute.type().isNumerical()) {
                throw new IllegalStateException("numberFormatGrouping is only applicable to numerical attributes: " + this.attribute);
            }
            ((NumberFormat)this.format).setGroupingUsed(numberFormatGrouping);
            return (B)this;
        }

        @Override
        public final B description(String description) {
            this.description = description;
            return (B)this;
        }

        @Override
        public final B mnemonic(char mnemonic) {
            this.mnemonic = mnemonic;
            return (B)this;
        }

        @Override
        public final B format(Format format) {
            Objects.requireNonNull(format, "format");
            if (this.attribute.type().isNumerical() && !(format instanceof NumberFormat)) {
                throw new IllegalArgumentException("NumberFormat required for numerical attribute: " + this.attribute);
            }
            if (this.attribute.type().isTemporal()) {
                throw new IllegalStateException("Use dateTimePattern() or localeDateTimePattern() for temporal attributes: " + this.attribute);
            }
            this.format = format;
            return (B)this;
        }

        @Override
        public final B dateTimePattern(String dateTimePattern) {
            Objects.requireNonNull(dateTimePattern, "dateTimePattern");
            if (!this.attribute.type().isTemporal()) {
                throw new IllegalStateException("dateTimePattern is only applicable to temporal attributes: " + this.attribute);
            }
            if (this.localeDateTimePattern != null) {
                throw new IllegalStateException("localeDateTimePattern has already been set for attribute: " + this.attribute);
            }
            this.dateTimePattern = dateTimePattern;
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimePattern);
            return (B)this;
        }

        @Override
        public final B localeDateTimePattern(LocaleDateTimePattern localeDateTimePattern) {
            Objects.requireNonNull(localeDateTimePattern, "localeDateTimePattern");
            if (!this.attribute.type().isTemporal()) {
                throw new IllegalStateException("localeDateTimePattern is only applicable to temporal attributes: " + this.attribute);
            }
            if (this.dateTimePattern != null) {
                throw new IllegalStateException("dateTimePattern has already been set for attribute: " + this.attribute);
            }
            this.localeDateTimePattern = localeDateTimePattern;
            this.dateTimePattern = localeDateTimePattern.dateTimePattern();
            this.dateTimeFormatter = localeDateTimePattern.createFormatter();
            return (B)this;
        }

        @Override
        public final B maximumFractionDigits(int maximumFractionDigits) {
            if (!this.attribute.type().isDecimal()) {
                throw new IllegalStateException("maximumFractionDigits is only applicable to decimal attributes: " + this.attribute);
            }
            ((NumberFormat)this.format).setMaximumFractionDigits(maximumFractionDigits);
            return (B)this;
        }

        @Override
        public final B decimalRoundingMode(RoundingMode decimalRoundingMode) {
            if (!this.attribute.type().isDecimal()) {
                throw new IllegalStateException("decimalRoundingMode is only applicable to decimal attributes: " + this.attribute);
            }
            this.decimalRoundingMode = Objects.requireNonNull(decimalRoundingMode, "decimalRoundingMode");
            return (B)this;
        }

        @Override
        public B comparator(Comparator<T> comparator) {
            this.comparator = Objects.requireNonNull(comparator);
            return (B)this;
        }

        @Override
        public final B items(List<Item<T>> items) {
            this.items = AbstractAttributeDefinitionBuilder.validateItems(items);
            return (B)this;
        }

        private static boolean resourceNotFound(String resourceBundleName, String captionResourceKey) {
            if (resourceBundleName == null) {
                return true;
            }
            try {
                return !ResourceBundle.getBundle(resourceBundleName).containsKey(captionResourceKey);
            }
            catch (MissingResourceException e) {
                return true;
            }
        }

        private static <T> List<Item<T>> validateItems(List<Item<T>> items) {
            if ((long)Objects.requireNonNull(items).size() != items.stream().distinct().count()) {
                throw new IllegalArgumentException("Item list contains duplicate values: " + items);
            }
            return Collections.unmodifiableList(new ArrayList<Item<T>>(items));
        }

        private static Format defaultFormat(Attribute<?> attribute) {
            if (attribute.type().isNumerical()) {
                NumberFormat numberFormat = AbstractAttributeDefinitionBuilder.defaultNumberFormat(attribute);
                if (attribute.type().isDecimal()) {
                    ((DecimalFormat)numberFormat).setParseBigDecimal(attribute.type().isBigDecimal());
                    numberFormat.setMaximumFractionDigits((Integer)AttributeDefinition.MAXIMUM_FRACTION_DIGITS.get());
                }
                return numberFormat;
            }
            return null;
        }

        private static NumberFormat defaultNumberFormat(Attribute<?> attribute) {
            boolean grouping = (Boolean)AttributeDefinition.NUMBER_FORMAT_GROUPING.get();
            if (attribute.type().isInteger() || attribute.type().isLong()) {
                return AbstractAttributeDefinitionBuilder.setSeparators(grouping ? NumberFormat.getIntegerInstance() : AbstractAttributeDefinitionBuilder.nonGroupingIntegerFormat());
            }
            return AbstractAttributeDefinitionBuilder.setSeparators(grouping ? NumberFormat.getNumberInstance() : AbstractAttributeDefinitionBuilder.nonGroupingNumberFormat());
        }

        private static NumberFormat nonGroupingNumberFormat() {
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setGroupingUsed(false);
            return format;
        }

        private static NumberFormat nonGroupingIntegerFormat() {
            NumberFormat format = NumberFormat.getIntegerInstance();
            format.setGroupingUsed(false);
            return format;
        }

        private static NumberFormat setSeparators(NumberFormat numberFormat) {
            if (numberFormat instanceof DecimalFormat) {
                Character defaultGroupingSeparator = (Character)AttributeDefinition.GROUPING_SEPARATOR.get();
                Character defaultDecimalSeparator = (Character)AttributeDefinition.DECIMAL_SEPARATOR.get();
                if (NullOrEmpty.notNull((Object[])new Object[]{defaultGroupingSeparator, defaultDecimalSeparator})) {
                    DecimalFormatSymbols symbols = ((DecimalFormat)numberFormat).getDecimalFormatSymbols();
                    symbols.setDecimalSeparator(defaultDecimalSeparator.charValue());
                    symbols.setGroupingSeparator(defaultGroupingSeparator.charValue());
                    ((DecimalFormat)numberFormat).setDecimalFormatSymbols(symbols);
                }
            }
            return numberFormat;
        }

        private static <T> Comparator<T> defaultComparator(Attribute<T> attribute) {
            if (attribute.type().isString() && ((Boolean)AttributeDefinition.USE_LEXICAL_STRING_COMPARATOR.get()).booleanValue()) {
                return LEXICAL_COMPARATOR;
            }
            if (Comparable.class.isAssignableFrom(attribute.type().valueClass())) {
                return COMPARABLE_COMPARATOR;
            }
            return TO_STRING_COMPARATOR;
        }

        private Number defaultMinimumValue() {
            if (this.attribute.type().isNumerical()) {
                if (this.attribute.type().isShort()) {
                    return (short)Short.MIN_VALUE;
                }
                if (this.attribute.type().isInteger()) {
                    return Integer.MIN_VALUE;
                }
                if (this.attribute.type().isLong()) {
                    return Long.MIN_VALUE;
                }
                if (this.attribute.type().isDouble()) {
                    return -1.7976931348623157E308;
                }
            }
            return null;
        }

        private Number defaultMaximumValue() {
            if (this.attribute.type().isNumerical()) {
                if (this.attribute.type().isShort()) {
                    return (short)Short.MAX_VALUE;
                }
                if (this.attribute.type().isInteger()) {
                    return Integer.MAX_VALUE;
                }
                if (this.attribute.type().isLong()) {
                    return Long.MAX_VALUE;
                }
                if (this.attribute.type().isDouble()) {
                    return Double.MAX_VALUE;
                }
            }
            return null;
        }
    }

    private static final class NullDefaultValueSupplier
    extends DefaultValueSupplier<Object> {
        private static final long serialVersionUID = 1L;

        private NullDefaultValueSupplier() {
            super(null);
        }
    }

    private static final class DefaultComparator
    implements Comparator<Comparable<Object>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DefaultComparator() {
        }

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            return o1.compareTo(o2);
        }
    }

    private static final class ToStringComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ToStringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    static final class DefinitionComparator
    implements Comparator<AttributeDefinition<?>> {
        private final Collator collator = Collator.getInstance();

        DefinitionComparator() {
        }

        @Override
        public int compare(AttributeDefinition<?> definition1, AttributeDefinition<?> definition2) {
            return this.collator.compare(definition1.toString().toLowerCase(), definition2.toString().toLowerCase());
        }
    }

    static class DefaultValueSupplier<T>
    implements AttributeDefinition.ValueSupplier<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final T defaultValue;

        DefaultValueSupplier(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public T get() {
            return this.defaultValue;
        }
    }
}

