/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain;

import is.codion.common.db.operation.DatabaseFunction;
import is.codion.common.db.operation.DatabaseProcedure;
import is.codion.common.db.operation.FunctionType;
import is.codion.common.db.operation.ProcedureType;
import is.codion.common.db.report.Report;
import is.codion.common.db.report.ReportException;
import is.codion.common.db.report.ReportType;
import is.codion.framework.domain.Domain;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.DefaultEntities;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.EntityDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class DefaultDomain
implements Domain {
    private final DomainType domainType;
    private final DomainEntities entities;
    private final DomainReports reports = new DomainReports();
    private final DomainProcedures procedures = new DomainProcedures();
    private final DomainFunctions functions = new DomainFunctions();

    protected DefaultDomain(DomainType domainType) {
        this.domainType = Objects.requireNonNull(domainType, "domainType");
        this.entities = new DomainEntities(domainType);
    }

    @Override
    public final DomainType type() {
        return this.domainType;
    }

    @Override
    public final Entities entities() {
        return this.entities;
    }

    @Override
    public final Map<ReportType<?, ?, ?>, Report<?, ?, ?>> reports() {
        return Collections.unmodifiableMap(this.reports.reports);
    }

    @Override
    public final Map<ProcedureType<?, ?>, DatabaseProcedure<?, ?>> procedures() {
        return Collections.unmodifiableMap(this.procedures.procedures);
    }

    @Override
    public final Map<FunctionType<?, ?, ?>, DatabaseFunction<?, ?, ?>> functions() {
        return Collections.unmodifiableMap(this.functions.functions);
    }

    @Override
    public final <T, R, P> Report<T, R, P> report(ReportType<T, R, P> reportType) {
        Report<T, R, P> report = this.reports.report(reportType);
        if (report == null) {
            throw new IllegalArgumentException("Undefined report: " + reportType);
        }
        return report;
    }

    @Override
    public final <C, T> DatabaseProcedure<C, T> procedure(ProcedureType<C, T> procedureType) {
        return this.procedures.procedure(procedureType);
    }

    @Override
    public final <C, T, R> DatabaseFunction<C, T, R> function(FunctionType<C, T, R> functionType) {
        return this.functions.function(functionType);
    }

    protected final void add(EntityDefinition.Builder definitionBuilder) {
        this.add(Objects.requireNonNull(definitionBuilder, "definitionBuilder").build());
    }

    protected final void add(EntityDefinition definition) {
        Objects.requireNonNull(definition, "definition");
        if (!this.domainType.contains(definition.entityType())) {
            throw new IllegalArgumentException("Entity type '" + definition.entityType() + "' is not part of domain: " + this.domainType);
        }
        this.entities.addEntityDefinition(definition);
    }

    protected final <T, R, P> void add(ReportType<T, R, P> reportType, Report<T, R, P> report) {
        this.reports.addReport(reportType, report);
    }

    protected final <C, T> void add(ProcedureType<C, T> procedureType, DatabaseProcedure<C, T> procedure) {
        this.procedures.addProcedure(procedureType, procedure);
    }

    protected final <C, T, R> void add(FunctionType<C, T, R> functionType, DatabaseFunction<C, T, R> function) {
        this.functions.addFunction(functionType, function);
    }

    protected final void setStrictForeignKeys(boolean strictForeignKeys) {
        this.entities.setStrictForeignKeysInternal(strictForeignKeys);
    }

    protected final void addAll(Domain domain) {
        this.addEntities(domain);
        this.addProcedures(domain);
        this.addFunctions(domain);
        this.addReports(domain);
    }

    protected final void addEntities(Domain domain) {
        Objects.requireNonNull(domain).entities().definitions().forEach(definition -> {
            if (!this.entities.contains(definition.entityType())) {
                this.entities.addEntityDefinition((EntityDefinition)definition);
            }
        });
    }

    protected final void addProcedures(Domain domain) {
        Objects.requireNonNull(domain).procedures().forEach((procedureType, procedure) -> {
            if (!this.procedures.procedures.containsKey(procedureType)) {
                this.procedures.procedures.put((ProcedureType<?, ?>)procedureType, (DatabaseProcedure<?, ?>)procedure);
            }
        });
    }

    protected final void addFunctions(Domain domain) {
        Objects.requireNonNull(domain).functions().forEach((functionType, function) -> {
            if (!this.functions.functions.containsKey(functionType)) {
                this.functions.functions.put((FunctionType<?, ?, ?>)functionType, (DatabaseFunction<?, ?, ?>)function);
            }
        });
    }

    protected final void addReports(Domain domain) {
        Objects.requireNonNull(domain).reports().forEach((reportType, report) -> {
            if (!this.reports.reports.containsKey(reportType)) {
                this.reports.reports.put((ReportType<?, ?, ?>)reportType, (Report<?, ?, ?>)report);
            }
        });
    }

    private static final class DomainReports {
        private static final String REPORT = "report";
        private final Map<ReportType<?, ?, ?>, Report<?, ?, ?>> reports = new HashMap();

        private DomainReports() {
        }

        private <T, R, P> void addReport(ReportType<T, R, P> reportType, Report<T, R, P> report) {
            Objects.requireNonNull(reportType, "reportType");
            Objects.requireNonNull(report, REPORT);
            if (this.reports.containsKey(reportType)) {
                throw new IllegalArgumentException("Report has already been defined: " + reportType);
            }
            try {
                report.load();
                this.reports.put(reportType, report);
            }
            catch (ReportException e) {
                throw new RuntimeException(e);
            }
        }

        private <T, R, P> Report<T, R, P> report(ReportType<T, R, P> reportType) {
            return this.reports.get(Objects.requireNonNull(reportType, REPORT));
        }
    }

    private static final class DomainProcedures {
        private final Map<ProcedureType<?, ?>, DatabaseProcedure<?, ?>> procedures = new HashMap();

        private DomainProcedures() {
        }

        private void addProcedure(ProcedureType<?, ?> procedureType, DatabaseProcedure<?, ?> procedure) {
            Objects.requireNonNull(procedureType, "procedureType");
            Objects.requireNonNull(procedure, "procedure");
            if (this.procedures.containsKey(procedureType)) {
                throw new IllegalArgumentException("Procedure already defined: " + procedureType);
            }
            this.procedures.put(procedureType, procedure);
        }

        private <C, T> DatabaseProcedure<C, T> procedure(ProcedureType<C, T> procedureType) {
            Objects.requireNonNull(procedureType, "procedureType");
            DatabaseProcedure<?, ?> operation = this.procedures.get(procedureType);
            if (operation == null) {
                throw new IllegalArgumentException("Procedure not found: " + procedureType);
            }
            return operation;
        }
    }

    private static final class DomainFunctions {
        private final Map<FunctionType<?, ?, ?>, DatabaseFunction<?, ?, ?>> functions = new HashMap();

        private DomainFunctions() {
        }

        private void addFunction(FunctionType<?, ?, ?> functionType, DatabaseFunction<?, ?, ?> function) {
            Objects.requireNonNull(functionType, "functionType");
            Objects.requireNonNull(function, "function");
            if (this.functions.containsKey(functionType)) {
                throw new IllegalArgumentException("Function already defined: " + functionType);
            }
            this.functions.put(functionType, function);
        }

        private <C, T, R> DatabaseFunction<C, T, R> function(FunctionType<C, T, R> functionType) {
            Objects.requireNonNull(functionType, "functionType");
            DatabaseFunction<?, ?, ?> operation = this.functions.get(functionType);
            if (operation == null) {
                throw new IllegalArgumentException("Function not found: " + functionType);
            }
            return operation;
        }
    }

    private static final class DomainEntities
    extends DefaultEntities {
        private static final long serialVersionUID = 1L;

        private DomainEntities(DomainType domainType) {
            super(domainType);
        }

        private void addEntityDefinition(EntityDefinition definition) {
            super.add(definition);
        }

        private void setStrictForeignKeysInternal(boolean strictForeignKeys) {
            super.setStrictForeignKeys(strictForeignKeys);
        }
    }
}

