/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.condition;

import is.codion.common.Operator;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.AbstractColumnCondition;
import java.util.Collections;
import java.util.Objects;

final class SingleValueColumnCondition<T>
extends AbstractColumnCondition<T> {
    private static final long serialVersionUID = 1L;
    private static final String IS_NULL = " IS NULL";
    private static final String IS_NOT_NULL = " IS NOT NULL";
    private static final String EQUAL = " = ";
    private static final String NOT_EQUAL = " <> ";
    private static final String LIKE = " LIKE ";
    private static final String NOT_LIKE = " NOT LIKE ";
    private static final String LESS_THAN = " < ?";
    private static final String LESS_THAN_OR_EQUAL = " <= ?";
    private static final String GREATER_THAN = " > ?";
    private static final String GREATER_THAN_OR_EQUAL = " >= ?";
    private static final String PLACEHOLDER = "?";
    private static final String PLACEHOLDER_UPPER = "UPPER(?)";
    private final T value;
    private final boolean useLikeOperator;

    SingleValueColumnCondition(Column<T> column, T value, Operator operator) {
        this(column, value, operator, true, false);
    }

    SingleValueColumnCondition(Column<T> column, T value, Operator operator, boolean caseSensitive, boolean useLikeOperator) {
        super(column, operator, value == null ? Collections.emptyList() : Collections.singletonList(value), caseSensitive);
        this.validateOperator(operator);
        this.value = value;
        this.useLikeOperator = useLikeOperator;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SingleValueColumnCondition)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SingleValueColumnCondition that = (SingleValueColumnCondition)object;
        return Objects.equals(this.value, that.value) && this.useLikeOperator == that.useLikeOperator;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.useLikeOperator);
    }

    public String toString() {
        return "SingleValueColumnCondition{column=" + this.column() + ", operator=" + this.operator() + ", value=" + this.value + ", caseSensitive=" + this.caseSensitive() + ", useLikeOperator=" + this.useLikeOperator + "}";
    }

    @Override
    protected String toString(String columnExpression) {
        switch (this.operator()) {
            case EQUAL: {
                return this.toStringEqual(columnExpression);
            }
            case NOT_EQUAL: {
                return this.toStringNotEqual(columnExpression);
            }
            case LESS_THAN: {
                return columnExpression + LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return columnExpression + LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return columnExpression + GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return columnExpression + GREATER_THAN_OR_EQUAL;
            }
        }
        throw new IllegalStateException("Unsupported single value operator: " + this.operator());
    }

    private String toStringEqual(String columnExpression) {
        if (this.value == null) {
            return columnExpression + IS_NULL;
        }
        if (this.useLikeOperator) {
            return this.identifier(columnExpression) + LIKE + this.placeholder();
        }
        return this.identifier(columnExpression) + EQUAL + this.placeholder();
    }

    private String toStringNotEqual(String columnExpression) {
        if (this.value == null) {
            return columnExpression + IS_NOT_NULL;
        }
        if (this.useLikeOperator) {
            return this.identifier(columnExpression) + NOT_LIKE + this.placeholder();
        }
        return this.identifier(columnExpression) + NOT_EQUAL + this.placeholder();
    }

    private String identifier(String columnExpression) {
        return this.caseInsensitiveStringOrCharacter() ? "UPPER(" + columnExpression + ")" : columnExpression;
    }

    private String placeholder() {
        return this.caseInsensitiveStringOrCharacter() ? PLACEHOLDER_UPPER : PLACEHOLDER;
    }

    private boolean caseInsensitiveStringOrCharacter() {
        return !this.caseSensitive() && (this.column().type().isString() || this.column().type().isCharacter());
    }

    @Override
    protected void validateOperator(Operator operator) {
        switch (operator) {
            case EQUAL: 
            case NOT_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported single value operator: " + operator);
            }
        }
    }
}

