/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.condition;

import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class AbstractCondition
implements Condition,
Serializable {
    private final EntityType entityType;
    private final List<Column<?>> columns;
    private final List<?> values;

    protected AbstractCondition(EntityType entityType, List<Column<?>> columns, Collection<?> values) {
        this.entityType = Objects.requireNonNull(entityType);
        this.columns = this.validate(Collections.unmodifiableList(new ArrayList(columns)));
        this.values = Collections.unmodifiableList(new ArrayList(values));
    }

    @Override
    public final EntityType entityType() {
        return this.entityType;
    }

    @Override
    public final List<Column<?>> columns() {
        return this.columns;
    }

    @Override
    public final List<?> values() {
        return this.values;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractCondition)) {
            return false;
        }
        AbstractCondition that = (AbstractCondition)object;
        return this.entityType.equals(that.entityType()) && Objects.equals(this.columns, that.columns()) && Objects.equals(this.values, that.values());
    }

    public int hashCode() {
        return Objects.hash(this.entityType, this.columns, this.values);
    }

    private List<Column<?>> validate(List<Column<?>> columns) {
        if (!columns.isEmpty()) {
            for (Column<?> column : columns) {
                if (column.entityType().equals(this.entityType)) continue;
                throw new IllegalArgumentException("Condition column entityType mismatch, " + this.entityType + " expected, got: " + column.entityType());
            }
        }
        return columns;
    }
}

