/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.attribute;

import is.codion.framework.domain.entity.attribute.AbstractAttributeDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.DerivedAttribute;
import is.codion.framework.domain.entity.attribute.DerivedAttributeDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

final class DefaultDerivedAttributeDefinition<T>
extends AbstractAttributeDefinition<T>
implements DerivedAttributeDefinition<T> {
    private static final long serialVersionUID = 1L;
    private final DerivedAttribute.Provider<T> valueProvider;
    private final List<Attribute<?>> sourceAttributes;

    private DefaultDerivedAttributeDefinition(DefaultDerivedAttributeDefinitionBuilder<T, ?> builder) {
        super(builder);
        this.valueProvider = builder.valueProvider;
        this.sourceAttributes = builder.sourceAttributes;
    }

    @Override
    public DerivedAttribute.Provider<T> valueProvider() {
        return this.valueProvider;
    }

    @Override
    public List<Attribute<?>> sourceAttributes() {
        return this.sourceAttributes;
    }

    @Override
    public boolean derived() {
        return true;
    }

    static final class DefaultDerivedAttributeDefinitionBuilder<T, B extends AttributeDefinition.Builder<T, B>>
    extends AbstractAttributeDefinition.AbstractAttributeDefinitionBuilder<T, B>
    implements AttributeDefinition.Builder<T, B> {
        private final DerivedAttribute.Provider<T> valueProvider;
        private final List<Attribute<?>> sourceAttributes;

        DefaultDerivedAttributeDefinitionBuilder(Attribute<T> attribute, DerivedAttribute.Provider<T> valueProvider, Attribute<?> ... sourceAttributes) {
            super(attribute);
            this.valueProvider = Objects.requireNonNull(valueProvider);
            if (sourceAttributes.length == 0) {
                throw new IllegalArgumentException("No source attributes, a derived attribute must be derived from one or more existing attributes");
            }
            for (Attribute<?> sourceAttribute : sourceAttributes) {
                if (!attribute.entityType().equals(sourceAttribute.entityType())) {
                    throw new IllegalArgumentException("Source attribute must be from same entity as the derived column");
                }
                if (!attribute.equals(sourceAttribute)) continue;
                throw new IllegalArgumentException("Derived attribute can not be derived from itself");
            }
            this.sourceAttributes = Arrays.asList(sourceAttributes);
        }

        @Override
        public B defaultValue(AttributeDefinition.ValueSupplier<T> supplier) {
            throw new UnsupportedOperationException("A derived attribute can not have a default value");
        }

        @Override
        public B nullable(boolean nullable) {
            throw new UnsupportedOperationException("Can not set the nullable state of a derived attribute");
        }

        @Override
        public B maximumLength(int maximumLength) {
            throw new UnsupportedOperationException("Can not set the maximum length of a derived attribute");
        }

        @Override
        public B valueRange(Number minimumValue, Number maximumValue) {
            throw new UnsupportedOperationException("Can not set minimum or maximum value of a derived attribute");
        }

        @Override
        public AttributeDefinition<T> build() {
            return new DefaultDerivedAttributeDefinition(this);
        }
    }
}

