/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.common.db.connection.DatabaseConnection;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.KeyGenerator;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

final class IdentityKeyGenerator
implements KeyGenerator {
    IdentityKeyGenerator() {
    }

    @Override
    public boolean inserted() {
        return false;
    }

    @Override
    public boolean returnGeneratedKeys() {
        return true;
    }

    @Override
    public void afterInsert(Entity entity, DatabaseConnection connection, Statement insertStatement) throws SQLException {
        try (ResultSet generatedKeys = insertStatement.getGeneratedKeys();){
            if (!generatedKeys.next()) {
                throw new SQLException("Identity key generator returned no generated keys", "02000");
            }
            ColumnDefinition<?> column = entity.definition().primaryKey().definitions().get(0);
            entity.put(column.attribute(), column.prepareValue(generatedKeys.getObject(column.name())));
        }
    }
}

