/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.attribute;

import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AuditColumn;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.DefaultAttribute;
import is.codion.framework.domain.entity.attribute.DefaultAuditColumnDefinition;
import is.codion.framework.domain.entity.attribute.DefaultColumnDefinition;
import is.codion.framework.domain.entity.condition.ColumnCondition;
import java.io.Serializable;
import java.sql.Statement;
import java.util.Collection;
import java.util.Objects;

final class DefaultColumn<T>
implements Column<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Attribute<T> attribute;

    DefaultColumn(String name, Class<T> valueClass, EntityType entityType) {
        this.attribute = new DefaultAttribute<T>(name, valueClass, entityType);
    }

    @Override
    public Attribute.Type<T> type() {
        return this.attribute.type();
    }

    @Override
    public String name() {
        return this.attribute.name();
    }

    @Override
    public EntityType entityType() {
        return this.attribute.entityType();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultColumn)) {
            return false;
        }
        DefaultColumn that = (DefaultColumn)object;
        return this.attribute.equals(that.attribute);
    }

    public int hashCode() {
        return this.attribute.hashCode();
    }

    public String toString() {
        return this.attribute.toString();
    }

    @Override
    public Column.ColumnDefiner<T> define() {
        return new DefaultColumnDefiner(this);
    }

    @Override
    public ColumnCondition<T> equalTo(T value) {
        return ColumnCondition.factory(this).equalTo(value);
    }

    @Override
    public ColumnCondition<T> notEqualTo(T value) {
        return ColumnCondition.factory(this).notEqualTo(value);
    }

    @Override
    public ColumnCondition<String> equalToIgnoreCase(String value) {
        return ColumnCondition.factory(this).equalToIgnoreCase(value);
    }

    @Override
    public ColumnCondition<Character> equalToIgnoreCase(Character value) {
        return ColumnCondition.factory(this).equalToIgnoreCase(value);
    }

    @Override
    public ColumnCondition<String> notEqualToIgnoreCase(String value) {
        return ColumnCondition.factory(this).notEqualToIgnoreCase(value);
    }

    @Override
    public ColumnCondition<Character> notEqualToIgnoreCase(Character value) {
        return ColumnCondition.factory(this).notEqualToIgnoreCase(value);
    }

    @Override
    public ColumnCondition<String> like(String value) {
        return ColumnCondition.factory(this).like(value);
    }

    @Override
    public ColumnCondition<String> notLike(String value) {
        return ColumnCondition.factory(this).notLike(value);
    }

    @Override
    public ColumnCondition<String> likeIgnoreCase(String value) {
        return ColumnCondition.factory(this).likeIgnoreCase(value);
    }

    @Override
    public ColumnCondition<String> notLikeIgnoreCase(String value) {
        return ColumnCondition.factory(this).notLikeIgnoreCase(value);
    }

    @Override
    public ColumnCondition<T> in(T ... values) {
        return ColumnCondition.factory(this).in(values);
    }

    @Override
    public ColumnCondition<T> notIn(T ... values) {
        return ColumnCondition.factory(this).notIn(values);
    }

    @Override
    public ColumnCondition<T> in(Collection<? extends T> values) {
        return ColumnCondition.factory(this).in(values);
    }

    @Override
    public ColumnCondition<T> notIn(Collection<? extends T> values) {
        return ColumnCondition.factory(this).notIn(values);
    }

    @Override
    public ColumnCondition<String> inIgnoreCase(String ... values) {
        return ColumnCondition.factory(this).inIgnoreCase(values);
    }

    @Override
    public ColumnCondition<String> notInIgnoreCase(String ... values) {
        return ColumnCondition.factory(this).notInIgnoreCase(values);
    }

    @Override
    public ColumnCondition<String> inIgnoreCase(Collection<String> values) {
        return ColumnCondition.factory(this).inIgnoreCase(values);
    }

    @Override
    public ColumnCondition<String> notInIgnoreCase(Collection<String> values) {
        return ColumnCondition.factory(this).notInIgnoreCase(values);
    }

    @Override
    public ColumnCondition<T> lessThan(T value) {
        return ColumnCondition.factory(this).lessThan(value);
    }

    @Override
    public ColumnCondition<T> lessThanOrEqualTo(T value) {
        return ColumnCondition.factory(this).lessThanOrEqualTo(value);
    }

    @Override
    public ColumnCondition<T> greaterThan(T value) {
        return ColumnCondition.factory(this).greaterThan(value);
    }

    @Override
    public ColumnCondition<T> greaterThanOrEqualTo(T value) {
        return ColumnCondition.factory(this).greaterThanOrEqualTo(value);
    }

    @Override
    public ColumnCondition<T> betweenExclusive(T lowerBound, T upperBound) {
        return ColumnCondition.factory(this).betweenExclusive(lowerBound, upperBound);
    }

    @Override
    public ColumnCondition<T> between(T lowerBound, T upperBound) {
        return ColumnCondition.factory(this).between(lowerBound, upperBound);
    }

    @Override
    public ColumnCondition<T> notBetweenExclusive(T lowerBound, T upperBound) {
        return ColumnCondition.factory(this).notBetweenExclusive(lowerBound, upperBound);
    }

    @Override
    public ColumnCondition<T> notBetween(T lowerBound, T upperBound) {
        return ColumnCondition.factory(this).notBetween(lowerBound, upperBound);
    }

    @Override
    public ColumnCondition<T> isNull() {
        return ColumnCondition.factory(this).isNull();
    }

    @Override
    public ColumnCondition<T> isNotNull() {
        return ColumnCondition.factory(this).isNotNull();
    }

    private final class DefaultColumnDefiner<T>
    extends DefaultAttribute.DefaultAttributeDefiner<T>
    implements Column.ColumnDefiner<T> {
        private static final String COLUMN_CAPTION = "Column";
        private final Column<T> column;

        private DefaultColumnDefiner(Column<T> column) {
            super(column);
            this.column = column;
        }

        @Override
        public <B extends ColumnDefinition.Builder<T, B>> ColumnDefinition.Builder<T, B> column() {
            return new DefaultColumnDefinition.DefaultColumnDefinitionBuilder(this.column);
        }

        @Override
        public <B extends ColumnDefinition.Builder<T, B>> ColumnDefinition.Builder<T, B> primaryKey() {
            return new DefaultColumnDefinition.DefaultColumnDefinitionBuilder(this.column, 0);
        }

        @Override
        public <B extends ColumnDefinition.Builder<T, B>> ColumnDefinition.Builder<T, B> primaryKey(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("Primary key index must be at least 0: " + DefaultColumn.this.attribute);
            }
            return new DefaultColumnDefinition.DefaultColumnDefinitionBuilder(this.column, index);
        }

        @Override
        public <B extends ColumnDefinition.Builder<T, B>> ColumnDefinition.Builder<T, B> subquery(String subquery) {
            return new DefaultColumnDefinition.DefaultSubqueryColumnDefinitionBuilder(this.column, subquery);
        }

        @Override
        public <C, B extends ColumnDefinition.Builder<Boolean, B>> ColumnDefinition.Builder<Boolean, B> booleanColumn(Class<C> columnClass, C trueValue, C falseValue) {
            if (!DefaultColumn.this.type().isBoolean()) {
                throw new IllegalStateException(this.column + " is not a boolean column");
            }
            return new DefaultColumnDefinition.DefaultColumnDefinitionBuilder(this.column).columnClass(columnClass, new BooleanConverter<C>(trueValue, falseValue));
        }

        @Override
        public <B extends ColumnDefinition.Builder<T, B>> ColumnDefinition.Builder<T, B> auditInsertTimeColumn() {
            if (!DefaultColumn.this.type().isTemporal()) {
                throw new IllegalArgumentException("Column " + this.column + " is not a temporal column");
            }
            return new DefaultAuditColumnDefinition.DefaultAuditColumnDefinitionBuilder(this.column, AuditColumn.AuditAction.INSERT);
        }

        @Override
        public <B extends ColumnDefinition.Builder<T, B>> ColumnDefinition.Builder<T, B> auditUpdateTimeColumn() {
            if (!DefaultColumn.this.type().isTemporal()) {
                throw new IllegalArgumentException("Column " + this.column + " is not a temporal column");
            }
            return new DefaultAuditColumnDefinition.DefaultAuditColumnDefinitionBuilder(this.column, AuditColumn.AuditAction.UPDATE);
        }

        @Override
        public <B extends ColumnDefinition.Builder<String, B>> ColumnDefinition.Builder<String, B> auditInsertUserColumn() {
            if (!DefaultColumn.this.type().isString()) {
                throw new IllegalArgumentException("Column " + this.column + " is not a string column");
            }
            return new DefaultAuditColumnDefinition.DefaultAuditColumnDefinitionBuilder(this.column, AuditColumn.AuditAction.INSERT);
        }

        @Override
        public <B extends ColumnDefinition.Builder<String, B>> ColumnDefinition.Builder<String, B> auditUpdateUserColumn() {
            if (!DefaultColumn.this.type().isString()) {
                throw new IllegalArgumentException("Column " + this.column + " is not a string column");
            }
            return new DefaultAuditColumnDefinition.DefaultAuditColumnDefinitionBuilder(this.column, AuditColumn.AuditAction.UPDATE);
        }
    }

    static final class BooleanConverter<T>
    implements Column.Converter<Boolean, T> {
        private final T trueValue;
        private final T falseValue;

        BooleanConverter(T trueValue, T falseValue) {
            this.trueValue = Objects.requireNonNull(trueValue);
            this.falseValue = Objects.requireNonNull(falseValue);
        }

        @Override
        public Boolean fromColumnValue(T columnValue) {
            if (Objects.equals(this.trueValue, columnValue)) {
                return true;
            }
            if (Objects.equals(this.falseValue, columnValue)) {
                return false;
            }
            return null;
        }

        @Override
        public T toColumnValue(Boolean value, Statement statement) {
            if (value == null) {
                return null;
            }
            if (value.booleanValue()) {
                return this.trueValue;
            }
            return this.falseValue;
        }
    }
}

