/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.framework.domain.entity.ColorProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.EntityValidator;
import is.codion.framework.domain.entity.KeyGenerator;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.condition.ConditionProvider;
import is.codion.framework.domain.entity.condition.ConditionType;
import is.codion.framework.domain.entity.query.SelectQuery;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public interface EntityDefinition {
    public static final PropertyValue<Boolean> STRICT_FOREIGN_KEYS = Configuration.booleanValue((String)"codion.domain.strictForeignKeys", (boolean)true);
    public static final PropertyValue<Boolean> OPTIMISTIC_LOCKING = Configuration.booleanValue((String)"codion.domain.optimisticLocking", (boolean)true);

    public EntityType entityType();

    public String tableName();

    public ConditionProvider conditionProvider(ConditionType var1);

    public EntityValidator validator();

    public Predicate<Entity> exists();

    public String caption();

    public String description();

    public boolean smallDataset();

    public boolean readOnly();

    public boolean optimisticLocking();

    public Optional<OrderBy> orderBy();

    public String selectTableName();

    public Optional<SelectQuery> selectQuery();

    public Function<Entity, String> stringFactory();

    public Comparator<Entity> comparator();

    public Attributes attributes();

    public Columns columns();

    public ForeignKeys foreignKeys();

    public PrimaryKey primaryKey();

    public ColorProvider backgroundColorProvider();

    public ColorProvider foregroundColorProvider();

    public Entity entity();

    public Entity entity(Map<Attribute<?>, Object> var1);

    public Entity entity(Map<Attribute<?>, Object> var1, Map<Attribute<?>, Object> var2);

    public <T> Entity.Key primaryKey(T var1);

    public Attribute<?> getterAttribute(Method var1);

    public Attribute<?> setterAttribute(Method var1);

    public MethodHandle defaultMethodHandle(Method var1);

    public static interface PrimaryKey {
        public List<Column<?>> columns();

        public List<ColumnDefinition<?>> definitions();

        public KeyGenerator generator();

        public boolean generated();
    }

    public static interface ForeignKeys {
        public Collection<ForeignKeyDefinition> definitions();

        public Collection<ForeignKey> get();

        public EntityDefinition referencedBy(ForeignKey var1);

        public boolean updatable(ForeignKey var1);

        public boolean foreignKeyColumn(Column<?> var1);

        public Collection<ForeignKey> get(EntityType var1);

        public ForeignKeyDefinition definition(ForeignKey var1);

        public <T> Collection<ForeignKeyDefinition> definitions(Column<T> var1);
    }

    public static interface Columns {
        public Collection<Column<?>> get();

        public List<ColumnDefinition<?>> definitions();

        public Collection<Column<String>> searchable();

        public <T> ColumnDefinition<T> definition(Column<T> var1);
    }

    public static interface Attributes {
        public Collection<Attribute<?>> get();

        public List<AttributeDefinition<?>> definitions();

        public <T> Collection<Attribute<?>> derivedFrom(Attribute<T> var1);

        public boolean contains(Attribute<?> var1);

        public <T> Attribute<T> get(String var1);

        public Collection<Attribute<?>> selected();

        public <T> AttributeDefinition<T> definition(Attribute<T> var1);

        public Collection<AttributeDefinition<?>> updatable();
    }

    public static interface Builder {
        public Builder tableName(String var1);

        public Builder validator(EntityValidator var1);

        public Builder condition(ConditionType var1, ConditionProvider var2);

        public Builder backgroundColorProvider(ColorProvider var1);

        public Builder foregroundColorProvider(ColorProvider var1);

        public Builder caption(String var1);

        public Builder captionResourceKey(String var1);

        public Builder description(String var1);

        public Builder smallDataset(boolean var1);

        public Builder readOnly(boolean var1);

        public Builder optimisticLocking(boolean var1);

        public Builder keyGenerator(KeyGenerator var1);

        public Builder orderBy(OrderBy var1);

        public Builder selectTableName(String var1);

        public Builder selectQuery(SelectQuery var1);

        public Builder stringFactory(Attribute<?> var1);

        public Builder stringFactory(Function<Entity, String> var1);

        public Builder comparator(Comparator<Entity> var1);

        public Builder exists(Predicate<Entity> var1);

        public EntityDefinition build();
    }
}

