/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.common.NullOrEmpty;
import is.codion.common.Primitives;
import is.codion.common.Text;
import is.codion.framework.domain.entity.ColorProvider;
import is.codion.framework.domain.entity.DefaultEntity;
import is.codion.framework.domain.entity.DefaultKey;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.EntityValidator;
import is.codion.framework.domain.entity.KeyGenerator;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.StringFactory;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.DerivedAttributeDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.condition.ConditionProvider;
import is.codion.framework.domain.entity.condition.ConditionType;
import is.codion.framework.domain.entity.query.SelectQuery;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class DefaultEntityDefinition
implements EntityDefinition,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "method";
    private static final String ATTRIBUTE = "attribute";
    private static final String COLUMN = "column";
    private final EntityType entityType;
    private final Map<String, Attribute<?>> getters = new HashMap();
    private final Map<String, Attribute<?>> setters = new HashMap();
    private transient Map<String, MethodHandle> defaultMethodHandles = new ConcurrentHashMap<String, MethodHandle>();
    private final String caption;
    private final String captionResourceKey;
    private transient String resourceCaption;
    private final String description;
    private final OrderBy orderBy;
    private final boolean readOnly;
    private final boolean smallDataset;
    private final boolean keyGenerated;
    private final Function<Entity, String> stringFactory;
    private final ColorProvider backgroundColorProvider;
    private final ColorProvider foregroundColorProvider;
    private final Comparator<Entity> comparator;
    private final EntityValidator validator;
    private final Predicate<Entity> exists;
    private final transient String tableName;
    private final transient String selectTableName;
    private final transient KeyGenerator keyGenerator;
    private final transient boolean optimisticLocking;
    private final transient SelectQuery selectQuery;
    private final transient Map<ConditionType, ConditionProvider> conditionProviders;
    private final Map<ForeignKey, EntityDefinition> referencedEntities = new HashMap<ForeignKey, EntityDefinition>();
    private final EntityAttributes entityAttributes;
    private final EntityDefinition.PrimaryKey primaryKey = new DefaultPrimaryKey();
    private final EntityDefinition.Attributes attributes = new DefaultAttributes();
    private final EntityDefinition.Columns columns = new DefaultColumns();
    private final EntityDefinition.ForeignKeys foreignKeys = new DefaultForeignKeys();

    private DefaultEntityDefinition(DefaultBuilder builder) {
        this.entityType = builder.attributes.entityType;
        this.caption = builder.caption;
        this.captionResourceKey = builder.captionResourceKey;
        this.description = builder.description;
        this.orderBy = builder.orderBy;
        this.readOnly = builder.readOnly;
        this.smallDataset = builder.smallDataset;
        this.keyGenerator = builder.keyGenerator;
        this.keyGenerated = builder.keyGenerated;
        this.optimisticLocking = builder.optimisticLocking;
        this.stringFactory = builder.stringFactory;
        this.backgroundColorProvider = builder.backgroundColorProvider;
        this.foregroundColorProvider = builder.foregroundColorProvider;
        this.comparator = builder.comparator;
        this.validator = builder.validator;
        this.exists = builder.exists;
        this.tableName = builder.tableName;
        this.selectTableName = builder.selectTableName;
        this.selectQuery = builder.selectQuery;
        this.conditionProviders = builder.conditionProviders == null ? null : new HashMap<ConditionType, ConditionProvider>(builder.conditionProviders);
        this.entityAttributes = builder.attributes;
        this.resolveEntityClassMethods();
    }

    @Override
    public EntityType entityType() {
        return this.entityType;
    }

    @Override
    public Attribute<?> getterAttribute(Method method) {
        return this.getters.get(Objects.requireNonNull(method, METHOD).getName());
    }

    @Override
    public Attribute<?> setterAttribute(Method method) {
        return this.setters.get(Objects.requireNonNull(method, METHOD).getName());
    }

    @Override
    public MethodHandle defaultMethodHandle(Method method) {
        return this.defaultMethodHandles.computeIfAbsent(Objects.requireNonNull(method, METHOD).getName(), methodName -> DefaultEntityDefinition.createDefaultMethodHandle(method));
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public ConditionProvider conditionProvider(ConditionType conditionType) {
        ConditionProvider conditionProvider;
        Objects.requireNonNull(conditionType);
        if (this.conditionProviders != null && (conditionProvider = this.conditionProviders.get(conditionType)) != null) {
            return conditionProvider;
        }
        throw new IllegalArgumentException("ConditionProvider for type " + conditionType + " not found");
    }

    @Override
    public String caption() {
        if (this.entityType.resourceBundleName() != null) {
            if (this.resourceCaption == null) {
                ResourceBundle bundle = ResourceBundle.getBundle(this.entityType.resourceBundleName());
                String string = this.resourceCaption = bundle.containsKey(this.captionResourceKey) ? bundle.getString(this.captionResourceKey) : "";
            }
            if (!this.resourceCaption.isEmpty()) {
                return this.resourceCaption;
            }
        }
        return this.caption == null ? this.entityType.name() : this.caption;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public boolean smallDataset() {
        return this.smallDataset;
    }

    @Override
    public boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public boolean optimisticLocking() {
        return this.optimisticLocking;
    }

    @Override
    public Optional<OrderBy> orderBy() {
        return Optional.ofNullable(this.orderBy);
    }

    @Override
    public String selectTableName() {
        return this.selectTableName == null ? this.tableName : this.selectTableName;
    }

    @Override
    public Optional<SelectQuery> selectQuery() {
        return Optional.ofNullable(this.selectQuery);
    }

    @Override
    public Function<Entity, String> stringFactory() {
        return this.stringFactory;
    }

    @Override
    public Comparator<Entity> comparator() {
        return this.comparator;
    }

    @Override
    public EntityDefinition.PrimaryKey primaryKey() {
        return this.primaryKey;
    }

    @Override
    public EntityDefinition.Attributes attributes() {
        return this.attributes;
    }

    @Override
    public EntityDefinition.Columns columns() {
        return this.columns;
    }

    @Override
    public EntityDefinition.ForeignKeys foreignKeys() {
        return this.foreignKeys;
    }

    public String toString() {
        return this.entityType.name();
    }

    @Override
    public EntityValidator validator() {
        return this.validator;
    }

    @Override
    public Predicate<Entity> exists() {
        return this.exists;
    }

    @Override
    public ColorProvider backgroundColorProvider() {
        return this.backgroundColorProvider;
    }

    @Override
    public ColorProvider foregroundColorProvider() {
        return this.foregroundColorProvider;
    }

    @Override
    public Entity entity() {
        return this.entity(null);
    }

    @Override
    public Entity entity(Map<Attribute<?>, Object> values) {
        return this.entity(values, null);
    }

    @Override
    public Entity entity(Map<Attribute<?>, Object> values, Map<Attribute<?>, Object> originalValues) {
        return new DefaultEntity(this, values, originalValues);
    }

    @Override
    public <T> Entity.Key primaryKey(T value) {
        if (this.primaryKey.columns().isEmpty()) {
            throw new IllegalArgumentException("Entity '" + this.entityType + "' has no primary key");
        }
        if (this.primaryKey.columns().size() > 1) {
            throw new IllegalStateException(this.entityType + " has a composite primary key");
        }
        Column<?> column = this.primaryKey.columns().get(0);
        column.type().validateType(value);
        return new DefaultKey(this, column, value, true);
    }

    boolean hasReferencedEntityDefinition(ForeignKey foreignKey) {
        return this.referencedEntities.containsKey(foreignKey);
    }

    void setReferencedEntityDefinition(ForeignKey foreignKey, EntityDefinition definition) {
        if (this.referencedEntities.containsKey(foreignKey)) {
            throw new IllegalStateException("Foreign definition has already been set for " + foreignKey);
        }
        if (!foreignKey.referencedType().equals(definition.entityType())) {
            throw new IllegalArgumentException("Definition for entity " + foreignKey.referencedType() + " expected for " + foreignKey);
        }
        this.referencedEntities.put(foreignKey, definition);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.defaultMethodHandles = new ConcurrentHashMap<String, MethodHandle>();
    }

    private void resolveEntityClassMethods() {
        if (!this.entityType.entityClass().equals(Entity.class)) {
            for (Method method : this.entityType.entityClass().getDeclaredMethods()) {
                if (method.isDefault()) {
                    this.defaultMethodHandles.put(method.getName(), DefaultEntityDefinition.createDefaultMethodHandle(method));
                    continue;
                }
                this.attributes.definitions().stream().filter(definition -> DefaultEntityDefinition.isGetter(method, definition)).findFirst().ifPresent(definition -> this.getters.put(method.getName(), definition.attribute()));
                this.attributes.definitions().stream().filter(definition -> DefaultEntityDefinition.isSetter(method, definition)).findFirst().ifPresent(definition -> this.setters.put(method.getName(), definition.attribute()));
            }
        }
    }

    private static MethodHandle createDefaultMethodHandle(Method method) {
        try {
            Method privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)privateLookupIn.invoke(MethodHandles.class, method.getDeclaringClass(), MethodHandles.lookup());
            return lookup.findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), method.getDeclaringClass());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isGetter(Method method, AttributeDefinition<?> definition) {
        String beanProperty = definition.beanProperty();
        if (beanProperty == null || method.getParameterCount() > 0) {
            return false;
        }
        String beanPropertyCamelCase = beanProperty.substring(0, 1).toUpperCase() + beanProperty.substring(1);
        String methodName = method.getName();
        Class<?> attributeValueClass = DefaultEntityDefinition.attributeValueClass(definition.attribute());
        Class<?> methodReturnType = DefaultEntityDefinition.methodReturnType(method);
        return DefaultEntityDefinition.returnsAttributeValueClassOrOptional(methodReturnType, attributeValueClass) && (DefaultEntityDefinition.isBeanOrPropertyGetter(methodName, beanProperty, beanPropertyCamelCase) || DefaultEntityDefinition.isBooleanGetter(methodName, beanPropertyCamelCase, attributeValueClass));
    }

    private static boolean returnsAttributeValueClassOrOptional(Class<?> methodReturnType, Class<?> attributeValueClass) {
        return methodReturnType.equals(attributeValueClass) || methodReturnType.equals(Optional.class);
    }

    private static boolean isBeanOrPropertyGetter(String methodName, String beanProperty, String beanPropertyCamelCase) {
        return methodName.equals(beanProperty) || methodName.equals("get" + beanPropertyCamelCase);
    }

    private static boolean isBooleanGetter(String methodName, String beanPropertyCamelCase, Class<?> attributeValueClass) {
        return methodName.equals("is" + beanPropertyCamelCase) && Boolean.class.equals(attributeValueClass);
    }

    private static Class<?> methodReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            return Primitives.boxedType(returnType);
        }
        return returnType;
    }

    private static boolean isSetter(Method method, AttributeDefinition<?> definition) {
        Class<?> attributeValueClass;
        String beanProperty = definition.beanProperty();
        if (beanProperty == null || method.getParameterCount() != 1 || method.isVarArgs()) {
            return false;
        }
        String beanPropertyCamelCase = beanProperty.substring(0, 1).toUpperCase() + beanProperty.substring(1);
        String methodName = method.getName();
        Class<?> parameterType = DefaultEntityDefinition.setterParameterType(method);
        return parameterType.equals(attributeValueClass = DefaultEntityDefinition.attributeValueClass(definition.attribute())) && (methodName.equals(beanProperty) || methodName.equals("set" + beanPropertyCamelCase));
    }

    private static Class<?> setterParameterType(Method method) {
        Class<?> parameterType = method.getParameterTypes()[0];
        if (parameterType.isPrimitive()) {
            return Primitives.boxedType(parameterType);
        }
        return parameterType;
    }

    private static Class<?> attributeValueClass(Attribute<?> attribute) {
        Class<Object> valueClass = attribute.type().valueClass();
        if (attribute instanceof ForeignKey) {
            valueClass = ((ForeignKey)attribute).referencedType().entityClass();
        }
        return valueClass;
    }

    private final class DefaultPrimaryKey
    implements EntityDefinition.PrimaryKey,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DefaultPrimaryKey() {
        }

        @Override
        public List<Column<?>> columns() {
            return DefaultEntityDefinition.this.entityAttributes.primaryKeyColumns;
        }

        @Override
        public List<ColumnDefinition<?>> definitions() {
            return DefaultEntityDefinition.this.entityAttributes.primaryKeyColumnDefinitions;
        }

        @Override
        public KeyGenerator generator() {
            return DefaultEntityDefinition.this.keyGenerator;
        }

        @Override
        public boolean generated() {
            return DefaultEntityDefinition.this.keyGenerated;
        }
    }

    private final class DefaultAttributes
    implements EntityDefinition.Attributes,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DefaultAttributes() {
        }

        @Override
        public Collection<Attribute<?>> get() {
            return DefaultEntityDefinition.this.entityAttributes.attributeDefinitions.stream().map(AttributeDefinition::attribute).collect(Collectors.toList());
        }

        @Override
        public List<AttributeDefinition<?>> definitions() {
            return DefaultEntityDefinition.this.entityAttributes.attributeDefinitions;
        }

        @Override
        public <T> Collection<Attribute<?>> derivedFrom(Attribute<T> attribute) {
            return DefaultEntityDefinition.this.entityAttributes.derivedAttributes.getOrDefault(Objects.requireNonNull(attribute, DefaultEntityDefinition.ATTRIBUTE), Collections.emptySet());
        }

        @Override
        public boolean contains(Attribute<?> attribute) {
            return DefaultEntityDefinition.this.entityAttributes.attributeMap.containsKey(Objects.requireNonNull(attribute));
        }

        @Override
        public <T> Attribute<T> get(String attributeName) {
            return DefaultEntityDefinition.this.entityAttributes.attributeNameMap.get(Objects.requireNonNull(attributeName));
        }

        @Override
        public Collection<Attribute<?>> selected() {
            return DefaultEntityDefinition.this.entityAttributes.defaultSelectAttributes;
        }

        @Override
        public <T> AttributeDefinition<T> definition(Attribute<T> attribute) {
            AttributeDefinition<?> definition = DefaultEntityDefinition.this.entityAttributes.attributeMap.get(Objects.requireNonNull(attribute, DefaultEntityDefinition.ATTRIBUTE));
            if (definition == null) {
                throw new IllegalArgumentException("Attribute " + attribute + " not found in entity: " + DefaultEntityDefinition.this.entityType);
            }
            return definition;
        }

        @Override
        public Collection<AttributeDefinition<?>> updatable() {
            List updatableColumns = DefaultEntityDefinition.this.entityAttributes.columnDefinitions.stream().filter(ColumnDefinition::updatable).filter(column -> !column.primaryKey() || !DefaultEntityDefinition.this.primaryKey.generated()).collect(Collectors.toList());
            updatableColumns.removeIf(column -> DefaultEntityDefinition.this.foreignKeys.foreignKeyColumn((Column<?>)column.attribute()));
            ArrayList updatable = new ArrayList(updatableColumns);
            for (ForeignKeyDefinition definition : DefaultEntityDefinition.this.entityAttributes.foreignKeyDefinitions) {
                if (!DefaultEntityDefinition.this.foreignKeys.updatable(definition.attribute())) continue;
                updatable.add(definition);
            }
            return updatable;
        }
    }

    private final class DefaultColumns
    implements EntityDefinition.Columns,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DefaultColumns() {
        }

        @Override
        public Collection<Column<?>> get() {
            return DefaultEntityDefinition.this.entityAttributes.columns;
        }

        @Override
        public List<ColumnDefinition<?>> definitions() {
            return DefaultEntityDefinition.this.entityAttributes.columnDefinitions;
        }

        @Override
        public Collection<Column<String>> searchable() {
            return DefaultEntityDefinition.this.entityAttributes.columnDefinitions.stream().filter(ColumnDefinition::searchable).map(column -> column.attribute()).collect(Collectors.toList());
        }

        @Override
        public <T> ColumnDefinition<T> definition(Column<T> column) {
            AttributeDefinition<?> definition = DefaultEntityDefinition.this.entityAttributes.attributeMap.get(Objects.requireNonNull(column, DefaultEntityDefinition.COLUMN));
            if (definition == null) {
                throw new IllegalArgumentException("Column " + column + " not found in entity: " + DefaultEntityDefinition.this.entityType);
            }
            if (!(definition instanceof ColumnDefinition)) {
                throw new IllegalArgumentException("Column " + column + " has not been defined as a column");
            }
            return (ColumnDefinition)definition;
        }
    }

    private final class DefaultForeignKeys
    implements EntityDefinition.ForeignKeys,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DefaultForeignKeys() {
        }

        @Override
        public Collection<ForeignKeyDefinition> definitions() {
            return DefaultEntityDefinition.this.entityAttributes.foreignKeyDefinitions;
        }

        @Override
        public Collection<ForeignKey> get() {
            return DefaultEntityDefinition.this.entityAttributes.foreignKeyDefinitionMap.keySet();
        }

        @Override
        public EntityDefinition referencedBy(ForeignKey foreignKey) {
            this.definition(foreignKey);
            EntityDefinition definition = DefaultEntityDefinition.this.referencedEntities.get(foreignKey);
            if (definition == null) {
                throw new IllegalArgumentException("Referenced entity definition not found for foreign key: " + foreignKey);
            }
            return definition;
        }

        @Override
        public boolean updatable(ForeignKey foreignKey) {
            this.definition(foreignKey);
            return foreignKey.references().stream().map(reference -> DefaultEntityDefinition.this.columns.definition(reference.column())).allMatch(ColumnDefinition::updatable);
        }

        @Override
        public boolean foreignKeyColumn(Column<?> column) {
            DefaultEntityDefinition.this.attributes.definition(column);
            return DefaultEntityDefinition.this.entityAttributes.foreignKeyColumns.contains(column);
        }

        @Override
        public Collection<ForeignKey> get(EntityType referencedEntityType) {
            Objects.requireNonNull(referencedEntityType, "referencedEntityType");
            return this.get().stream().filter(foreignKey -> foreignKey.referencedType().equals(referencedEntityType)).collect(Collectors.toList());
        }

        @Override
        public ForeignKeyDefinition definition(ForeignKey foreignKey) {
            ForeignKeyDefinition definition = DefaultEntityDefinition.this.entityAttributes.foreignKeyDefinitionMap.get(Objects.requireNonNull(foreignKey, "foreignKey"));
            if (definition == null) {
                throw new IllegalArgumentException("Foreign key: " + foreignKey + " not found in entity of type: " + DefaultEntityDefinition.this.entityType);
            }
            return definition;
        }

        @Override
        public <T> Collection<ForeignKeyDefinition> definitions(Column<T> column) {
            return DefaultEntityDefinition.this.entityAttributes.columnForeignKeyDefinitions.getOrDefault(Objects.requireNonNull(column, DefaultEntityDefinition.COLUMN), Collections.emptyList());
        }
    }

    static final class DefaultBuilder
    implements EntityDefinition.Builder {
        private final EntityAttributes attributes;
        private String tableName;
        private Map<ConditionType, ConditionProvider> conditionProviders;
        private String caption;
        private String captionResourceKey;
        private String description;
        private boolean smallDataset;
        private boolean readOnly;
        private KeyGenerator keyGenerator = DefaultEntity.DEFAULT_KEY_GENERATOR;
        private boolean keyGenerated;
        private boolean optimisticLocking = (Boolean)EntityDefinition.OPTIMISTIC_LOCKING.get();
        private OrderBy orderBy;
        private String selectTableName;
        private SelectQuery selectQuery;
        private Function<Entity, String> stringFactory = DefaultEntity.DEFAULT_STRING_FACTORY;
        private ColorProvider backgroundColorProvider = DefaultEntity.NULL_COLOR_PROVIDER;
        private ColorProvider foregroundColorProvider = DefaultEntity.NULL_COLOR_PROVIDER;
        private Comparator<Entity> comparator = Text.collator();
        private EntityValidator validator = DefaultEntity.DEFAULT_VALIDATOR;
        private Predicate<Entity> exists = DefaultEntity.DEFAULT_EXISTS;

        DefaultBuilder(EntityType entityType, List<AttributeDefinition.Builder<?, ?>> attributeDefinitionBuilders) {
            this.attributes = new EntityAttributes(entityType, attributeDefinitionBuilders);
            this.tableName = this.attributes.entityType.name();
            this.captionResourceKey = this.attributes.entityType.name();
        }

        @Override
        public EntityDefinition.Builder tableName(String tableName) {
            if (NullOrEmpty.nullOrEmpty((String)tableName)) {
                throw new IllegalArgumentException("Table name must be non-empty");
            }
            this.tableName = tableName;
            return this;
        }

        @Override
        public EntityDefinition.Builder condition(ConditionType conditionType, ConditionProvider conditionProvider) {
            Objects.requireNonNull(conditionType, "conditionType");
            Objects.requireNonNull(conditionProvider, "conditionProvider");
            if (this.conditionProviders == null) {
                this.conditionProviders = new HashMap<ConditionType, ConditionProvider>();
            }
            if (this.conditionProviders.containsKey(conditionType)) {
                throw new IllegalStateException("ConditionProvider for condition type  " + conditionType + " has already been added");
            }
            this.conditionProviders.put(conditionType, conditionProvider);
            return this;
        }

        @Override
        public EntityDefinition.Builder caption(String caption) {
            this.caption = Objects.requireNonNull(caption, "caption");
            return this;
        }

        @Override
        public EntityDefinition.Builder captionResourceKey(String captionResourceKey) {
            if (this.caption != null) {
                throw new IllegalStateException("Caption has already been set for entity: " + this.attributes.entityType);
            }
            this.captionResourceKey = Objects.requireNonNull(captionResourceKey, "captionResourceKey");
            return this;
        }

        @Override
        public EntityDefinition.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public EntityDefinition.Builder smallDataset(boolean smallDataset) {
            this.smallDataset = smallDataset;
            return this;
        }

        @Override
        public EntityDefinition.Builder readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Override
        public EntityDefinition.Builder optimisticLocking(boolean optimisticLocking) {
            this.optimisticLocking = optimisticLocking;
            return this;
        }

        @Override
        public EntityDefinition.Builder keyGenerator(KeyGenerator keyGenerator) {
            if (this.attributes.primaryKeyColumnDefinitions.isEmpty()) {
                throw new IllegalStateException("KeyGenerator can not be set for an entity without a primary key: " + this.attributes.entityType);
            }
            this.keyGenerator = Objects.requireNonNull(keyGenerator, "keyGenerator");
            this.keyGenerated = true;
            return this;
        }

        @Override
        public EntityDefinition.Builder orderBy(OrderBy orderBy) {
            this.orderBy = Objects.requireNonNull(orderBy, "orderBy");
            return this;
        }

        @Override
        public EntityDefinition.Builder selectTableName(String selectTableName) {
            this.selectTableName = Objects.requireNonNull(selectTableName, "selectTableName");
            return this;
        }

        @Override
        public EntityDefinition.Builder selectQuery(SelectQuery selectQuery) {
            this.selectQuery = Objects.requireNonNull(selectQuery, "selectQuery");
            return this;
        }

        @Override
        public EntityDefinition.Builder comparator(Comparator<Entity> comparator) {
            this.comparator = Objects.requireNonNull(comparator, "comparator");
            return this;
        }

        @Override
        public EntityDefinition.Builder stringFactory(Attribute<?> attribute) {
            return this.stringFactory(StringFactory.builder().value(attribute).build());
        }

        @Override
        public EntityDefinition.Builder stringFactory(Function<Entity, String> stringFactory) {
            this.stringFactory = Objects.requireNonNull(stringFactory, "stringFactory");
            return this;
        }

        @Override
        public EntityDefinition.Builder backgroundColorProvider(ColorProvider backgroundColorProvider) {
            this.backgroundColorProvider = Objects.requireNonNull(backgroundColorProvider, "backgroundColorProvider");
            return this;
        }

        @Override
        public EntityDefinition.Builder foregroundColorProvider(ColorProvider foregroundColorProvider) {
            this.foregroundColorProvider = Objects.requireNonNull(foregroundColorProvider, "foregroundColorProvider");
            return this;
        }

        @Override
        public EntityDefinition.Builder validator(EntityValidator validator) {
            this.validator = Objects.requireNonNull(validator, "validator");
            return this;
        }

        @Override
        public EntityDefinition.Builder exists(Predicate<Entity> exists) {
            this.exists = Objects.requireNonNull(exists);
            return this;
        }

        @Override
        public EntityDefinition build() {
            return new DefaultEntityDefinition(this);
        }
    }

    private static final class EntityAttributes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final EntityType entityType;
        private final Map<String, Attribute<?>> attributeNameMap;
        private final Map<Attribute<?>, AttributeDefinition<?>> attributeMap;
        private final List<AttributeDefinition<?>> attributeDefinitions;
        private final List<ColumnDefinition<?>> columnDefinitions;
        private final Collection<Column<?>> columns;
        private final List<Column<?>> primaryKeyColumns;
        private final List<ColumnDefinition<?>> primaryKeyColumnDefinitions;
        private final List<ForeignKeyDefinition> foreignKeyDefinitions;
        private final Map<ForeignKey, ForeignKeyDefinition> foreignKeyDefinitionMap;
        private final Map<Column<?>, Collection<ForeignKeyDefinition>> columnForeignKeyDefinitions;
        private final Set<Column<?>> foreignKeyColumns = new HashSet();
        private final Map<Attribute<?>, Set<Attribute<?>>> derivedAttributes;
        private final List<Attribute<?>> defaultSelectAttributes;

        private EntityAttributes(EntityType entityType, List<AttributeDefinition.Builder<?, ?>> attributeDefinitionBuilders) {
            this.entityType = Objects.requireNonNull(entityType);
            if (Objects.requireNonNull(attributeDefinitionBuilders, "attributeDefinitionBuilders").isEmpty()) {
                throw new IllegalArgumentException("One or more attribute definition builder must be specified when defining an entity");
            }
            List attributeEntityTypes = attributeDefinitionBuilders.stream().map(builder -> builder.attribute().entityType()).distinct().collect(Collectors.toList());
            if (attributeEntityTypes.size() > 1) {
                throw new IllegalArgumentException("Multiple entityTypes found among attribute definitions: " + attributeEntityTypes);
            }
            if (!entityType.equals(attributeEntityTypes.get(0))) {
                throw new IllegalArgumentException("Entity definition: " + entityType + ", " + attributeEntityTypes.get(0) + " found in attribute definitions");
            }
            this.attributeMap = Collections.unmodifiableMap(this.attributeMap(attributeDefinitionBuilders));
            this.attributeNameMap = Collections.unmodifiableMap(EntityAttributes.attributeNameMap(this.attributeMap));
            this.attributeDefinitions = Collections.unmodifiableList(new ArrayList(this.attributeMap.values()));
            this.columnDefinitions = Collections.unmodifiableList(this.columnDefinitions());
            this.columns = Collections.unmodifiableList(this.columnDefinitions.stream().map(ColumnDefinition::attribute).collect(Collectors.toList()));
            this.primaryKeyColumnDefinitions = Collections.unmodifiableList(this.primaryKeyColumnDefinitions());
            this.primaryKeyColumns = Collections.unmodifiableList(this.primaryKeyColumns());
            this.foreignKeyDefinitions = Collections.unmodifiableList(this.foreignKeyDefinitions());
            this.foreignKeyDefinitionMap = Collections.unmodifiableMap(this.foreignKeyDefinitionMap());
            this.columnForeignKeyDefinitions = Collections.unmodifiableMap(this.columnForeignKeyDefinitions());
            this.derivedAttributes = Collections.unmodifiableMap(this.derivedAttributes());
            this.defaultSelectAttributes = Collections.unmodifiableList(this.defaultSelectAttributes());
        }

        private Map<Attribute<?>, AttributeDefinition<?>> attributeMap(List<AttributeDefinition.Builder<?, ?>> builders) {
            HashMap attributes = new HashMap(builders.size());
            for (AttributeDefinition.Builder<?, ?> builder : builders) {
                if (builder instanceof ForeignKeyDefinition.Builder) continue;
                EntityAttributes.validateAndAddAttribute(builder.build(), attributes, this.entityType);
            }
            EntityAttributes.validatePrimaryKeyAttributes(attributes, this.entityType);
            this.configureForeignKeyColumns(builders.stream().filter(ForeignKeyDefinition.Builder.class::isInstance).map(ForeignKeyDefinition.Builder.class::cast).collect(Collectors.toList()), attributes);
            for (AttributeDefinition.Builder<?, ?> builder : builders) {
                if (!(builder instanceof ForeignKeyDefinition.Builder)) continue;
                EntityAttributes.validateAndAddAttribute(builder.build(), attributes, this.entityType);
            }
            LinkedHashMap ordereredMap = new LinkedHashMap(builders.size());
            for (AttributeDefinition.Builder<?, ?> builder : builders) {
                ordereredMap.put(builder.attribute(), (AttributeDefinition)attributes.get(builder.attribute()));
            }
            return ordereredMap;
        }

        private Map<Column<?>, Collection<ForeignKeyDefinition>> columnForeignKeyDefinitions() {
            HashMap foreignKeyMap = new HashMap();
            this.foreignKeyDefinitions.forEach(foreignKeyDefinition -> foreignKeyDefinition.references().forEach(reference -> foreignKeyMap.computeIfAbsent(reference.column(), columnAttribute -> new ArrayList()).add(foreignKeyDefinition)));
            return foreignKeyMap;
        }

        private void configureForeignKeyColumns(List<ForeignKeyDefinition.Builder> foreignKeyBuilders, Map<Attribute<?>, AttributeDefinition<?>> attributeMap) {
            Map foreignKeyColumnDefinitions = foreignKeyBuilders.stream().map(AttributeDefinition.Builder::attribute).map(ForeignKey.class::cast).collect(Collectors.toMap(Function.identity(), foreignKey -> EntityAttributes.foreignKeyColumnDefinitions(foreignKey, attributeMap)));
            this.foreignKeyColumns.addAll(foreignKeyColumnDefinitions.values().stream().flatMap(definitions -> definitions.stream().map(ColumnDefinition::attribute)).collect(Collectors.toSet()));
            foreignKeyBuilders.forEach(foreignKeyBuilder -> EntityAttributes.setForeignKeyNullable(foreignKeyBuilder, foreignKeyColumnDefinitions));
        }

        private List<ForeignKeyDefinition> foreignKeyDefinitions() {
            return this.attributeDefinitions.stream().filter(ForeignKeyDefinition.class::isInstance).map(ForeignKeyDefinition.class::cast).collect(Collectors.toList());
        }

        private List<ColumnDefinition<?>> columnDefinitions() {
            return this.attributeDefinitions.stream().filter(ColumnDefinition.class::isInstance).map(column -> (ColumnDefinition)column).collect(Collectors.toList());
        }

        private List<Attribute<?>> defaultSelectAttributes() {
            List<Attribute<?>> selectableAttributes = this.columnDefinitions.stream().filter(ColumnDefinition::selectable).filter(column -> !column.lazy()).map(AttributeDefinition::attribute).collect(Collectors.toList());
            selectableAttributes.addAll(this.foreignKeyDefinitions.stream().map(ForeignKeyDefinition::attribute).filter(this::basedOnEagerlyLoadedColumns).collect(Collectors.toList()));
            return selectableAttributes;
        }

        private boolean basedOnEagerlyLoadedColumns(ForeignKey foreignKey) {
            return Collections.disjoint(foreignKey.references().stream().map(ForeignKey.Reference::column).collect(Collectors.toSet()), this.columnDefinitions.stream().filter(ColumnDefinition::lazy).map(ColumnDefinition::attribute).collect(Collectors.toSet()));
        }

        private Map<Attribute<?>, Set<Attribute<?>>> derivedAttributes() {
            HashMap derivedAttributeMap = new HashMap();
            this.attributeDefinitions.stream().filter(DerivedAttributeDefinition.class::isInstance).map(DerivedAttributeDefinition.class::cast).forEach(derivedAttribute -> {
                List<Attribute<?>> sourceAttributes = derivedAttribute.sourceAttributes();
                for (Attribute<?> sourceAttribute : sourceAttributes) {
                    derivedAttributeMap.computeIfAbsent(sourceAttribute, attribute -> new HashSet()).add(derivedAttribute.attribute());
                }
            });
            return derivedAttributeMap;
        }

        private List<ColumnDefinition<?>> primaryKeyColumnDefinitions() {
            return this.attributeDefinitions.stream().filter(ColumnDefinition.class::isInstance).map(column -> (ColumnDefinition)column).filter(ColumnDefinition::primaryKey).sorted(Comparator.comparingInt(ColumnDefinition::primaryKeyIndex)).collect(Collectors.toList());
        }

        private List<Column<?>> primaryKeyColumns() {
            return this.primaryKeyColumnDefinitions.stream().map(ColumnDefinition::attribute).collect(Collectors.toList());
        }

        private static Map<String, Attribute<?>> attributeNameMap(Map<Attribute<?>, AttributeDefinition<?>> attributeDefinitions) {
            return attributeDefinitions.keySet().stream().collect(Collectors.toMap(Attribute::name, Function.identity()));
        }

        private static void validateAndAddAttribute(AttributeDefinition<?> definition, Map<Attribute<?>, AttributeDefinition<?>> attributeDefinitions, EntityType entityType) {
            EntityAttributes.validate(definition, attributeDefinitions, entityType);
            attributeDefinitions.put(definition.attribute(), definition);
        }

        private static void validatePrimaryKeyAttributes(Map<Attribute<?>, AttributeDefinition<?>> attributeDefinitions, EntityType entityType) {
            LinkedHashSet<Integer> usedPrimaryKeyIndexes = new LinkedHashSet<Integer>();
            for (AttributeDefinition<?> definition : attributeDefinitions.values()) {
                if (!(definition instanceof ColumnDefinition) || !((ColumnDefinition)definition).primaryKey()) continue;
                Integer index = ((ColumnDefinition)definition).primaryKeyIndex();
                if (usedPrimaryKeyIndexes.contains(index)) {
                    throw new IllegalArgumentException("Primary key index " + index + " in column " + definition + " has already been used");
                }
                usedPrimaryKeyIndexes.add(index);
            }
            usedPrimaryKeyIndexes.stream().min(Integer::compareTo).ifPresent(minPrimaryKeyIndex -> {
                if (minPrimaryKeyIndex != 0) {
                    throw new IllegalArgumentException("Minimum primary key index is " + minPrimaryKeyIndex + " for entity " + entityType + ", when it should be 0");
                }
            });
            usedPrimaryKeyIndexes.stream().max(Integer::compareTo).ifPresent(maxPrimaryKeyIndex -> {
                if (usedPrimaryKeyIndexes.size() != maxPrimaryKeyIndex + 1) {
                    throw new IllegalArgumentException("Expecting " + (maxPrimaryKeyIndex + 1) + " primary key columns for entity " + entityType + ", but found only " + usedPrimaryKeyIndexes.size() + " distinct primary key indexes " + usedPrimaryKeyIndexes.stream().sorted().collect(Collectors.toList()));
                }
            });
        }

        private static void validate(AttributeDefinition<?> definition, Map<Attribute<?>, AttributeDefinition<?>> attributeDefinitions, EntityType entityType) {
            if (!entityType.equals(definition.entityType())) {
                throw new IllegalArgumentException("Attribute entityType (" + definition.entityType() + ") in attribute " + definition.attribute() + " does not match the definition entityType: " + entityType);
            }
            if (attributeDefinitions.containsKey(definition.attribute())) {
                throw new IllegalArgumentException("Attribute " + definition.attribute() + (String)(definition.caption() != null ? " (" + definition.caption() + ")" : "") + " has already been defined as: " + attributeDefinitions.get(definition.attribute()) + " in entity: " + entityType);
            }
        }

        private Map<ForeignKey, ForeignKeyDefinition> foreignKeyDefinitionMap() {
            return this.foreignKeyDefinitions.stream().collect(Collectors.toMap(ForeignKeyDefinition::attribute, Function.identity()));
        }

        private static List<ColumnDefinition<?>> foreignKeyColumnDefinitions(ForeignKey foreignKey, Map<Attribute<?>, AttributeDefinition<?>> attributeDefinitions) {
            return foreignKey.references().stream().map(reference -> EntityAttributes.foreignKeyColumnDefinition(reference, attributeDefinitions)).collect(Collectors.toList());
        }

        private static ColumnDefinition<?> foreignKeyColumnDefinition(ForeignKey.Reference<?> reference, Map<Attribute<?>, AttributeDefinition<?>> attributeMap) {
            ColumnDefinition definition = (ColumnDefinition)attributeMap.get(reference.column());
            if (definition == null) {
                throw new IllegalArgumentException("Column definition based on column: " + reference.column() + " not found when initializing foreign key");
            }
            return definition;
        }

        private static void setForeignKeyNullable(ForeignKeyDefinition.Builder foreignKeyBuilder, Map<ForeignKey, List<ColumnDefinition<?>>> foreignKeyColumnDefinitions) {
            foreignKeyBuilder.nullable(foreignKeyColumnDefinitions.get(foreignKeyBuilder.attribute()).stream().anyMatch(AttributeDefinition::nullable));
        }
    }
}

