/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.framework.domain.entity.DefaultEntity;
import is.codion.framework.domain.entity.DefaultKey;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntitySerializer;
import is.codion.framework.domain.entity.attribute.Attribute;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

final class ImmutableEntity
extends DefaultEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_MESSAGE = "This entity instance is immutable";

    ImmutableEntity(DefaultEntity entity) {
        this.definition = entity.definition();
        this.values = new HashMap(entity.values);
        this.values.forEach(new ReplaceWithImmutable(this.values));
        if (entity.originalValues != null) {
            this.originalValues = new HashMap(entity.originalValues);
            this.originalValues.forEach(new ReplaceWithImmutable(this.originalValues));
        }
    }

    @Override
    public <T> T put(Attribute<T> attribute, T value) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public Entity clearPrimaryKey() {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public void save(Attribute<?> attribute) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public void save() {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public void revert(Attribute<?> attribute) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public void revert() {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public <T> T remove(Attribute<T> attribute) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    @Override
    public Map<Attribute<?>, Object> set(Entity entity) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.definition.entityType().domainType().name());
        EntitySerializer.serialize(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        DefaultKey.serializerForDomain((String)stream.readObject()).deserialize(this, stream);
    }

    private static final class ReplaceWithImmutable
    implements BiConsumer<Attribute<?>, Object> {
        private final Map<Attribute<?>, Object> map;

        private ReplaceWithImmutable(Map<Attribute<?>, Object> map) {
            this.map = map;
        }

        @Override
        public void accept(Attribute<?> attribute, Object value) {
            if (value instanceof Entity && !(value instanceof ImmutableEntity)) {
                this.map.replace(attribute, ((Entity)value).immutable());
            }
        }
    }
}

