/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.condition;

import is.codion.common.Conjunction;
import is.codion.common.Operator;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.ConditionType;
import is.codion.framework.domain.entity.condition.CustomCondition;
import is.codion.framework.domain.entity.condition.DefaultAllCondition;
import is.codion.framework.domain.entity.condition.DefaultConditionCombination;
import is.codion.framework.domain.entity.condition.DefaultCustomCondition;
import is.codion.framework.domain.entity.condition.DefaultForeignKeyConditionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface Condition {
    public EntityType entityType();

    public List<?> values();

    public List<Column<?>> columns();

    public String toString(EntityDefinition var1);

    public static Condition all(EntityType entityType) {
        return new DefaultAllCondition(entityType);
    }

    public static Condition key(Entity.Key key) {
        if (Objects.requireNonNull(key).columns().size() > 1) {
            Map<Column<?>, Column<?>> columnMap = key.columns().stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
            HashMap valueMap = new HashMap();
            key.columns().forEach(column -> valueMap.put(column, key.get(column)));
            return DefaultForeignKeyConditionFactory.compositeEqualCondition(columnMap, Operator.EQUAL, valueMap);
        }
        return key.column().equalTo(key.get());
    }

    public static Condition keys(Collection<Entity.Key> keys) {
        Entity.Key firstKey;
        if (Objects.requireNonNull(keys).isEmpty()) {
            throw new IllegalArgumentException("No keys specified for key condition");
        }
        Set entityTypes = keys.stream().map(Entity.Key::entityType).collect(Collectors.toSet());
        if (entityTypes.size() > 1) {
            throw new IllegalArgumentException("Multiple entity types found among keys");
        }
        Entity.Key key2 = firstKey = keys instanceof List ? (Entity.Key)((List)keys).get(0) : keys.iterator().next();
        if (firstKey.columns().size() > 1) {
            Map<Column<?>, Column<?>> columnMap = firstKey.columns().stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
            ArrayList valueMaps = new ArrayList(keys.size());
            keys.forEach(key -> {
                HashMap valueMap = new HashMap();
                key.columns().forEach(column -> valueMap.put(column, key.get(column)));
                valueMaps.add(valueMap);
            });
            return DefaultForeignKeyConditionFactory.compositeKeyCondition(columnMap, Operator.EQUAL, valueMaps);
        }
        return firstKey.column().in(Entity.values(keys));
    }

    public static Combination and(Condition ... conditions) {
        return Condition.and(Arrays.asList(conditions));
    }

    public static Combination and(Collection<Condition> conditions) {
        return Condition.combination(Conjunction.AND, conditions);
    }

    public static Combination or(Condition ... conditions) {
        return Condition.or(Arrays.asList(conditions));
    }

    public static Combination or(Collection<Condition> conditions) {
        return Condition.combination(Conjunction.OR, conditions);
    }

    public static Combination combination(Conjunction conjunction, Condition ... conditions) {
        return Condition.combination(conjunction, Arrays.asList(Objects.requireNonNull(conditions)));
    }

    public static Combination combination(Conjunction conjunction, Collection<Condition> conditions) {
        return new DefaultConditionCombination(conjunction, new ArrayList<Condition>(Objects.requireNonNull(conditions)));
    }

    public static CustomCondition custom(ConditionType conditionType) {
        return Condition.custom(conditionType, Collections.emptyList(), Collections.emptyList());
    }

    public static CustomCondition custom(ConditionType conditionType, List<Column<?>> columns, List<Object> values) {
        return new DefaultCustomCondition(conditionType, columns, values);
    }

    public static interface Combination
    extends Condition {
        public Collection<Condition> conditions();

        public Conjunction conjunction();
    }

    public static interface All
    extends Condition {
    }
}

