/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.common.db.connection.DatabaseConnection;
import is.codion.common.db.database.Database;
import is.codion.framework.domain.entity.AbstractQueriedKeyGenerator;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import java.sql.SQLException;
import java.util.Objects;

final class QueryKeyGenerator
extends AbstractQueriedKeyGenerator {
    private final String query;

    QueryKeyGenerator(String query) {
        this.query = Objects.requireNonNull(query, "query");
    }

    @Override
    public void beforeInsert(Entity entity, DatabaseConnection connection) throws SQLException {
        ColumnDefinition<?> columnDefinition = entity.definition().primaryKey().columnDefinitions().get(0);
        if (entity.isNull(columnDefinition.attribute())) {
            this.selectAndPopulate(entity, columnDefinition, connection);
        }
    }

    @Override
    protected String query(Database database) {
        return this.query;
    }
}

