/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.common.db.connection.DatabaseConnection;
import is.codion.common.db.database.Database;
import is.codion.common.logging.MethodLogger;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.KeyGenerator;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

abstract class AbstractQueriedKeyGenerator
implements KeyGenerator {
    AbstractQueriedKeyGenerator() {
    }

    protected final <T> void selectAndPopulate(Entity entity, ColumnDefinition<T> primaryKeyColumn, DatabaseConnection databaseConnection) throws SQLException {
        MethodLogger methodLogger = databaseConnection.getMethodLogger();
        Connection connection = databaseConnection.getConnection();
        if (connection == null) {
            throw new IllegalStateException("No connection available when querying for key value");
        }
        String query = this.query(databaseConnection.database());
        if (query == null) {
            throw new IllegalStateException("Queried key generator returned no query");
        }
        SQLException exception = null;
        AbstractQueriedKeyGenerator.logEntry(methodLogger, query);
        try (PreparedStatement statement = connection.prepareStatement(query);
             ResultSet resultSet = statement.executeQuery();){
            if (!resultSet.next()) {
                throw new SQLException("No rows returned when querying for a key value", "02000");
            }
            entity.put(primaryKeyColumn.attribute(), primaryKeyColumn.get(resultSet, 1));
        }
        catch (SQLException e) {
            exception = e;
            throw e;
        }
        finally {
            AbstractQueriedKeyGenerator.logExit(methodLogger, exception);
            databaseConnection.database().queryCounter().select();
        }
    }

    protected abstract String query(Database var1);

    private static void logEntry(MethodLogger methodLogger, Object argument) {
        if (methodLogger != null && methodLogger.isEnabled()) {
            methodLogger.enter("selectAndPopulate", argument);
        }
    }

    private static void logExit(MethodLogger methodLogger, Throwable exception) {
        if (methodLogger != null && methodLogger.isEnabled()) {
            methodLogger.exit("selectAndPopulate", exception);
        }
    }
}

