/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.condition;

import is.codion.common.Operator;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.AbstractColumnCondition;
import java.util.Collections;
import java.util.Objects;

final class SingleValueColumnCondition<T>
extends AbstractColumnCondition<T> {
    private static final long serialVersionUID = 1L;
    private final T value;
    private final boolean useLikeOperator;

    SingleValueColumnCondition(Column<T> column, T value, Operator operator) {
        this(column, value, operator, true, false);
    }

    SingleValueColumnCondition(Column<T> column, T value, Operator operator, boolean caseSensitive, boolean useLikeOperator) {
        super(column, operator, value == null ? Collections.emptyList() : Collections.singletonList(value), caseSensitive);
        this.validateOperator(operator);
        this.value = value;
        this.useLikeOperator = useLikeOperator;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SingleValueColumnCondition)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SingleValueColumnCondition that = (SingleValueColumnCondition)object;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    protected String toString(String columnExpression) {
        switch (this.operator()) {
            case EQUAL: 
            case NOT_EQUAL: {
                return this.toStringEqual(columnExpression);
            }
            case LESS_THAN: {
                return columnExpression + " < ?";
            }
            case LESS_THAN_OR_EQUAL: {
                return columnExpression + " <= ?";
            }
            case GREATER_THAN: {
                return columnExpression + " > ?";
            }
            case GREATER_THAN_OR_EQUAL: {
                return columnExpression + " >= ?";
            }
        }
        throw new IllegalStateException("Unsupported single value operator: " + this.operator());
    }

    private String toStringEqual(String columnExpression) {
        String valuePlaceholder;
        boolean caseInsensitiveString;
        boolean notEqual = this.operator() == Operator.NOT_EQUAL;
        Object identifier = columnExpression;
        if (this.value == null) {
            return (String)identifier + (notEqual ? " IS NOT NULL" : " IS NULL");
        }
        boolean isString = this.column().type().isString();
        boolean bl = caseInsensitiveString = isString && !this.caseSensitive();
        if (caseInsensitiveString) {
            identifier = "UPPER(" + (String)identifier + ")";
        }
        String string = valuePlaceholder = caseInsensitiveString ? "UPPER(?)" : "?";
        if (isString && this.useLikeOperator) {
            return (String)identifier + (notEqual ? " NOT LIKE " : " LIKE ") + valuePlaceholder;
        }
        return (String)identifier + (notEqual ? " <> " : " = ") + valuePlaceholder;
    }

    @Override
    protected void validateOperator(Operator operator) {
        switch (operator) {
            case EQUAL: 
            case NOT_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported single value operator: " + operator);
            }
        }
    }
}

