/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.condition;

import is.codion.common.Operator;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.AbstractColumnCondition;
import java.util.Collection;
import java.util.Objects;

final class MultiValueColumnCondition<T>
extends AbstractColumnCondition<T> {
    private static final long serialVersionUID = 1L;
    private static final int IN_CLAUSE_LIMIT = 100;
    private static final String IN_PREFIX = " IN (";
    private static final String NOT_IN_PREFIX = " NOT IN (";

    MultiValueColumnCondition(Column<T> column, Collection<? extends T> values, Operator operator) {
        this(column, values, operator, true);
    }

    MultiValueColumnCondition(Column<T> column, Collection<? extends T> values, Operator operator, boolean caseSensitive) {
        super(column, operator, values, caseSensitive);
        for (T value : values) {
            Objects.requireNonNull(value, "Condition values may not be null");
        }
        this.validateOperator(operator);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiValueColumnCondition)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected String toString(String columnExpression) {
        boolean caseInsensitiveString;
        boolean notEqual = this.operator() == Operator.NOT_EQUAL;
        Object identifier = columnExpression;
        boolean bl = caseInsensitiveString = this.column().type().isString() && !this.caseSensitive();
        if (caseInsensitiveString) {
            identifier = "upper(" + (String)identifier + ")";
        }
        String valuePlaceholder = caseInsensitiveString ? "upper(?)" : "?";
        return MultiValueColumnCondition.createInList((String)identifier, valuePlaceholder, this.values().size(), notEqual);
    }

    private static String createInList(String columnIdentifier, String valuePlaceholder, int valueCount, boolean negated) {
        boolean exceedsLimit = valueCount > 100;
        StringBuilder stringBuilder = new StringBuilder(exceedsLimit ? "(" : "").append(columnIdentifier).append(negated ? NOT_IN_PREFIX : IN_PREFIX);
        int cnt = 1;
        for (int i = 0; i < valueCount; ++i) {
            stringBuilder.append(valuePlaceholder);
            if (cnt++ == 100 && i < valueCount - 1) {
                stringBuilder.append(negated ? ") and " : ") or ").append(columnIdentifier).append(negated ? NOT_IN_PREFIX : IN_PREFIX);
                cnt = 1;
                continue;
            }
            if (i >= valueCount - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")").append(exceedsLimit ? ")" : "");
        return stringBuilder.toString();
    }

    @Override
    protected void validateOperator(Operator operator) {
        switch (operator) {
            case EQUAL: 
            case NOT_EQUAL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported multi value operator: " + operator);
            }
        }
    }
}

