/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.attribute;

import is.codion.common.NullOrEmpty;
import is.codion.framework.domain.entity.attribute.AbstractAttributeDefinition;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class DefaultColumnDefinition<T>
extends AbstractAttributeDefinition<T>
implements ColumnDefinition<T> {
    private static final long serialVersionUID = 1L;
    private static final Column.Converter<Object, Object> DEFAULT_CONVERTER = new DefaultConverter();
    private static final Map<Class<?>, Integer> TYPE_MAP = DefaultColumnDefinition.createTypeMap();
    private static final Map<Integer, Column.Fetcher<?>> FETCHERS = DefaultColumnDefinition.createFetchers();
    private final int type;
    private final int primaryKeyIndex;
    private final boolean columnHasDefaultValue;
    private final boolean insertable;
    private final boolean updatable;
    private final boolean searchColumn;
    private final transient String name;
    private final transient String expression;
    private final transient Column.Fetcher<Object> fetcher;
    private final transient Column.Converter<T, Object> converter;
    private final transient boolean groupBy;
    private final transient boolean aggregate;
    private final transient boolean selectable;

    protected DefaultColumnDefinition(DefaultColumnDefinitionBuilder<T, ?> builder) {
        super(builder);
        this.type = builder.type;
        this.primaryKeyIndex = builder.primaryKeyIndex;
        this.columnHasDefaultValue = builder.columnHasDefaultValue;
        this.insertable = builder.insertable;
        this.updatable = builder.updatable;
        this.searchColumn = builder.searchColumn;
        this.name = builder.name;
        this.expression = builder.expression == null ? builder.name : builder.expression;
        this.fetcher = builder.fetcher;
        this.converter = builder.converter;
        this.groupBy = builder.groupBy;
        this.aggregate = builder.aggregate;
        this.selectable = builder.selectable;
    }

    @Override
    public final Column<T> attribute() {
        return (Column)super.attribute();
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final String expression() {
        return this.expression;
    }

    @Override
    public final int type() {
        return this.type;
    }

    @Override
    public final <C> Column.Converter<C, T> converter() {
        return this.converter;
    }

    @Override
    public final boolean columnHasDefaultValue() {
        return this.columnHasDefaultValue;
    }

    @Override
    public final boolean insertable() {
        return this.insertable;
    }

    @Override
    public final boolean updatable() {
        return this.updatable;
    }

    @Override
    public final boolean readOnly() {
        return !this.insertable && !this.updatable;
    }

    @Override
    public final int primaryKeyIndex() {
        return this.primaryKeyIndex;
    }

    @Override
    public final boolean groupBy() {
        return this.groupBy;
    }

    @Override
    public final boolean aggregate() {
        return this.aggregate;
    }

    @Override
    public final boolean selectable() {
        return this.selectable;
    }

    @Override
    public final boolean primaryKey() {
        return this.primaryKeyIndex >= 0;
    }

    @Override
    public final boolean searchColumn() {
        return this.searchColumn;
    }

    @Override
    public final T get(ResultSet resultSet, int index) throws SQLException {
        return this.converter.fromColumnValue(this.fetcher.get(resultSet, index));
    }

    private static Map<Class<?>, Integer> createTypeMap() {
        HashMap typeMap = new HashMap();
        typeMap.put(Long.class, -5);
        typeMap.put(Integer.class, 4);
        typeMap.put(Short.class, 5);
        typeMap.put(Double.class, 8);
        typeMap.put(BigDecimal.class, 3);
        typeMap.put(LocalDate.class, 91);
        typeMap.put(LocalTime.class, 92);
        typeMap.put(LocalDateTime.class, 93);
        typeMap.put(OffsetTime.class, 2013);
        typeMap.put(OffsetDateTime.class, 2014);
        typeMap.put(java.util.Date.class, 91);
        typeMap.put(Date.class, 91);
        typeMap.put(Time.class, 92);
        typeMap.put(Timestamp.class, 93);
        typeMap.put(String.class, 12);
        typeMap.put(Character.class, 1);
        typeMap.put(Boolean.class, 16);
        typeMap.put(byte[].class, 2004);
        return typeMap;
    }

    private static Map<Integer, Column.Fetcher<?>> createFetchers() {
        HashMap fetchers = new HashMap();
        fetchers.put(5, new ShortFetcher());
        fetchers.put(4, new IntegerFetcher());
        fetchers.put(-5, new LongFetcher());
        fetchers.put(8, new DoubleFetcher());
        fetchers.put(3, new BigDecimalFetcher());
        fetchers.put(91, new LocalDateFetcher());
        fetchers.put(93, new LocalDateTimeFetcher());
        fetchers.put(92, new LocalTimeFetcher());
        fetchers.put(2014, new OffsetDateTimeFetcher());
        fetchers.put(2013, new OffsetTimeFetcher());
        fetchers.put(12, new StringFetcher());
        fetchers.put(16, new BooleanFetcher());
        fetchers.put(1, new CharacterFetcher());
        fetchers.put(2004, new ByteArrayFetcher());
        return fetchers;
    }

    static class DefaultColumnDefinitionBuilder<T, B extends ColumnDefinition.Builder<T, B>>
    extends AbstractAttributeDefinition.AbstractAttributeDefinitionBuilder<T, B>
    implements ColumnDefinition.Builder<T, B> {
        private final int primaryKeyIndex;
        private int type;
        private boolean columnHasDefaultValue;
        private boolean insertable;
        private boolean updatable;
        private boolean searchColumn;
        private String name;
        private String expression;
        private Column.Fetcher<Object> fetcher;
        private Column.Converter<T, Object> converter;
        private boolean groupBy;
        private boolean aggregate;
        private boolean selectable;

        DefaultColumnDefinitionBuilder(Column<T> column) {
            this(column, -1);
        }

        DefaultColumnDefinitionBuilder(Column<T> column, int primaryKeyIndex) {
            super(column);
            this.primaryKeyIndex = primaryKeyIndex;
            this.type = DefaultColumnDefinitionBuilder.sqlType(column.type().valueClass());
            this.columnHasDefaultValue = false;
            this.insertable = true;
            this.nullable(primaryKeyIndex < 0);
            this.updatable = primaryKeyIndex < 0;
            this.searchColumn = false;
            this.name = column.name();
            this.fetcher = DefaultColumnDefinitionBuilder.fetcher(this.type, column);
            this.converter = DEFAULT_CONVERTER;
            this.groupBy = false;
            this.aggregate = false;
            this.selectable = true;
        }

        @Override
        public AttributeDefinition<T> build() {
            return new DefaultColumnDefinition(this);
        }

        @Override
        public final B nullable(boolean nullable) {
            return (B)((ColumnDefinition.Builder)super.nullable(nullable));
        }

        @Override
        public final <C> B columnClass(Class<C> columnClass, Column.Converter<T, C> converter) {
            this.type = DefaultColumnDefinitionBuilder.sqlType(columnClass);
            this.converter = Objects.requireNonNull(converter, "valueConverter");
            this.fetcher = DefaultColumnDefinitionBuilder.fetcher(this.type, (Column)this.attribute);
            return (B)this;
        }

        @Override
        public final <C> B columnClass(Class<C> columnClass, Column.Converter<T, C> converter, Column.Fetcher<C> fetcher) {
            this.type = DefaultColumnDefinitionBuilder.sqlType(columnClass);
            this.converter = Objects.requireNonNull(converter, "valueConverter");
            this.fetcher = Objects.requireNonNull(fetcher, "valueFetcher");
            return (B)this;
        }

        @Override
        public final B name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return (B)this;
        }

        @Override
        public B expression(String expression) {
            this.expression = Objects.requireNonNull(expression, "expression");
            return (B)this;
        }

        @Override
        public final B columnHasDefaultValue(boolean columnHasDefaultValue) {
            this.columnHasDefaultValue = columnHasDefaultValue;
            return (B)this;
        }

        @Override
        public B readOnly(boolean readOnly) {
            this.insertable = !readOnly;
            this.updatable = !readOnly;
            return (B)this;
        }

        @Override
        public B insertable(boolean insertable) {
            this.insertable = insertable;
            return (B)this;
        }

        @Override
        public B updatable(boolean updatable) {
            this.updatable = updatable;
            return (B)this;
        }

        @Override
        public final B groupBy(boolean groupBy) {
            this.groupBy = groupBy;
            this.aggregate = !groupBy;
            return (B)this;
        }

        @Override
        public final B aggregate(boolean aggregate) {
            this.aggregate = aggregate;
            this.groupBy = !aggregate;
            return (B)this;
        }

        @Override
        public final B selectable(boolean selectable) {
            this.selectable = selectable;
            return (B)this;
        }

        @Override
        public final B searchColumn(boolean searchColumn) {
            if (searchColumn && !this.attribute.type().isString()) {
                throw new IllegalStateException("Search columns must be String based: " + this.attribute);
            }
            this.searchColumn = searchColumn;
            return (B)this;
        }

        private static int sqlType(Class<?> clazz) {
            return TYPE_MAP.getOrDefault(Objects.requireNonNull(clazz, "clazz"), 1111);
        }

        private static <T> Column.Fetcher<T> fetcher(int columnType, Column<T> column) {
            if (columnType == 1111) {
                return new ObjectFetcher(column.type().valueClass());
            }
            if (!FETCHERS.containsKey(columnType)) {
                throw new IllegalArgumentException("Unsupported SQL value type: " + columnType + ", column: " + column + ", valueClass: " + column.type().valueClass());
            }
            return FETCHERS.get(columnType);
        }
    }

    private static final class ShortFetcher
    implements Column.Fetcher<Short> {
        private ShortFetcher() {
        }

        @Override
        public Short get(ResultSet resultSet, int index) throws SQLException {
            short value = resultSet.getShort(index);
            return value == 0 && resultSet.wasNull() ? null : Short.valueOf(value);
        }
    }

    private static final class IntegerFetcher
    implements Column.Fetcher<Integer> {
        private IntegerFetcher() {
        }

        @Override
        public Integer get(ResultSet resultSet, int index) throws SQLException {
            int value = resultSet.getInt(index);
            return value == 0 && resultSet.wasNull() ? null : Integer.valueOf(value);
        }
    }

    private static final class LongFetcher
    implements Column.Fetcher<Long> {
        private LongFetcher() {
        }

        @Override
        public Long get(ResultSet resultSet, int index) throws SQLException {
            long value = resultSet.getLong(index);
            return value == 0L && resultSet.wasNull() ? null : Long.valueOf(value);
        }
    }

    private static final class DoubleFetcher
    implements Column.Fetcher<Double> {
        private DoubleFetcher() {
        }

        @Override
        public Double get(ResultSet resultSet, int index) throws SQLException {
            double value = resultSet.getDouble(index);
            return Double.compare(value, 0.0) == 0 && resultSet.wasNull() ? null : Double.valueOf(value);
        }
    }

    private static final class BigDecimalFetcher
    implements Column.Fetcher<BigDecimal> {
        private BigDecimalFetcher() {
        }

        @Override
        public BigDecimal get(ResultSet resultSet, int index) throws SQLException {
            return resultSet.getBigDecimal(index);
        }
    }

    private static final class LocalDateFetcher
    implements Column.Fetcher<LocalDate> {
        private LocalDateFetcher() {
        }

        @Override
        public LocalDate get(ResultSet resultSet, int index) throws SQLException {
            return resultSet.getObject(index, LocalDate.class);
        }
    }

    private static final class LocalDateTimeFetcher
    implements Column.Fetcher<LocalDateTime> {
        private LocalDateTimeFetcher() {
        }

        @Override
        public LocalDateTime get(ResultSet resultSet, int index) throws SQLException {
            return resultSet.getObject(index, LocalDateTime.class);
        }
    }

    private static final class LocalTimeFetcher
    implements Column.Fetcher<LocalTime> {
        private LocalTimeFetcher() {
        }

        @Override
        public LocalTime get(ResultSet resultSet, int index) throws SQLException {
            return resultSet.getObject(index, LocalTime.class);
        }
    }

    private static final class OffsetDateTimeFetcher
    implements Column.Fetcher<OffsetDateTime> {
        private OffsetDateTimeFetcher() {
        }

        @Override
        public OffsetDateTime get(ResultSet resultSet, int index) throws SQLException {
            return resultSet.getObject(index, OffsetDateTime.class);
        }
    }

    private static final class OffsetTimeFetcher
    implements Column.Fetcher<OffsetTime> {
        private OffsetTimeFetcher() {
        }

        @Override
        public OffsetTime get(ResultSet resultSet, int index) throws SQLException {
            return resultSet.getObject(index, OffsetTime.class);
        }
    }

    private static final class StringFetcher
    implements Column.Fetcher<String> {
        private StringFetcher() {
        }

        @Override
        public String get(ResultSet resultSet, int index) throws SQLException {
            return resultSet.getString(index);
        }
    }

    private static final class BooleanFetcher
    implements Column.Fetcher<Boolean> {
        private BooleanFetcher() {
        }

        @Override
        public Boolean get(ResultSet resultSet, int index) throws SQLException {
            boolean value = resultSet.getBoolean(index);
            return !value && resultSet.wasNull() ? null : Boolean.valueOf(value);
        }
    }

    private static final class CharacterFetcher
    implements Column.Fetcher<Character> {
        private CharacterFetcher() {
        }

        @Override
        public Character get(ResultSet resultSet, int index) throws SQLException {
            String string = resultSet.getString(index);
            if (NullOrEmpty.nullOrEmpty((String)string)) {
                return null;
            }
            return Character.valueOf(string.charAt(0));
        }
    }

    private static final class ByteArrayFetcher
    implements Column.Fetcher<byte[]> {
        private ByteArrayFetcher() {
        }

        @Override
        public byte[] get(ResultSet resultSet, int index) throws SQLException {
            return resultSet.getBytes(index);
        }
    }

    private static final class DefaultConverter
    implements Column.Converter<Object, Object> {
        private DefaultConverter() {
        }

        @Override
        public Object toColumnValue(Object value, Statement statement) {
            return value;
        }

        @Override
        public Object fromColumnValue(Object columnValue) {
            return columnValue;
        }
    }

    private static final class ObjectFetcher
    implements Column.Fetcher<Object> {
        private final Class<?> valueClass;

        private ObjectFetcher(Class<?> valueClass) {
            this.valueClass = valueClass;
        }

        @Override
        public Object get(ResultSet resultSet, int index) throws SQLException {
            return resultSet.getObject(index, this.valueClass);
        }
    }

    static final class DefaultSubqueryColumnDefinitionBuilder<T, B extends ColumnDefinition.Builder<T, B>>
    extends AbstractReadOnlyColumnDefinitionBuilder<T, B>
    implements AttributeDefinition.Builder<T, B> {
        DefaultSubqueryColumnDefinitionBuilder(Column<T> column, String subquery) {
            super(column);
            super.expression("(" + subquery + ")");
        }

        @Override
        public B expression(String expression) {
            throw new UnsupportedOperationException("Column expression can not be set on a subquery column: " + this.attribute);
        }
    }

    static abstract class AbstractReadOnlyColumnDefinitionBuilder<T, B extends ColumnDefinition.Builder<T, B>>
    extends DefaultColumnDefinitionBuilder<T, B>
    implements AttributeDefinition.Builder<T, B> {
        protected AbstractReadOnlyColumnDefinitionBuilder(Column<T> column) {
            super(column);
            super.readOnly(true);
        }

        @Override
        public final B readOnly(boolean readOnly) {
            throw new UnsupportedOperationException("Read only by default: " + this.attribute);
        }

        @Override
        public final B insertable(boolean insertable) {
            throw new UnsupportedOperationException("Column is not insertable: " + this.attribute);
        }

        @Override
        public final B updatable(boolean updatable) {
            throw new UnsupportedOperationException("Column is not updatable: " + this.attribute);
        }
    }
}

