/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

final class DefaultEntityBuilder
implements Entity.Builder {
    private final EntityDefinition definition;
    private final Map<Attribute<?>, Object> values;
    private final Map<Attribute<?>, Object> originalValues;
    private final Map<Attribute<?>, Object> builderValues = new LinkedHashMap();

    DefaultEntityBuilder(Entity.Key key) {
        this(Objects.requireNonNull(key).entityDefinition());
        key.columns().forEach(attribute -> this.with((Attribute)attribute, key.get(attribute)));
    }

    DefaultEntityBuilder(EntityDefinition definition) {
        this(definition, null, null);
    }

    DefaultEntityBuilder(EntityDefinition definition, Map<Attribute<?>, Object> values, Map<Attribute<?>, Object> originalValues) {
        this.definition = definition;
        this.values = values;
        this.originalValues = originalValues;
    }

    @Override
    public <T> Entity.Builder with(Attribute<T> attribute, T value) {
        AttributeDefinition<T> attributeDefinition = this.definition.attributes().definition(attribute);
        if (attributeDefinition.derived()) {
            throw new IllegalArgumentException("Can not set the value of a derived attribute");
        }
        this.builderValues.put(attribute, value);
        return this;
    }

    @Override
    public Entity.Builder withDefaultValues() {
        this.definition.attributes().definitions().stream().filter(AttributeDefinition::hasDefaultValue).forEach(attributeDefinition -> this.builderValues.put(attributeDefinition.attribute(), attributeDefinition.defaultValue()));
        return this;
    }

    @Override
    public Entity build() {
        Entity entity = this.definition.entity(this.values, this.originalValues);
        this.builderValues.forEach((attribute, value) -> entity.put(attribute, value));
        return entity;
    }
}

