/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.rmi;

import is.codion.common.rmi.client.Clients;
import is.codion.common.rmi.client.ConnectionRequest;
import is.codion.common.rmi.server.Server;
import is.codion.common.rmi.server.ServerAdmin;
import is.codion.framework.db.AbstractEntityConnectionProvider;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.rmi.DefaultRemoteEntityConnectionProviderBuilder;
import is.codion.framework.db.rmi.RemoteEntityConnection;
import is.codion.framework.db.rmi.RemoteEntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultRemoteEntityConnectionProvider
extends AbstractEntityConnectionProvider
implements RemoteEntityConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteEntityConnectionProvider.class);
    private static final String CONNECTED = "connected";
    private static final String ENTITIES = "entities";
    private Server<RemoteEntityConnection, ServerAdmin> server;
    private String serverName;
    private boolean truststoreResolved = false;
    private final String hostName;
    private final int port;
    private final int registryPort;
    private final String namePrefix;

    DefaultRemoteEntityConnectionProvider(DefaultRemoteEntityConnectionProviderBuilder builder) {
        super((AbstractEntityConnectionProvider.AbstractBuilder)builder);
        this.hostName = Objects.requireNonNull(builder.hostName, "hostName");
        this.port = builder.port;
        this.registryPort = builder.registryPort;
        this.namePrefix = builder.namePrefix;
    }

    public String connectionType() {
        return "remote";
    }

    public String description() {
        return this.serverName + "@" + this.hostName;
    }

    @Override
    public String hostName() {
        return this.hostName;
    }

    protected EntityConnection connect() {
        if (!this.truststoreResolved) {
            Clients.resolveTrustStore();
            this.truststoreResolved = true;
        }
        try {
            LOG.debug("Initializing connection for {}", (Object)this.user());
            return (EntityConnection)Proxy.newProxyInstance(EntityConnection.class.getClassLoader(), new Class[]{EntityConnection.class}, (InvocationHandler)new RemoteEntityConnectionHandler((RemoteEntityConnection)this.server().connect(ConnectionRequest.builder().user(this.user()).clientId(this.clientId()).clientTypeId(this.clientTypeId()).clientVersion(this.clientVersion()).parameter("codion.client.domainType", (Object)this.domainType().name()).build())));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void close(EntityConnection connection) {
        try {
            this.server.disconnect(this.clientId());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private Server<RemoteEntityConnection, ServerAdmin> server() throws RemoteException, NotBoundException {
        boolean unreachable = false;
        try {
            if (this.server != null) {
                this.server.serverLoad();
            }
        }
        catch (RemoteException e) {
            LOG.info("{} was unreachable, {} - {} reconnecting...", new Object[]{this.serverName, this.user(), this.clientId()});
            unreachable = true;
        }
        if (this.server == null || unreachable) {
            this.connectToServer();
            LOG.info("ClientID: {}, {} connected to server: {}", new Object[]{this.user(), this.clientId(), this.serverName});
        }
        return this.server;
    }

    private void connectToServer() throws RemoteException, NotBoundException {
        this.server = Server.Locator.builder().hostName(this.hostName).namePrefix(this.namePrefix).registryPort(this.registryPort).port(this.port).build().locateServer();
        this.serverName = this.server.serverInformation().serverName();
    }

    private static final class RemoteEntityConnectionHandler
    implements InvocationHandler {
        private final Map<Method, Method> methodCache = new HashMap<Method, Method>();
        private final RemoteEntityConnection remoteConnection;
        private Entities entities;

        private RemoteEntityConnectionHandler(RemoteEntityConnection remoteConnection) {
            this.remoteConnection = remoteConnection;
        }

        @Override
        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            String methodName = method.getName();
            if (methodName.equals(DefaultRemoteEntityConnectionProvider.CONNECTED)) {
                return this.connected();
            }
            if (methodName.equals(DefaultRemoteEntityConnectionProvider.ENTITIES)) {
                return this.entities();
            }
            Method remoteMethod = this.methodCache.computeIfAbsent(method, RemoteEntityConnectionHandler::remoteMethod);
            try {
                return remoteMethod.invoke((Object)this.remoteConnection, args);
            }
            catch (InvocationTargetException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }

        private Object connected() throws RemoteException {
            try {
                return this.remoteConnection.connected();
            }
            catch (ConnectException | NoSuchObjectException e) {
                return false;
            }
        }

        private Entities entities() throws RemoteException {
            if (this.entities == null) {
                this.entities = this.remoteConnection.entities();
            }
            return this.entities;
        }

        private static Method remoteMethod(Method method) {
            try {
                return RemoteEntityConnection.class.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

