/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.local;

import is.codion.common.Text;
import is.codion.common.db.database.Database;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.domain.entity.query.SelectQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

final class SelectQueries {
    private final Database database;
    private final Map<EntityType, List<ColumnDefinition<?>>> defaultSelectColumnsCache = new ConcurrentHashMap();
    private final Map<EntityType, String> defaultColumnsClauseCache = new ConcurrentHashMap<EntityType, String>();
    private final Map<EntityType, String> groupByClauseCache = new ConcurrentHashMap<EntityType, String>();

    SelectQueries(Database database) {
        this.database = database;
    }

    Builder builder(EntityDefinition definition) {
        return new Builder(definition);
    }

    final class Builder {
        private static final String SELECT = "SELECT ";
        private static final String FROM = "FROM ";
        private static final String WHERE = "WHERE ";
        private static final String AND = "AND ";
        private static final String GROUP_BY = "GROUP BY ";
        private static final String HAVING = "HAVING ";
        private static final String ORDER_BY = "ORDER BY ";
        private static final String NEWLINE = "\n";
        private static final String NULL_FIRST = " NULLS FIRST";
        private static final String NULL_LAST = " NULLS LAST";
        private final EntityDefinition definition;
        private final List<String> where = new ArrayList<String>(1);
        private List<ColumnDefinition<?>> selectedColums = Collections.emptyList();
        private String columns;
        private String from;
        private String orderBy;
        private boolean forUpdate;
        private String groupBy;
        private String having;
        private Integer limit;
        private Integer offset;
        private boolean columnsClauseFromSelectQuery = false;

        private Builder(EntityDefinition definition) {
            this.definition = definition;
        }

        List<ColumnDefinition<?>> selectedColumns() {
            return this.selectedColums;
        }

        Builder select(EntityConnection.Select select) {
            return this.select(select, true);
        }

        Builder select(EntityConnection.Select select, boolean useWhereClause) {
            this.entitySelectQuery();
            if (!this.columnsClauseFromSelectQuery) {
                this.setColumns(select);
            }
            if (useWhereClause) {
                this.where(select.where());
            }
            if (this.groupBy == null) {
                this.groupBy(this.groupByClause());
            }
            this.havingCondition(select.having());
            select.orderBy().ifPresent(this::setOrderBy);
            this.forUpdate(select.forUpdate());
            select.limit().ifPresent(this::limit);
            select.offset().ifPresent(this::offset);
            return this;
        }

        Builder entitySelectQuery() {
            this.definition.selectQuery().ifPresent(this::fromSelectQuery);
            return this;
        }

        Builder columns(String columns) {
            this.columns = columns;
            return this;
        }

        Builder subquery(String subquery) {
            return this.from("(" + subquery + ")" + (SelectQueries.this.database.subqueryRequiresAlias() ? " AS row_count" : ""));
        }

        Builder from(String from) {
            this.from = from;
            return this;
        }

        Builder where(Condition condition) {
            String conditionString = condition.toString(this.definition);
            if (!conditionString.isEmpty()) {
                this.where(conditionString);
            }
            return this;
        }

        Builder where(String where) {
            if (!Text.nullOrEmpty((String)where)) {
                this.where.add(where);
            }
            return this;
        }

        Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        Builder forUpdate(boolean forUpdate) {
            this.forUpdate = forUpdate;
            return this;
        }

        Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        Builder having(String having) {
            this.having = having;
            return this;
        }

        Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        String build() {
            String forUpdateClause;
            String limitOffsetClause;
            StringBuilder builder = new StringBuilder().append(SELECT).append(this.columns).append(NEWLINE).append(FROM).append(this.from());
            if (!this.where.isEmpty()) {
                builder.append(NEWLINE).append(WHERE).append(this.where.get(0));
                if (this.where.size() > 1) {
                    for (int i = 1; i < this.where.size(); ++i) {
                        builder.append(NEWLINE).append(AND).append(this.where.get(i));
                    }
                }
            }
            if (this.groupBy != null && !this.groupBy.isEmpty()) {
                builder.append(NEWLINE).append(GROUP_BY).append(this.groupBy);
            }
            if (this.having != null) {
                builder.append(NEWLINE).append(HAVING).append(this.having);
            }
            if (this.orderBy != null) {
                builder.append(NEWLINE).append(ORDER_BY).append(this.orderBy);
            }
            if (!(limitOffsetClause = SelectQueries.this.database.limitOffsetClause(this.limit, this.offset)).isEmpty()) {
                builder.append(NEWLINE).append(limitOffsetClause);
            }
            if (this.forUpdate && !Text.nullOrEmpty((String)(forUpdateClause = SelectQueries.this.database.selectForUpdateClause()))) {
                builder.append(NEWLINE).append(forUpdateClause);
            }
            return builder.toString();
        }

        private void setColumns(EntityConnection.Select select) {
            Collection attributes = select.attributes();
            if (attributes.isEmpty()) {
                this.selectedColums = this.defaultSelectColumns();
                this.columns(this.defaultColumnsClause());
            } else {
                this.selectedColums = this.columnsToSelect(attributes);
                this.columns(this.columnsClause(this.selectedColums));
            }
        }

        private void fromSelectQuery(SelectQuery selectQuery) {
            if (selectQuery.columns() != null) {
                this.columns(selectQuery.columns());
                this.selectedColums = this.defaultSelectColumns();
                this.columnsClauseFromSelectQuery = true;
            } else {
                this.columns(this.defaultColumnsClause());
            }
            this.from(selectQuery.from());
            this.where(selectQuery.where());
            this.orderBy(selectQuery.orderBy());
            this.groupBy(selectQuery.groupBy());
            this.having(selectQuery.having());
        }

        private String from() {
            if (this.from == null) {
                return this.forUpdate ? this.definition.tableName() : this.definition.selectTableName();
            }
            return this.from;
        }

        private List<ColumnDefinition<?>> columnsToSelect(Collection<Attribute<?>> selectAttributes) {
            HashSet columnsToSelect = new HashSet(this.definition.primaryKey().definitions());
            selectAttributes.forEach(attribute -> {
                if (attribute instanceof ForeignKey) {
                    ((ForeignKey)attribute).references().forEach(reference -> columnsToSelect.add(this.definition.columns().definition(reference.column())));
                } else if (attribute instanceof Column) {
                    columnsToSelect.add(this.definition.columns().definition((Column)attribute));
                }
            });
            return new ArrayList(columnsToSelect);
        }

        private List<ColumnDefinition<?>> defaultSelectColumns() {
            return SelectQueries.this.defaultSelectColumnsCache.computeIfAbsent(this.definition.entityType(), entityType -> this.definition.columns().definitions().stream().filter(ColumnDefinition::selectable).filter(columnDefinition -> !columnDefinition.lazy()).collect(Collectors.toList()));
        }

        private String defaultColumnsClause() {
            return SelectQueries.this.defaultColumnsClauseCache.computeIfAbsent(this.definition.entityType(), type -> this.columnsClause(this.defaultSelectColumns()));
        }

        private String groupByClause() {
            return SelectQueries.this.groupByClauseCache.computeIfAbsent(this.definition.entityType(), type -> this.definition.columns().definitions().stream().filter(ColumnDefinition::groupBy).map(ColumnDefinition::expression).collect(Collectors.joining(", ")));
        }

        private String columnsClause(List<ColumnDefinition<?>> columnDefinitions) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < columnDefinitions.size(); ++i) {
                ColumnDefinition<?> columnDefinition = columnDefinitions.get(i);
                String columnName = columnDefinition.name();
                String columnExpression = columnDefinition.expression();
                stringBuilder.append(columnExpression);
                if (!columnName.equals(columnExpression)) {
                    stringBuilder.append(" AS ").append(columnName);
                }
                if (i >= columnDefinitions.size() - 1) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }

        private void havingCondition(Condition condition) {
            String conditionString = condition.toString(this.definition);
            if (!conditionString.isEmpty()) {
                this.having((String)(this.having == null ? conditionString : "(" + this.having + ") AND (" + conditionString + ")"));
            }
        }

        private void setOrderBy(OrderBy orderBy) {
            this.orderBy(this.createOrderByClause(orderBy));
        }

        private String createOrderByClause(OrderBy orderBy) {
            List orderByColumns = orderBy.orderByColumns();
            if (orderByColumns.size() == 1) {
                return this.columnOrderByClause(this.definition, (OrderBy.OrderByColumn)orderByColumns.get(0));
            }
            return orderByColumns.stream().map(orderByColumn -> this.columnOrderByClause(this.definition, (OrderBy.OrderByColumn)orderByColumn)).collect(Collectors.joining(", "));
        }

        private String columnOrderByClause(EntityDefinition entityDefinition, OrderBy.OrderByColumn orderByColumn) {
            String columnExpression = entityDefinition.columns().definition(orderByColumn.column()).expression();
            return orderByColumn.ignoreCase() ? "UPPER(" + columnExpression + ")" : columnExpression + (orderByColumn.ascending() ? "" : " DESC") + this.nullOrderString(orderByColumn.nullOrder());
        }

        private String nullOrderString(OrderBy.NullOrder nullOrder) {
            switch (nullOrder) {
                case NULLS_FIRST: {
                    return NULL_FIRST;
                }
                case NULLS_LAST: {
                    return NULL_LAST;
                }
            }
            return "";
        }
    }
}

