/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.local;

import is.codion.common.db.result.ResultIterator;
import is.codion.common.db.result.ResultPacker;
import is.codion.framework.domain.entity.Entity;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;

final class EntityResultIterator
implements ResultIterator<Entity> {
    private final Statement statement;
    private final ResultSet resultSet;
    private final ResultPacker<Entity> resultPacker;
    private boolean hasNext;
    private boolean hasNextCalled;

    EntityResultIterator(Statement statement, ResultSet resultSet, ResultPacker<Entity> resultPacker) {
        this.statement = statement;
        this.resultSet = resultSet;
        this.resultPacker = resultPacker;
    }

    public boolean hasNext() throws SQLException {
        if (this.hasNextCalled) {
            return this.hasNext;
        }
        this.hasNext = this.resultSet.next();
        this.hasNextCalled = true;
        return this.hasNext;
    }

    public Entity next() throws SQLException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNextCalled = false;
        return (Entity)this.resultPacker.get(this.resultSet);
    }

    public void close() {
        EntityResultIterator.closeSilently(this.resultSet);
        EntityResultIterator.closeSilently(this.statement);
    }

    private static void closeSilently(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

