/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.local;

import is.codion.common.Configuration;
import is.codion.common.db.connection.DatabaseConnection;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.result.ResultIterator;
import is.codion.common.property.PropertyValue;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.local.DefaultLocalEntityConnection;
import is.codion.framework.domain.Domain;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.condition.Condition;
import java.sql.Connection;

public interface LocalEntityConnection
extends EntityConnection {
    public static final int DEFAULT_CONNECTION_LOG_SIZE = 40;
    public static final PropertyValue<Integer> CONNECTION_LOG_SIZE = Configuration.integerValue((String)"codion.db.connectionLogSize", (int)40);
    public static final PropertyValue<Integer> QUERY_TIMEOUT_SECONDS = Configuration.integerValue((String)"codion.db.queryTimeoutSeconds", (int)120);
    public static final PropertyValue<Boolean> OPTIMISTIC_LOCKING = Configuration.booleanValue((String)"codion.db.optimisticLocking", (boolean)true);
    public static final PropertyValue<Boolean> LIMIT_FOREIGN_KEY_FETCH_DEPTH = Configuration.booleanValue((String)"codion.db.limitForeignKeyFetchDepth", (boolean)true);

    public DatabaseConnection databaseConnection();

    public ResultIterator<Entity> iterator(Condition var1) throws DatabaseException;

    public ResultIterator<Entity> iterator(EntityConnection.Select var1) throws DatabaseException;

    public boolean isOptimisticLocking();

    public void setOptimisticLocking(boolean var1);

    public boolean isLimitForeignKeyFetchDepth();

    public void setLimitForeignKeyFetchDepth(boolean var1);

    public int getDefaultQueryTimeout();

    public void setDefaultQueryTimeout(int var1);

    public static LocalEntityConnection localEntityConnection(Database database, Domain domain, User user) throws DatabaseException {
        return new DefaultLocalEntityConnection(database, domain, user);
    }

    public static LocalEntityConnection localEntityConnection(Database database, Domain domain, Connection connection) throws DatabaseException {
        return new DefaultLocalEntityConnection(database, domain, connection);
    }

    public static Database configureDatabase(Database database, Domain domain) throws DatabaseException {
        return DefaultLocalEntityConnection.configureDatabase(database, domain);
    }
}

