/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.local;

import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import java.util.List;

final class Queries {
    private static final String WHERE_SPACE_POSTFIX = "WHERE ";
    private static final String NEWLINE = "\n";

    private Queries() {
    }

    static String insertQuery(String tableName, List<ColumnDefinition<?>> columnDefinitions) {
        StringBuilder queryBuilder = new StringBuilder("INSERT ").append("INTO ").append(tableName).append("(");
        StringBuilder columnValues = new StringBuilder(")").append(NEWLINE).append("VALUES(");
        for (int i = 0; i < columnDefinitions.size(); ++i) {
            queryBuilder.append(columnDefinitions.get(i).name());
            columnValues.append("?");
            if (i >= columnDefinitions.size() - 1) continue;
            queryBuilder.append(", ");
            columnValues.append(", ");
        }
        return queryBuilder.append((CharSequence)columnValues).append(")").toString();
    }

    static String updateQuery(String tableName, List<ColumnDefinition<?>> columnDefinitions, String conditionString) {
        StringBuilder queryBuilder = new StringBuilder("UPDATE ").append(tableName).append(NEWLINE).append("SET ");
        for (int i = 0; i < columnDefinitions.size(); ++i) {
            queryBuilder.append(columnDefinitions.get(i).name()).append(" = ?");
            if (i >= columnDefinitions.size() - 1) continue;
            queryBuilder.append(", ");
        }
        return queryBuilder.append(NEWLINE).append(WHERE_SPACE_POSTFIX).append(conditionString).toString();
    }

    static String deleteQuery(String tableName, String conditionString) {
        return "DELETE FROM " + tableName + (String)(conditionString.isEmpty() ? "" : "\nWHERE " + conditionString);
    }
}

