/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.local;

import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.framework.db.AbstractEntityConnectionProvider;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.local.DefaultLocalEntityConnectionProviderBuilder;
import is.codion.framework.db.local.LocalEntityConnection;
import is.codion.framework.db.local.LocalEntityConnectionProvider;
import is.codion.framework.domain.Domain;
import is.codion.framework.domain.DomainType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultLocalEntityConnectionProvider
extends AbstractEntityConnectionProvider
implements LocalEntityConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LocalEntityConnectionProvider.class);
    private final Domain domain;
    private final Database database;
    private final int defaultQueryTimeout;

    DefaultLocalEntityConnectionProvider(DefaultLocalEntityConnectionProviderBuilder builder) {
        super((AbstractEntityConnectionProvider.AbstractBuilder)builder);
        this.domain = builder.domain == null ? DefaultLocalEntityConnectionProvider.initializeDomain(this.domainType()) : builder.domain;
        this.database = builder.database == null ? Database.instance() : builder.database;
        this.defaultQueryTimeout = builder.defaultQueryTimeout;
    }

    public String connectionType() {
        return "local";
    }

    public String description() {
        return this.database().name().toUpperCase();
    }

    @Override
    public Domain domain() {
        return this.domain;
    }

    @Override
    public Database database() {
        return this.database;
    }

    @Override
    public int defaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    protected LocalEntityConnection connect() {
        try {
            LOG.debug("Initializing connection for {}", (Object)this.user());
            LocalEntityConnection connection = LocalEntityConnection.localEntityConnection(this.database(), this.domain(), this.user());
            connection.setDefaultQueryTimeout(this.defaultQueryTimeout);
            return connection;
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    protected void close(EntityConnection connection) {
        connection.close();
    }

    private static Domain initializeDomain(DomainType domainType) {
        return Domain.domains().stream().filter(domain -> domain.type().equals(domainType)).findAny().orElseThrow(() -> new IllegalStateException("Domain model not found in ServiceLoader: " + domainType));
    }
}

