/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.local;

import is.codion.common.db.connection.DatabaseConnection;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.exception.DeleteException;
import is.codion.common.db.exception.MultipleRecordsFoundException;
import is.codion.common.db.exception.QueryTimeoutException;
import is.codion.common.db.exception.RecordModifiedException;
import is.codion.common.db.exception.RecordNotFoundException;
import is.codion.common.db.exception.ReferentialIntegrityException;
import is.codion.common.db.exception.UniqueConstraintException;
import is.codion.common.db.exception.UpdateException;
import is.codion.common.db.operation.FunctionType;
import is.codion.common.db.operation.ProcedureType;
import is.codion.common.db.report.ReportException;
import is.codion.common.db.report.ReportType;
import is.codion.common.db.result.ResultIterator;
import is.codion.common.db.result.ResultPacker;
import is.codion.common.logging.MethodLogger;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.local.EntityResultIterator;
import is.codion.framework.db.local.EntityResultPacker;
import is.codion.framework.db.local.LocalEntityConnection;
import is.codion.framework.db.local.Queries;
import is.codion.framework.db.local.SelectQueries;
import is.codion.framework.domain.Domain;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.KeyGenerator;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.domain.entity.query.SelectQuery;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultLocalEntityConnection
implements LocalEntityConnection {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLocalEntityConnection.class);
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(LocalEntityConnection.class.getName());
    private static final String EXECUTE_UPDATE = "executeUpdate";
    private static final String EXECUTE_QUERY = "executeQuery";
    private static final String RECORD_MODIFIED = "record_modified";
    private static final String CONDITION = "condition";
    private static final String ENTITIES = "entities";
    private static final String ENTITY = "entity";
    private static final String PACK_RESULT = "packResult";
    private static final String EXECUTE = "execute";
    private static final String REPORT = "report";
    private static final Function<Entity, Entity> IMMUTABLE = Entity::immutable;
    private final Domain domain;
    private final DatabaseConnection connection;
    private final SelectQueries selectQueries;
    private final Map<EntityType, List<ColumnDefinition<?>>> insertableColumnsCache = new HashMap();
    private final Map<EntityType, List<ColumnDefinition<?>>> updatableColumnsCache = new HashMap();
    private final Map<EntityType, List<ForeignKeyDefinition>> hardForeignKeyReferenceCache = new HashMap<EntityType, List<ForeignKeyDefinition>>();
    private final Map<EntityType, List<Attribute<?>>> primaryKeyAndWritableColumnsCache = new HashMap();
    private final Map<EntityConnection.Select, List<Entity>> queryCache = new HashMap<EntityConnection.Select, List<Entity>>();
    private boolean optimisticLocking = (Boolean)LocalEntityConnection.OPTIMISTIC_LOCKING.get();
    private boolean limitForeignKeyFetchDepth = (Boolean)LocalEntityConnection.LIMIT_FOREIGN_KEY_FETCH_DEPTH.get();
    private int defaultQueryTimeout = (Integer)LocalEntityConnection.QUERY_TIMEOUT_SECONDS.get();
    private boolean queryCacheEnabled = false;

    DefaultLocalEntityConnection(Database database, Domain domain, User user) throws DatabaseException {
        this(domain, DatabaseConnection.databaseConnection((Database)DefaultLocalEntityConnection.configureDatabase(database, domain), (User)user));
    }

    DefaultLocalEntityConnection(Database database, Domain domain, Connection connection) throws DatabaseException {
        this(domain, DatabaseConnection.databaseConnection((Database)DefaultLocalEntityConnection.configureDatabase(database, domain), (Connection)connection));
    }

    private DefaultLocalEntityConnection(Domain domain, DatabaseConnection connection) throws DatabaseException {
        this.domain = domain;
        this.connection = connection;
        this.domain.configureConnection(connection);
        this.selectQueries = new SelectQueries(connection.database());
    }

    public Entities entities() {
        return this.domain.entities();
    }

    public User user() {
        return this.connection.user();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connected() {
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            return this.connection.connected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction() {
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            this.connection.beginTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transactionOpen() {
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            return this.connection.transactionOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() {
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            this.connection.rollbackTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction() {
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            this.connection.commitTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryCacheEnabled(boolean queryCacheEnabled) {
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            this.queryCacheEnabled = queryCacheEnabled;
            if (!queryCacheEnabled) {
                this.queryCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueryCacheEnabled() {
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            return this.queryCacheEnabled;
        }
    }

    public Entity.Key insert(Entity entity) throws DatabaseException {
        return this.insert(Collections.singletonList(Objects.requireNonNull(entity, ENTITY))).iterator().next();
    }

    public Entity insertSelect(Entity entity) throws DatabaseException {
        return this.insertSelect(Collections.singletonList(Objects.requireNonNull(entity, ENTITY))).iterator().next();
    }

    public Collection<Entity.Key> insert(Collection<? extends Entity> entities) throws DatabaseException {
        if (Objects.requireNonNull(entities, ENTITIES).isEmpty()) {
            return Collections.emptyList();
        }
        return this.insert(entities, null);
    }

    public Collection<Entity> insertSelect(Collection<? extends Entity> entities) throws DatabaseException {
        if (Objects.requireNonNull(entities, ENTITIES).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Entity> insertedEntities = new ArrayList<Entity>(entities.size());
        this.insert(entities, insertedEntities);
        return insertedEntities;
    }

    public void update(Entity entity) throws DatabaseException {
        this.update(Collections.singletonList(Objects.requireNonNull(entity, ENTITY)));
    }

    public Entity updateSelect(Entity entity) throws DatabaseException {
        return this.updateSelect(Collections.singletonList(Objects.requireNonNull(entity, ENTITY))).iterator().next();
    }

    public void update(Collection<? extends Entity> entities) throws DatabaseException {
        this.update(entities, null);
    }

    public Collection<Entity> updateSelect(Collection<? extends Entity> entities) throws DatabaseException {
        if (Objects.requireNonNull(entities, ENTITIES).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Entity> updatedEntities = new ArrayList<Entity>(entities.size());
        this.update(entities, updatedEntities);
        return updatedEntities;
    }

    public int update(EntityConnection.Update update) throws DatabaseException {
        if (Objects.requireNonNull(update, CONDITION).columnValues().isEmpty()) {
            throw new IllegalArgumentException("No attribute values provided for update");
        }
        this.checkIfReadOnly(update.where().entityType());
        ArrayList<Object> statementValues = new ArrayList<Object>();
        ArrayList statementColumns = new ArrayList();
        String updateQuery = this.createUpdateQuery(update, statementColumns, statementValues);
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            int n;
            block12: {
                PreparedStatement statement = this.prepareStatement(updateQuery);
                try {
                    int updatedRows = this.executeUpdate(statement, updateQuery, statementColumns, statementValues, Database.Operation.UPDATE);
                    this.commitIfTransactionIsNotOpen();
                    n = updatedRows;
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.rollbackQuietlyIfTransactionIsNotOpen();
                        LOG.error(this.createLogMessage(updateQuery, statementValues, statementColumns, e), (Throwable)e);
                        throw this.translateSQLException(e, Database.Operation.UPDATE);
                    }
                }
                statement.close();
            }
            return n;
        }
    }

    public int delete(Condition condition) throws DatabaseException {
        this.checkIfReadOnly(Objects.requireNonNull(condition, CONDITION).entityType());
        EntityDefinition entityDefinition = this.definition(condition.entityType());
        List statementValues = condition.values();
        List<ColumnDefinition<?>> statementColumns = DefaultLocalEntityConnection.columnDefinitions(entityDefinition, condition.columns());
        String deleteQuery = Queries.deleteQuery(entityDefinition.tableName(), condition.toString(entityDefinition));
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            int n;
            block11: {
                PreparedStatement statement = this.prepareStatement(deleteQuery);
                try {
                    int deleteCount = this.executeUpdate(statement, deleteQuery, statementColumns, statementValues, Database.Operation.DELETE);
                    this.commitIfTransactionIsNotOpen();
                    n = deleteCount;
                    if (statement == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.rollbackQuietlyIfTransactionIsNotOpen();
                        LOG.error(this.createLogMessage(deleteQuery, statementValues, statementColumns, e), (Throwable)e);
                        throw this.translateSQLException(e, Database.Operation.DELETE);
                    }
                }
                statement.close();
            }
            return n;
        }
    }

    public void delete(Entity.Key key) throws DatabaseException {
        this.delete(Collections.singletonList(Objects.requireNonNull(key, "key")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Collection<Entity.Key> keys) throws DatabaseException {
        if (Objects.requireNonNull(keys, "keys").isEmpty()) {
            return;
        }
        LinkedHashMap keysByEntityType = Entity.mapKeysToType(keys);
        this.checkIfReadOnly(keysByEntityType.keySet());
        List statementValues = null;
        List<ColumnDefinition<?>> statementColumns = null;
        PreparedStatement statement = null;
        Condition condition = null;
        String deleteQuery = null;
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            try {
                int deleteCount = 0;
                for (Map.Entry entityTypeKeys : keysByEntityType.entrySet()) {
                    EntityDefinition entityDefinition = this.definition((EntityType)entityTypeKeys.getKey());
                    condition = Condition.keys((Collection)((Collection)entityTypeKeys.getValue()));
                    statementValues = condition.values();
                    statementColumns = DefaultLocalEntityConnection.columnDefinitions(entityDefinition, condition.columns());
                    deleteQuery = Queries.deleteQuery(entityDefinition.tableName(), condition.toString(entityDefinition));
                    statement = this.prepareStatement(deleteQuery);
                    deleteCount += this.executeUpdate(statement, deleteQuery, statementColumns, statementValues, Database.Operation.DELETE);
                    statement.close();
                }
                if (keys.size() != deleteCount) {
                    throw new DeleteException(deleteCount + " rows deleted, expected " + keys.size());
                }
                this.commitIfTransactionIsNotOpen();
            }
            catch (SQLException e) {
                this.rollbackQuietlyIfTransactionIsNotOpen();
                LOG.error(this.createLogMessage(deleteQuery, condition == null ? Collections.emptyList() : statementValues, statementColumns, e), (Throwable)e);
                throw this.translateSQLException(e, Database.Operation.DELETE);
            }
            catch (DeleteException e) {
                this.rollbackQuietlyIfTransactionIsNotOpen();
                LOG.error(this.createLogMessage(deleteQuery, statementValues, statementColumns, (Exception)((Object)e)), (Throwable)e);
                throw e;
            }
            finally {
                DefaultLocalEntityConnection.closeSilently(statement);
            }
        }
    }

    public Entity select(Entity.Key key) throws DatabaseException {
        return this.selectSingle(Condition.key((Entity.Key)key));
    }

    public Entity selectSingle(Condition condition) throws DatabaseException {
        return this.selectSingle(EntityConnection.Select.where((Condition)condition).build());
    }

    public Entity selectSingle(EntityConnection.Select select) throws DatabaseException {
        List<Entity> entities = this.select(select);
        if (entities.isEmpty()) {
            throw new RecordNotFoundException(MESSAGES.getString("record_not_found"));
        }
        if (entities.size() > 1) {
            throw new MultipleRecordsFoundException(MESSAGES.getString("multiple_records_found"));
        }
        return entities.get(0);
    }

    public Collection<Entity> select(Collection<Entity.Key> keys) throws DatabaseException {
        if (Objects.requireNonNull(keys, "keys").isEmpty()) {
            return Collections.emptyList();
        }
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            try {
                ArrayList<Entity> result = new ArrayList<Entity>();
                for (List entityTypeKeys : Entity.mapKeysToType(keys).values()) {
                    result.addAll(this.query(EntityConnection.Select.where((Condition)Condition.keys((Collection)entityTypeKeys)).build()));
                }
                this.commitIfTransactionIsNotOpen();
                return result;
            }
            catch (SQLException e) {
                this.rollbackQuietlyIfTransactionIsNotOpen();
                throw this.translateSQLException(e, Database.Operation.SELECT);
            }
        }
    }

    public List<Entity> select(Condition condition) throws DatabaseException {
        return this.select(EntityConnection.Select.where((Condition)condition).build());
    }

    public List<Entity> select(EntityConnection.Select select) throws DatabaseException {
        Objects.requireNonNull(select, "select");
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            try {
                List<Entity> result = this.query(select);
                if (!select.forUpdate()) {
                    this.commitIfTransactionIsNotOpen();
                }
                return result;
            }
            catch (SQLException e) {
                this.rollbackQuietlyIfTransactionIsNotOpen();
                throw this.translateSQLException(e, Database.Operation.SELECT);
            }
        }
    }

    public <T> List<T> select(Column<T> column) throws DatabaseException {
        return this.select(Objects.requireNonNull(column), EntityConnection.Select.all((EntityType)column.entityType()).orderBy(OrderBy.ascending((Column[])new Column[]{column})).build());
    }

    public <T> List<T> select(Column<T> column, Condition condition) throws DatabaseException {
        return this.select(column, EntityConnection.Select.where((Condition)condition).orderBy(OrderBy.ascending((Column[])new Column[]{column})).build());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> select(Column<T> column, EntityConnection.Select select) throws DatabaseException {
        EntityDefinition entityDefinition = this.definition(Objects.requireNonNull(column, "column").entityType());
        if (!Objects.requireNonNull(select, "select").where().entityType().equals(column.entityType())) {
            throw new IllegalArgumentException("Condition entity type " + column.entityType() + " required, got " + select.where().entityType());
        }
        ColumnDefinition columnDefinition = entityDefinition.columns().definition(column);
        DefaultLocalEntityConnection.verifyColumnIsSelectable(columnDefinition, entityDefinition);
        Condition.Combination combinedCondition = Condition.and((Condition[])new Condition[]{select.where(), column.isNotNull()});
        String selectQuery = this.selectQueries.builder(entityDefinition).select(select, false).columns(columnDefinition.expression()).where((Condition)combinedCondition).groupBy(columnDefinition.expression()).build();
        List<Object> statementValues = DefaultLocalEntityConnection.statementValues((Condition)combinedCondition, select.having());
        List<ColumnDefinition<?>> statementColumns = DefaultLocalEntityConnection.statementColumns(entityDefinition, (Condition)combinedCondition, select.having());
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            try (PreparedStatement statement = this.prepareStatement(selectQuery);){
                List<T> list;
                block18: {
                    ResultSet resultSet = this.executeQuery(statement, selectQuery, statementColumns, statementValues);
                    try {
                        List<T> result = this.packResult(columnDefinition, resultSet);
                        this.commitIfTransactionIsNotOpen();
                        list = result;
                        if (resultSet == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                return list;
            }
            catch (SQLException e) {
                this.rollbackQuietlyIfTransactionIsNotOpen();
                LOG.error(this.createLogMessage(selectQuery, statementValues, statementColumns, e), (Throwable)e);
                throw this.translateSQLException(e, Database.Operation.SELECT);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int count(EntityConnection.Count count) throws DatabaseException {
        EntityDefinition entityDefinition = this.definition(Objects.requireNonNull(count, "count").where().entityType());
        String selectQuery = this.selectQueries.builder(entityDefinition).columns("COUNT(*)").subquery(this.selectQueries.builder(entityDefinition).select(EntityConnection.Select.where((Condition)count.where()).having(count.having()).attributes((Collection)entityDefinition.primaryKey().columns()).build()).build()).build();
        List<Object> statementValues = DefaultLocalEntityConnection.statementValues(count.where(), count.having());
        List<ColumnDefinition<?>> statementColumns = DefaultLocalEntityConnection.statementColumns(entityDefinition, count.where(), count.having());
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            try (PreparedStatement statement = this.prepareStatement(selectQuery);){
                int n;
                block18: {
                    ResultSet resultSet = this.executeQuery(statement, selectQuery, statementColumns, statementValues);
                    try {
                        if (!resultSet.next()) {
                            throw new SQLException("Row count query returned no value", "02000");
                        }
                        int result = resultSet.getInt(1);
                        this.commitIfTransactionIsNotOpen();
                        n = result;
                        if (resultSet == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                return n;
            }
            catch (SQLException e) {
                this.rollbackQuietlyIfTransactionIsNotOpen();
                LOG.error(this.createLogMessage(selectQuery, statementValues, statementColumns, e), (Throwable)e);
                throw this.translateSQLException(e, Database.Operation.SELECT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<EntityType, Collection<Entity>> dependencies(Collection<? extends Entity> entities) throws DatabaseException {
        Set entityTypes = Objects.requireNonNull(entities, ENTITIES).stream().map(Entity::entityType).collect(Collectors.toSet());
        if (entityTypes.isEmpty()) {
            return Collections.emptyMap();
        }
        if (entityTypes.size() > 1) {
            throw new IllegalArgumentException("All entities must be of the same type when selecting dependencies");
        }
        HashMap<EntityType, Collection<Entity>> dependencyMap = new HashMap<EntityType, Collection<Entity>>();
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            try {
                for (ForeignKeyDefinition foreignKeyReference : this.hardForeignKeyReferences((EntityType)entityTypes.iterator().next())) {
                    List<Entity> dependencies = this.query(EntityConnection.Select.where((Condition)foreignKeyReference.attribute().in(entities)).build(), 0);
                    if (dependencies.isEmpty()) continue;
                    dependencyMap.putIfAbsent(foreignKeyReference.entityType(), new HashSet());
                    ((Collection)dependencyMap.get(foreignKeyReference.entityType())).addAll(dependencies);
                }
                this.commitIfTransactionIsNotOpen();
            }
            catch (SQLException e) {
                this.rollbackQuietlyIfTransactionIsNotOpen();
                throw this.translateSQLException(e, Database.Operation.SELECT);
            }
        }
        return dependencyMap;
    }

    public <C extends EntityConnection, T, R> R execute(FunctionType<C, T, R> functionType) throws DatabaseException {
        return this.execute(functionType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends EntityConnection, T, R> R execute(FunctionType<C, T, R> functionType, T argument) throws DatabaseException {
        Objects.requireNonNull(functionType, "functionType");
        DatabaseException exception = null;
        try {
            this.logEntry(EXECUTE, functionType, argument);
            DatabaseConnection databaseConnection = this.connection;
            synchronized (databaseConnection) {
                Object object;
                try {
                    object = functionType.execute((Object)this, this.domain.function(functionType), argument);
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (DatabaseException e) {
                        exception = e;
                        LOG.error(this.createLogMessage(functionType.name(), argument instanceof List ? (List<T>)argument : Collections.singletonList(argument), Collections.emptyList(), (Exception)((Object)e)), (Throwable)e);
                        throw e;
                    }
                }
                return (R)object;
            }
        }
        finally {
            this.logExit(EXECUTE, exception);
        }
    }

    public <C extends EntityConnection, T> void execute(ProcedureType<C, T> procedureType) throws DatabaseException {
        this.execute(procedureType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends EntityConnection, T> void execute(ProcedureType<C, T> procedureType, T argument) throws DatabaseException {
        Objects.requireNonNull(procedureType, "procedureType");
        DatabaseException exception = null;
        try {
            this.logEntry(EXECUTE, procedureType, argument);
            DatabaseConnection databaseConnection = this.connection;
            synchronized (databaseConnection) {
                procedureType.execute((Object)this, this.domain.procedure(procedureType), argument);
            }
        }
        catch (DatabaseException e) {
            exception = e;
            LOG.error(this.createLogMessage(procedureType.name(), argument instanceof List ? (List<T>)argument : Collections.singletonList(argument), Collections.emptyList(), (Exception)((Object)e)), (Throwable)e);
            throw e;
        }
        finally {
            this.logExit(EXECUTE, exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, R, P> R report(ReportType<T, R, P> reportType, P reportParameters) throws ReportException {
        Objects.requireNonNull(reportType, REPORT);
        Throwable exception = null;
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            try {
                this.logEntry(REPORT, reportType, reportParameters);
                Object result = reportType.fill(this.domain.report(reportType), this.connection.getConnection(), reportParameters);
                this.commitIfTransactionIsNotOpen();
                Object object = result;
                return (R)object;
            }
            catch (SQLException e) {
                exception = e;
                this.rollbackQuietlyIfTransactionIsNotOpen();
                LOG.error(this.createLogMessage(null, Collections.singletonList(reportType), Collections.emptyList(), e), (Throwable)e);
                throw new ReportException((Throwable)this.translateSQLException(e, Database.Operation.SELECT));
            }
            catch (ReportException e) {
                exception = e;
                this.rollbackQuietlyIfTransactionIsNotOpen();
                LOG.error(this.createLogMessage(null, Collections.singletonList(reportType), Collections.emptyList(), (Exception)((Object)e)), (Throwable)e);
                throw e;
            }
            finally {
                this.logExit(REPORT, exception);
            }
        }
    }

    @Override
    public DatabaseConnection databaseConnection() {
        return this.connection;
    }

    @Override
    public ResultIterator<Entity> iterator(Condition condition) throws DatabaseException {
        return this.iterator(EntityConnection.Select.where((Condition)condition).build());
    }

    @Override
    public ResultIterator<Entity> iterator(EntityConnection.Select select) throws DatabaseException {
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            try {
                return this.resultIterator(select);
            }
            catch (SQLException e) {
                throw this.translateSQLException(e, Database.Operation.SELECT);
            }
        }
    }

    @Override
    public boolean isOptimisticLocking() {
        return this.optimisticLocking;
    }

    @Override
    public void setOptimisticLocking(boolean optimisticLocking) {
        this.optimisticLocking = optimisticLocking;
    }

    @Override
    public boolean isLimitForeignKeyFetchDepth() {
        return this.limitForeignKeyFetchDepth;
    }

    @Override
    public void setLimitForeignKeyFetchDepth(boolean limitForeignKeyFetchDepth) {
        this.limitForeignKeyFetchDepth = limitForeignKeyFetchDepth;
    }

    @Override
    public int getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    @Override
    public void setDefaultQueryTimeout(int defaultQueryTimeout) {
        this.defaultQueryTimeout = defaultQueryTimeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Entity.Key> insert(Collection<? extends Entity> entities, Collection<Entity> insertedEntities) throws DatabaseException {
        this.checkIfReadOnly(entities);
        ArrayList<Entity.Key> insertedKeys = new ArrayList<Entity.Key>(entities.size());
        ArrayList<Object> statementValues = new ArrayList<Object>();
        ArrayList statementColumns = new ArrayList();
        PreparedStatement statement = null;
        String insertQuery = null;
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            try {
                for (Entity entity : entities) {
                    EntityDefinition entityDefinition = this.definition(entity.entityType());
                    KeyGenerator keyGenerator = entityDefinition.primaryKey().generator();
                    keyGenerator.beforeInsert(entity, this.connection);
                    DefaultLocalEntityConnection.populateColumnsAndValues(entity, this.insertableColumns(entityDefinition, keyGenerator.inserted()), statementColumns, statementValues, columnDefinition -> entity.contains((Attribute)columnDefinition.attribute()));
                    if (keyGenerator.inserted() && statementColumns.isEmpty()) {
                        throw new SQLException("Unable to insert entity " + entity.entityType() + ", no values to insert");
                    }
                    insertQuery = Queries.insertQuery(entityDefinition.tableName(), statementColumns);
                    statement = this.prepareStatement(insertQuery, keyGenerator.returnGeneratedKeys());
                    this.executeUpdate(statement, insertQuery, statementColumns, statementValues, Database.Operation.INSERT);
                    keyGenerator.afterInsert(entity, this.connection, (Statement)statement);
                    insertedKeys.add(entity.primaryKey());
                    statement.close();
                    statementColumns.clear();
                    statementValues.clear();
                }
                if (insertedEntities != null) {
                    for (List list : Entity.mapKeysToType(insertedKeys).values()) {
                        insertedEntities.addAll(this.query(EntityConnection.Select.where((Condition)Condition.keys((Collection)list)).build(), 0));
                    }
                }
                this.commitIfTransactionIsNotOpen();
                Iterator iterator = insertedKeys;
                return iterator;
            }
            catch (SQLException e) {
                this.rollbackQuietlyIfTransactionIsNotOpen();
                LOG.error(this.createLogMessage(insertQuery, statementValues, statementColumns, e), (Throwable)e);
                throw this.translateSQLException(e, Database.Operation.INSERT);
            }
            finally {
                DefaultLocalEntityConnection.closeSilently(statement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Collection<? extends Entity> entities, List<Entity> updatedEntities) throws DatabaseException {
        LinkedHashMap entitiesByEntityType = Entity.mapToType(entities);
        this.checkIfReadOnly(entitiesByEntityType.keySet());
        ArrayList<Object> statementValues = new ArrayList<Object>();
        ArrayList statementColumns = new ArrayList();
        PreparedStatement statement = null;
        String updateQuery = null;
        DatabaseConnection databaseConnection = this.connection;
        synchronized (databaseConnection) {
            try {
                if (this.optimisticLocking) {
                    this.performOptimisticLocking(entitiesByEntityType);
                }
                for (Map.Entry entityTypeEntities : entitiesByEntityType.entrySet()) {
                    EntityDefinition entityDefinition = this.definition((EntityType)entityTypeEntities.getKey());
                    List<ColumnDefinition<?>> updatableColumns = this.updatableColumns(entityDefinition);
                    List entitiesToUpdate = (List)entityTypeEntities.getValue();
                    for (Entity entity : entitiesToUpdate) {
                        DefaultLocalEntityConnection.populateColumnsAndValues(entity, updatableColumns, statementColumns, statementValues, columnDefinition -> entity.modified((Attribute)columnDefinition.attribute()));
                        if (statementColumns.isEmpty()) {
                            throw new SQLException("Unable to update entity " + entity.entityType() + ", no modified values found");
                        }
                        Condition condition = Condition.key((Entity.Key)entity.originalPrimaryKey());
                        updateQuery = Queries.updateQuery(entityDefinition.tableName(), statementColumns, condition.toString(entityDefinition));
                        statement = this.prepareStatement(updateQuery);
                        statementColumns.addAll(DefaultLocalEntityConnection.columnDefinitions(entityDefinition, condition.columns()));
                        statementValues.addAll(condition.values());
                        int updatedRows = this.executeUpdate(statement, updateQuery, statementColumns, statementValues, Database.Operation.UPDATE);
                        if (updatedRows == 0) {
                            throw new UpdateException("Update did not affect any rows, entityType: " + entityTypeEntities.getKey());
                        }
                        statement.close();
                        statementColumns.clear();
                        statementValues.clear();
                    }
                    if (updatedEntities == null) continue;
                    List<Entity> selected = this.query(EntityConnection.Select.where((Condition)Condition.keys((Collection)Entity.primaryKeys((Collection)entitiesToUpdate))).build(), 0);
                    if (selected.size() != entitiesToUpdate.size()) {
                        throw new UpdateException(entitiesToUpdate.size() + " updated rows expected, query returned " + selected.size() + ", entityType: " + entityTypeEntities.getKey());
                    }
                    updatedEntities.addAll(selected);
                }
                this.commitIfTransactionIsNotOpen();
            }
            catch (SQLException e) {
                this.rollbackQuietlyIfTransactionIsNotOpen();
                LOG.error(this.createLogMessage(updateQuery, statementValues, statementColumns, e), (Throwable)e);
                throw this.translateSQLException(e, Database.Operation.UPDATE);
            }
            catch (RecordModifiedException e) {
                this.rollbackQuietlyIfTransactionIsNotOpen();
                LOG.debug(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (UpdateException e) {
                this.rollbackQuietlyIfTransactionIsNotOpen();
                LOG.error(this.createLogMessage(updateQuery, statementValues, statementColumns, (Exception)((Object)e)), (Throwable)e);
                throw e;
            }
            finally {
                DefaultLocalEntityConnection.closeSilently(statement);
            }
        }
    }

    private void performOptimisticLocking(Map<EntityType, List<Entity>> entitiesByEntityType) throws SQLException, RecordModifiedException {
        for (Map.Entry<EntityType, List<Entity>> entitiesByEntityTypeEntry : entitiesByEntityType.entrySet()) {
            EntityDefinition definition = this.definition(entitiesByEntityTypeEntry.getKey());
            if (!definition.optimisticLocking()) continue;
            this.checkIfMissingOrModified(entitiesByEntityTypeEntry.getKey(), entitiesByEntityTypeEntry.getValue());
        }
    }

    private void checkIfMissingOrModified(EntityType entityType, List<Entity> entities) throws SQLException, RecordModifiedException {
        Collection originalKeys = Entity.originalPrimaryKeys(entities);
        EntityConnection.Select selectForUpdate = EntityConnection.Select.where((Condition)Condition.keys((Collection)originalKeys)).attributes(this.primaryKeyAndWritableColumnAttributes(entityType)).forUpdate().build();
        Map currentEntitiesByKey = Entity.mapToPrimaryKey(this.query(selectForUpdate));
        for (Entity entity : entities) {
            Entity current = (Entity)currentEntitiesByKey.get(entity.originalPrimaryKey());
            if (current == null) {
                Entity original = entity.copy();
                original.revert();
                throw new RecordModifiedException((Object)entity, null, MESSAGES.getString(RECORD_MODIFIED) + ", " + original + " " + MESSAGES.getString("has_been_deleted"));
            }
            Collection<Column<?>> modifiedColumns = DefaultLocalEntityConnection.modifiedColumns(entity, current);
            if (modifiedColumns.isEmpty()) continue;
            throw new RecordModifiedException((Object)entity, (Object)current, DefaultLocalEntityConnection.createModifiedExceptionMessage(entity, current, modifiedColumns));
        }
    }

    private String createUpdateQuery(EntityConnection.Update update, List<ColumnDefinition<?>> statementColumns, List<Object> statementValues) throws UpdateException {
        EntityDefinition entityDefinition = this.definition(update.where().entityType());
        for (Map.Entry columnValue : update.columnValues().entrySet()) {
            ColumnDefinition columnDefinition = entityDefinition.columns().definition((Column)columnValue.getKey());
            if (!columnDefinition.updatable()) {
                throw new UpdateException("Column is not updatable: " + columnDefinition.attribute());
            }
            statementColumns.add(columnDefinition);
            statementValues.add(columnDefinition.attribute().type().validateType(columnValue.getValue()));
        }
        String updateQuery = Queries.updateQuery(entityDefinition.tableName(), statementColumns, update.where().toString(entityDefinition));
        statementColumns.addAll(DefaultLocalEntityConnection.columnDefinitions(entityDefinition, update.where().columns()));
        statementValues.addAll(update.where().values());
        return updateQuery;
    }

    private List<Entity> query(EntityConnection.Select select) throws SQLException {
        List<Entity> result = this.cachedResult(select);
        if (result != null) {
            LOG.debug("Returning cached result: " + select.where().entityType());
            return result;
        }
        return this.cacheResult(select, this.query(select, 0));
    }

    private List<Entity> query(EntityConnection.Select select, int currentForeignKeyFetchDepth) throws SQLException {
        List<Entity> result;
        try (ResultIterator<Entity> iterator = this.resultIterator(select);){
            result = this.packResult(iterator);
        }
        if (!result.isEmpty()) {
            this.populateForeignKeys(result, select, currentForeignKeyFetchDepth);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateForeignKeys(List<Entity> entities, EntityConnection.Select select, int currentForeignKeyFetchDepth) throws SQLException {
        Collection<ForeignKeyDefinition> foreignKeysToSet = this.foreignKeysToPopulate(entities.get(0).entityType(), select.attributes());
        for (ForeignKeyDefinition foreignKeyDefinition : foreignKeysToSet) {
            ForeignKey foreignKey = foreignKeyDefinition.attribute();
            int conditionOrForeignKeyFetchDepthLimit = select.fetchDepth(foreignKey).orElse(foreignKeyDefinition.fetchDepth());
            if (!this.withinFetchDepthLimit(currentForeignKeyFetchDepth, conditionOrForeignKeyFetchDepthLimit) || !DefaultLocalEntityConnection.containsReferenceAttributes(entities.get(0), foreignKey.references())) continue;
            try {
                this.logEntry("populateForeignKeys", (Object)foreignKeyDefinition);
                Collection referencedKeys = Entity.referencedKeys((ForeignKey)foreignKey, entities);
                if (referencedKeys.isEmpty()) {
                    for (int j = 0; j < entities.size(); ++j) {
                        entities.get(j).put((Attribute)foreignKey, null);
                    }
                    continue;
                }
                Map<Entity.Key, Entity> referencedEntitiesMappedByKey = this.queryReferencedEntities(foreignKeyDefinition, new ArrayList<Entity.Key>(referencedKeys), currentForeignKeyFetchDepth, conditionOrForeignKeyFetchDepthLimit);
                for (int j = 0; j < entities.size(); ++j) {
                    Entity entity = entities.get(j);
                    Entity.Key referencedKey = entity.referencedKey(foreignKey);
                    entity.put((Attribute)foreignKey, (Object)DefaultLocalEntityConnection.referencedEntity(referencedKey, referencedEntitiesMappedByKey));
                }
            }
            finally {
                this.logExit("populateForeignKeys");
            }
        }
    }

    private Collection<ForeignKeyDefinition> foreignKeysToPopulate(EntityType entityType, Collection<Attribute<?>> conditionAttributes) {
        Collection foreignKeyDefinitions = this.definition(entityType).foreignKeys().definitions();
        if (conditionAttributes.isEmpty()) {
            return foreignKeyDefinitions;
        }
        HashSet selectAttributes = new HashSet(conditionAttributes);
        return foreignKeyDefinitions.stream().filter(foreignKeyDefinition -> selectAttributes.contains(foreignKeyDefinition.attribute())).collect(Collectors.toList());
    }

    private boolean withinFetchDepthLimit(int currentForeignKeyFetchDepth, int conditionFetchDepthLimit) {
        return !this.limitForeignKeyFetchDepth || conditionFetchDepthLimit == -1 || currentForeignKeyFetchDepth < conditionFetchDepthLimit;
    }

    private Map<Entity.Key, Entity> queryReferencedEntities(ForeignKeyDefinition foreignKeyDefinition, List<Entity.Key> referencedKeys, int currentForeignKeyFetchDepth, int conditionFetchDepthLimit) throws SQLException {
        Entity.Key referencedKey = referencedKeys.get(0);
        Collection keyColumns = referencedKey.columns();
        ArrayList referencedEntities = new ArrayList(referencedKeys.size());
        int maximumNumberOfParameters = this.connection.database().maximumNumberOfParameters();
        for (int i = 0; i < referencedKeys.size(); i += maximumNumberOfParameters) {
            List<Entity.Key> keys = referencedKeys.subList(i, Math.min(i + maximumNumberOfParameters, referencedKeys.size()));
            EntityConnection.Select referencedEntitiesCondition = EntityConnection.Select.where((Condition)Condition.keys(keys)).fetchDepth(conditionFetchDepthLimit).attributes(DefaultLocalEntityConnection.attributesToSelect(foreignKeyDefinition, keyColumns)).build();
            referencedEntities.addAll(this.query(referencedEntitiesCondition, currentForeignKeyFetchDepth + 1).stream().map(IMMUTABLE).collect(Collectors.toList()));
        }
        if (referencedKey.primaryKey()) {
            return Entity.mapToPrimaryKey(referencedEntities);
        }
        return referencedEntities.stream().collect(Collectors.toMap(entity -> this.createKey((Entity)entity, keyColumns), Function.identity()));
    }

    private Entity.Key createKey(Entity entity, Collection<Column<?>> keyColumns) {
        Entity.Key.Builder keyBuilder = this.entities().keyBuilder(entity.entityType());
        keyColumns.forEach(column -> keyBuilder.with(column, entity.get((Attribute)column)));
        return keyBuilder.build();
    }

    private ResultIterator<Entity> resultIterator(EntityConnection.Select select) throws SQLException {
        Objects.requireNonNull(select, CONDITION);
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        EntityDefinition entityDefinition = this.definition(select.where().entityType());
        SelectQueries.Builder queryBuilder = this.selectQueries.builder(entityDefinition).select(select);
        String selectQuery = queryBuilder.build();
        List<Object> statementValues = DefaultLocalEntityConnection.statementValues(select.where(), select.having());
        List<ColumnDefinition<?>> statementColumns = DefaultLocalEntityConnection.statementColumns(entityDefinition, select.where(), select.having());
        try {
            statement = this.prepareStatement(selectQuery, false, select.queryTimeout());
            resultSet = this.executeQuery(statement, selectQuery, statementColumns, statementValues);
            return new EntityResultIterator(statement, resultSet, new EntityResultPacker(entityDefinition, queryBuilder.selectedColumns()));
        }
        catch (SQLException e) {
            DefaultLocalEntityConnection.closeSilently(resultSet);
            DefaultLocalEntityConnection.closeSilently(statement);
            LOG.error(this.createLogMessage(selectQuery, statementValues, statementColumns, e), (Throwable)e);
            throw e;
        }
    }

    private int executeUpdate(PreparedStatement statement, String query, List<ColumnDefinition<?>> statementColumns, List<?> statementValues, Database.Operation operation) throws SQLException {
        SQLException exception = null;
        this.logEntry(EXECUTE_UPDATE, (Object)statementValues);
        try {
            int n = DefaultLocalEntityConnection.setParameterValues(statement, statementColumns, statementValues).executeUpdate();
            return n;
        }
        catch (SQLException e) {
            exception = e;
            throw e;
        }
        finally {
            this.logExit(EXECUTE_UPDATE, exception);
            this.countQuery(operation);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.createLogMessage(query, statementValues, statementColumns, exception));
            }
        }
    }

    private ResultSet executeQuery(PreparedStatement statement, String query, List<ColumnDefinition<?>> statementColumns, List<?> statementValues) throws SQLException {
        SQLException exception = null;
        this.logEntry(EXECUTE_QUERY, (Object)statementValues);
        try {
            ResultSet resultSet = DefaultLocalEntityConnection.setParameterValues(statement, statementColumns, statementValues).executeQuery();
            return resultSet;
        }
        catch (SQLException e) {
            exception = e;
            throw e;
        }
        finally {
            this.logExit(EXECUTE_QUERY, exception);
            this.countQuery(Database.Operation.SELECT);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.createLogMessage(query, statementValues, statementColumns, exception));
            }
        }
    }

    private static List<ColumnDefinition<?>> statementColumns(EntityDefinition entityDefinition, Condition where, Condition having) {
        List<ColumnDefinition<?>> whereColumns = DefaultLocalEntityConnection.columnDefinitions(entityDefinition, where.columns());
        if (having == null || having instanceof Condition.All) {
            return whereColumns;
        }
        List<ColumnDefinition<?>> havingColumns = DefaultLocalEntityConnection.columnDefinitions(entityDefinition, having.columns());
        ArrayList statementColumns = new ArrayList(whereColumns.size() + havingColumns.size());
        statementColumns.addAll(whereColumns);
        statementColumns.addAll(havingColumns);
        return statementColumns;
    }

    private static List<Object> statementValues(Condition where, Condition having) {
        List whereValues = where.values();
        if (having == null || having instanceof Condition.All) {
            return whereValues;
        }
        List havingValues = having.values();
        ArrayList<Object> statementValues = new ArrayList<Object>(whereValues.size() + havingValues.size());
        statementValues.addAll(where.values());
        statementValues.addAll(havingValues);
        return statementValues;
    }

    private PreparedStatement prepareStatement(String query) throws SQLException {
        return this.prepareStatement(query, false);
    }

    private PreparedStatement prepareStatement(String query, boolean returnGeneratedKeys) throws SQLException {
        return this.prepareStatement(query, returnGeneratedKeys, this.defaultQueryTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(String query, boolean returnGeneratedKeys, int queryTimeout) throws SQLException {
        try {
            this.logEntry("prepareStatement", (Object)query);
            PreparedStatement statement = returnGeneratedKeys ? this.connection.getConnection().prepareStatement(query, 1) : this.connection.getConnection().prepareStatement(query);
            statement.setQueryTimeout(queryTimeout);
            PreparedStatement preparedStatement = statement;
            return preparedStatement;
        }
        finally {
            this.logExit("prepareStatement");
        }
    }

    private Collection<ForeignKeyDefinition> hardForeignKeyReferences(EntityType entityType) {
        return this.hardForeignKeyReferenceCache.computeIfAbsent(entityType, this::initializeHardForeignKeyReferences);
    }

    private List<ForeignKeyDefinition> initializeHardForeignKeyReferences(EntityType entityType) {
        return this.domain.entities().definitions().stream().flatMap(entityDefinition -> entityDefinition.foreignKeys().definitions().stream()).filter(foreignKeyDefinition -> !foreignKeyDefinition.soft()).filter(foreignKeyDefinition -> foreignKeyDefinition.attribute().referencedType().equals(entityType)).collect(Collectors.toList());
    }

    private List<Entity> packResult(ResultIterator<Entity> iterator) throws SQLException {
        SQLException packingException = null;
        ArrayList<Entity> result = new ArrayList<Entity>();
        try {
            this.logEntry(PACK_RESULT);
            while (iterator.hasNext()) {
                result.add((Entity)iterator.next());
            }
            ArrayList<Entity> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            packingException = e;
            throw e;
        }
        finally {
            this.logExit(PACK_RESULT, packingException, "row count: " + result.size());
        }
    }

    private <T> List<T> packResult(ColumnDefinition<T> columnDefinition, ResultSet resultSet) throws SQLException {
        SQLException packingException = null;
        List result = Collections.emptyList();
        try {
            this.logEntry(PACK_RESULT);
            List list = result = DefaultLocalEntityConnection.resultPacker(columnDefinition).pack(resultSet);
            return list;
        }
        catch (SQLException e) {
            packingException = e;
            throw e;
        }
        finally {
            this.logExit(PACK_RESULT, packingException, "row count: " + result.size());
        }
    }

    private List<ColumnDefinition<?>> insertableColumns(EntityDefinition entityDefinition, boolean includePrimaryKeyColumns) {
        return this.insertableColumnsCache.computeIfAbsent(entityDefinition.entityType(), entityType -> DefaultLocalEntityConnection.writableColumnDefinitions(entityDefinition, includePrimaryKeyColumns, true));
    }

    private List<ColumnDefinition<?>> updatableColumns(EntityDefinition entityDefinition) {
        return this.updatableColumnsCache.computeIfAbsent(entityDefinition.entityType(), entityType -> DefaultLocalEntityConnection.writableColumnDefinitions(entityDefinition, true, false));
    }

    private List<Attribute<?>> primaryKeyAndWritableColumnAttributes(EntityType entityType) {
        return this.primaryKeyAndWritableColumnsCache.computeIfAbsent(entityType, e -> this.collectPrimaryKeyAndWritableColumnAttributes(entityType));
    }

    private List<Attribute<?>> collectPrimaryKeyAndWritableColumnAttributes(EntityType entityType) {
        EntityDefinition entityDefinition = this.definition(entityType);
        ArrayList writableAndPrimaryKeyColumns = new ArrayList(DefaultLocalEntityConnection.writableColumnDefinitions(entityDefinition, true, true));
        entityDefinition.primaryKey().columnDefinitions().forEach(primaryKeyColumn -> {
            if (!writableAndPrimaryKeyColumns.contains(primaryKeyColumn)) {
                writableAndPrimaryKeyColumns.add((ColumnDefinition<?>)primaryKeyColumn);
            }
        });
        return writableAndPrimaryKeyColumns.stream().map(ColumnDefinition::attribute).collect(Collectors.toList());
    }

    private DatabaseException translateSQLException(SQLException exception, Database.Operation operation) {
        Database database = this.connection.database();
        if (database.isUniqueConstraintException(exception)) {
            return new UniqueConstraintException(exception, database.errorMessage(exception, operation));
        }
        if (database.isReferentialIntegrityException(exception)) {
            return new ReferentialIntegrityException(exception, database.errorMessage(exception, operation));
        }
        if (database.isTimeoutException(exception)) {
            return new QueryTimeoutException(exception, database.errorMessage(exception, operation));
        }
        return new DatabaseException(exception, database.errorMessage(exception, operation));
    }

    private void rollbackQuietly() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            LOG.error("Exception while performing a quiet rollback", (Throwable)e);
        }
    }

    private void commitIfTransactionIsNotOpen() throws SQLException {
        if (!this.transactionOpen()) {
            this.connection.commit();
        }
    }

    private void rollbackQuietlyIfTransactionIsNotOpen() {
        if (!this.transactionOpen()) {
            this.rollbackQuietly();
        }
    }

    private void logExit(String method) {
        this.logExit(method, null);
    }

    private void logExit(String method, Throwable exception) {
        this.logExit(method, exception, null);
    }

    private void logExit(String method, Throwable exception, String exitMessage) {
        MethodLogger methodLogger = this.connection.getMethodLogger();
        if (methodLogger != null && methodLogger.isEnabled()) {
            methodLogger.exit(method, exception, exitMessage);
        }
    }

    private void logEntry(String method) {
        MethodLogger methodLogger = this.connection.getMethodLogger();
        if (methodLogger != null && methodLogger.isEnabled()) {
            methodLogger.enter(method);
        }
    }

    private void logEntry(String method, Object argument) {
        MethodLogger methodLogger = this.connection.getMethodLogger();
        if (methodLogger != null && methodLogger.isEnabled()) {
            methodLogger.enter(method, argument);
        }
    }

    private void logEntry(String method, Object ... arguments) {
        MethodLogger methodLogger = this.connection.getMethodLogger();
        if (methodLogger != null && methodLogger.isEnabled()) {
            methodLogger.enter(method, (Object)arguments);
        }
    }

    private String createLogMessage(String sqlStatement, List<?> values, List<ColumnDefinition<?>> columnDefinitions, Exception exception) {
        StringBuilder logMessage = new StringBuilder(this.user().toString()).append("\n");
        String valueString = "[" + DefaultLocalEntityConnection.createValueString(values, columnDefinitions) + "]";
        logMessage.append(sqlStatement == null ? "no sql statement" : sqlStatement).append(", ").append(valueString);
        if (exception != null) {
            logMessage.append("\n").append(" [Exception: ").append(exception.getMessage()).append("]");
        }
        return logMessage.toString();
    }

    private void countQuery(Database.Operation operation) {
        switch (operation) {
            case SELECT: {
                this.connection.database().queryCounter().select();
                break;
            }
            case INSERT: {
                this.connection.database().queryCounter().insert();
                break;
            }
            case UPDATE: {
                this.connection.database().queryCounter().update();
                break;
            }
            case DELETE: {
                this.connection.database().queryCounter().delete();
                break;
            }
        }
    }

    private void checkIfReadOnly(Collection<? extends Entity> entities) throws DatabaseException {
        for (Entity entity : entities) {
            this.checkIfReadOnly(entity.entityType());
        }
    }

    private void checkIfReadOnly(Set<EntityType> entityTypes) throws DatabaseException {
        for (EntityType entityType : entityTypes) {
            this.checkIfReadOnly(entityType);
        }
    }

    private void checkIfReadOnly(EntityType entityType) throws DatabaseException {
        if (this.definition(entityType).readOnly()) {
            throw new DatabaseException("Entities of type: " + entityType + " are read only");
        }
    }

    private EntityDefinition definition(EntityType entityType) {
        return this.domain.entities().definition(entityType);
    }

    private List<Entity> cachedResult(EntityConnection.Select select) {
        if (this.queryCacheEnabled && !select.forUpdate()) {
            return this.queryCache.get(select);
        }
        return null;
    }

    private List<Entity> cacheResult(EntityConnection.Select select, List<Entity> result) {
        if (this.queryCacheEnabled && !select.forUpdate()) {
            LOG.debug("Caching result: " + select.where().entityType());
            this.queryCache.put(select, result);
        }
        return result;
    }

    private static Entity referencedEntity(Entity.Key referencedKey, Map<Entity.Key, Entity> entityKeyMap) {
        if (referencedKey == null) {
            return null;
        }
        Entity referencedEntity = entityKeyMap.get(referencedKey);
        if (referencedEntity == null) {
            referencedEntity = Entity.entity((Entity.Key)referencedKey).immutable();
        }
        return referencedEntity;
    }

    private static List<ColumnDefinition<?>> writableColumnDefinitions(EntityDefinition entityDefinition, boolean includePrimaryKeyColumns, boolean includeNonUpdatable) {
        return entityDefinition.columns().definitions().stream().filter(column -> DefaultLocalEntityConnection.isWritable(column, includePrimaryKeyColumns, includeNonUpdatable)).collect(Collectors.toList());
    }

    private static boolean isWritable(ColumnDefinition<?> column, boolean includePrimaryKeyColumns, boolean includeNonUpdatable) {
        return !(!column.insertable() || !includeNonUpdatable && !column.updatable() || !includePrimaryKeyColumns && column.primaryKey());
    }

    private static List<ColumnDefinition<?>> columnDefinitions(EntityDefinition entityDefinition, List<Column<?>> columns) {
        return columns.stream().map(arg_0 -> ((EntityDefinition.Columns)entityDefinition.columns()).definition(arg_0)).collect(Collectors.toList());
    }

    private static <T> ResultPacker<T> resultPacker(ColumnDefinition<T> columnDefinition) {
        return resultSet -> columnDefinition.get(resultSet, 1);
    }

    private static PreparedStatement setParameterValues(PreparedStatement statement, List<ColumnDefinition<?>> statementColumns, List<?> statementValues) throws SQLException {
        if (statementValues.isEmpty()) {
            return statement;
        }
        if (statementColumns.size() != statementValues.size()) {
            throw new SQLException("Parameter column value count mismatch: expected: " + statementValues.size() + ", got: " + statementColumns.size());
        }
        for (int i = 0; i < statementColumns.size(); ++i) {
            DefaultLocalEntityConnection.setParameterValue(statement, statementColumns.get(i), statementValues.get(i), i + 1);
        }
        return statement;
    }

    private static void setParameterValue(PreparedStatement statement, ColumnDefinition<Object> columnDefinition, Object value, int parameterIndex) throws SQLException {
        Object columnValue = columnDefinition.converter().toColumnValue(value, (Statement)statement);
        try {
            if (columnValue == null) {
                statement.setNull(parameterIndex, columnDefinition.type());
            } else {
                statement.setObject(parameterIndex, columnValue, columnDefinition.type());
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to set parameter: " + columnDefinition + ", value: " + value + ", value class: " + (Serializable)(value == null ? "null" : value.getClass()), (Throwable)e);
            throw e;
        }
    }

    static Collection<Column<?>> modifiedColumns(Entity entity, Entity comparison) {
        return comparison.entrySet().stream().map(entry -> entity.definition().attributes().definition((Attribute)entry.getKey())).filter(ColumnDefinition.class::isInstance).map(attributeDefinition -> (ColumnDefinition)attributeDefinition).filter(columnDefinition -> columnDefinition.updatable() && !columnDefinition.lazy() && DefaultLocalEntityConnection.valueMissingOrModified(entity, comparison, columnDefinition.attribute())).map(ColumnDefinition::attribute).collect(Collectors.toList());
    }

    static <T> boolean valueMissingOrModified(Entity entity, Entity comparison, Attribute<T> attribute) {
        if (!entity.contains(attribute)) {
            return true;
        }
        Object originalValue = entity.original(attribute);
        Object comparisonValue = comparison.get(attribute);
        if (attribute.type().isByteArray()) {
            return !Arrays.equals((byte[])originalValue, (byte[])comparisonValue);
        }
        return !Objects.equals(originalValue, comparisonValue);
    }

    private static void populateColumnsAndValues(Entity entity, List<ColumnDefinition<?>> columnDefinitions, List<ColumnDefinition<?>> statementColumns, List<Object> statementValues, Predicate<ColumnDefinition<?>> includeIf) {
        for (int i = 0; i < columnDefinitions.size(); ++i) {
            ColumnDefinition<?> columnDefinition = columnDefinitions.get(i);
            if (!includeIf.test(columnDefinition)) continue;
            statementColumns.add(columnDefinition);
            statementValues.add(entity.get((Attribute)columnDefinition.attribute()));
        }
    }

    private static String createModifiedExceptionMessage(Entity entity, Entity modified, Collection<Column<?>> modifiedColumns) {
        return modifiedColumns.stream().map(column -> " \n" + column + ": " + entity.original((Attribute)column) + " -> " + modified.get((Attribute)column)).collect(Collectors.joining("", MESSAGES.getString(RECORD_MODIFIED) + ", " + entity.entityType(), ""));
    }

    private static boolean containsReferenceAttributes(Entity entity, List<ForeignKey.Reference<?>> references) {
        for (int i = 0; i < references.size(); ++i) {
            if (entity.contains((Attribute)references.get(i).column())) continue;
            return false;
        }
        return true;
    }

    private static Collection<Attribute<?>> attributesToSelect(ForeignKeyDefinition foreignKeyDefinition, Collection<? extends Attribute<?>> referencedAttributes) {
        if (foreignKeyDefinition.attributes().isEmpty()) {
            return Collections.emptyList();
        }
        HashSet selectAttributes = new HashSet(foreignKeyDefinition.attributes());
        selectAttributes.addAll(referencedAttributes);
        return selectAttributes;
    }

    private static String createValueString(List<?> values, List<ColumnDefinition<?>> columnDefinitions) {
        if (columnDefinitions == null || columnDefinitions.isEmpty()) {
            return "no values";
        }
        ArrayList<String> stringValues = new ArrayList<String>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            String stringValue;
            Object columnValue;
            ColumnDefinition<?> columnDefinition = columnDefinitions.get(i);
            Object value = values.get(i);
            try {
                columnValue = columnDefinition.converter().toColumnValue(value, null);
                stringValue = String.valueOf(value);
            }
            catch (SQLException e) {
                columnValue = value;
                stringValue = String.valueOf(value);
            }
            stringValues.add(columnValue == null ? "null" : DefaultLocalEntityConnection.addSingleQuotes(columnDefinition.type(), stringValue));
        }
        return String.join((CharSequence)", ", stringValues);
    }

    private static String addSingleQuotes(int columnType, String string) {
        switch (columnType) {
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2014: {
                return "'" + string + "'";
            }
        }
        return string;
    }

    private static void verifyColumnIsSelectable(ColumnDefinition<?> columnDefinition, EntityDefinition entityDefinition) {
        if (columnDefinition.aggregate()) {
            throw new UnsupportedOperationException("Selecting column values is not implemented for aggregate function values");
        }
        SelectQuery selectQuery = entityDefinition.selectQuery();
        if (selectQuery != null && selectQuery.columns() != null) {
            throw new UnsupportedOperationException("Selecting column values is not implemented for entities with custom column clauses");
        }
    }

    private static void closeSilently(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static Database configureDatabase(Database database, Domain domain) throws DatabaseException {
        new DatabaseConfiguration(Objects.requireNonNull(domain), Objects.requireNonNull(database)).configure();
        return database;
    }

    private static final class DatabaseConfiguration {
        private static final Set<DatabaseConfiguration> CONFIGURED_DATABASES = new HashSet<DatabaseConfiguration>();
        private final Domain domain;
        private final Database database;
        private final int hashCode;

        private DatabaseConfiguration(Domain domain, Database database) {
            this.domain = domain;
            this.database = database;
            this.hashCode = Objects.hash(domain.type(), database);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof DatabaseConfiguration)) {
                return false;
            }
            DatabaseConfiguration that = (DatabaseConfiguration)object;
            return Objects.equals(this.domain.type(), that.domain.type()) && this.database == that.database;
        }

        public int hashCode() {
            return this.hashCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void configure() throws DatabaseException {
            Set<DatabaseConfiguration> set = CONFIGURED_DATABASES;
            synchronized (set) {
                if (!CONFIGURED_DATABASES.contains(this)) {
                    this.domain.configureDatabase(this.database);
                    CONFIGURED_DATABASES.add(this);
                }
            }
        }
    }
}

