/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.local;

import is.codion.common.db.result.ResultPacker;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.BlobColumnDefinition;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.TransientAttributeDefinition;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

final class EntityResultPacker
implements ResultPacker<Entity> {
    private static final Function<EntityDefinition, List<TransientAttributeDefinition<?>>> INIT_NON_DERIVED_TRANSIENT_ATTRIBUTES = EntityResultPacker::initializeNonDerivedTransientAttributes;
    private static final Function<EntityDefinition, List<ColumnDefinition<byte[]>>> INIT_LAZY_LOADED_BLOB_COLUMNS = EntityResultPacker::initializeLazyLoadedBlobColumns;
    private static final Map<EntityDefinition, List<TransientAttributeDefinition<?>>> NON_DERIVED_TRANSIENT_ATTRIBUTES = new ConcurrentHashMap();
    private static final Map<EntityDefinition, List<ColumnDefinition<byte[]>>> LAZY_LOADED_BLOB_COLUMNS = new ConcurrentHashMap<EntityDefinition, List<ColumnDefinition<byte[]>>>();
    private final EntityDefinition entityDefinition;
    private final List<ColumnDefinition<?>> columnDefinitions;

    EntityResultPacker(EntityDefinition entityDefinition, List<ColumnDefinition<?>> columnDefinitions) {
        this.entityDefinition = entityDefinition;
        this.columnDefinitions = columnDefinitions;
    }

    public Entity get(ResultSet resultSet) throws SQLException {
        HashMap values = new HashMap(this.columnDefinitions.size());
        this.addResultSetValues(resultSet, values);
        this.addTransientNullValues(values);
        this.addLazyLoadedBlobNullValues(values);
        return this.entityDefinition.entity(values);
    }

    private void addResultSetValues(ResultSet resultSet, Map<Attribute<?>, Object> values) throws SQLException {
        for (int i = 0; i < this.columnDefinitions.size(); ++i) {
            ColumnDefinition<?> columnDefinition = this.columnDefinitions.get(i);
            try {
                values.put((Attribute<?>)columnDefinition.attribute(), columnDefinition.prepareValue(columnDefinition.get(resultSet, i + 1)));
                continue;
            }
            catch (Exception e) {
                throw new SQLException("Exception fetching: " + columnDefinition + ", entity: " + this.entityDefinition.entityType() + " [" + e.getMessage() + "]", e);
            }
        }
    }

    private void addTransientNullValues(Map<Attribute<?>, Object> values) {
        List<TransientAttributeDefinition<?>> nonDerivedTransientAttributes = NON_DERIVED_TRANSIENT_ATTRIBUTES.computeIfAbsent(this.entityDefinition, INIT_NON_DERIVED_TRANSIENT_ATTRIBUTES);
        if (!nonDerivedTransientAttributes.isEmpty()) {
            for (TransientAttributeDefinition<?> attribute : nonDerivedTransientAttributes) {
                values.put(attribute.attribute(), null);
            }
        }
    }

    private void addLazyLoadedBlobNullValues(Map<Attribute<?>, Object> values) {
        List<ColumnDefinition<byte[]>> lazyLoadedBlobColumns = LAZY_LOADED_BLOB_COLUMNS.computeIfAbsent(this.entityDefinition, INIT_LAZY_LOADED_BLOB_COLUMNS);
        if (!lazyLoadedBlobColumns.isEmpty()) {
            for (ColumnDefinition<byte[]> column : lazyLoadedBlobColumns) {
                values.putIfAbsent((Attribute<?>)column.attribute(), null);
            }
        }
    }

    private static List<TransientAttributeDefinition<?>> initializeNonDerivedTransientAttributes(EntityDefinition entityDefinition) {
        return entityDefinition.attributes().definitions().stream().filter(TransientAttributeDefinition.class::isInstance).map(attributeDefinition -> (TransientAttributeDefinition)attributeDefinition).filter(transientAttributeDefinition -> !transientAttributeDefinition.derived()).collect(Collectors.toList());
    }

    private static List<ColumnDefinition<byte[]>> initializeLazyLoadedBlobColumns(EntityDefinition entityDefinition) {
        return entityDefinition.columns().definitions().stream().filter(column -> column.attribute().type().isByteArray()).map(column -> column).filter(column -> !(column instanceof BlobColumnDefinition) || !((BlobColumnDefinition)column).eagerlyLoaded()).collect(Collectors.toList());
    }
}

