/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.http;

import is.codion.common.NullOrEmpty;
import is.codion.common.Serializer;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.exception.MultipleRecordsFoundException;
import is.codion.common.db.exception.RecordNotFoundException;
import is.codion.common.db.operation.FunctionType;
import is.codion.common.db.operation.ProcedureType;
import is.codion.common.db.report.ReportException;
import is.codion.common.db.report.ReportType;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.http.DefaultHttpEntityConnection;
import is.codion.framework.db.http.HttpEntityConnection;
import is.codion.framework.db.http.JsonHttpEntityConnection;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import java.io.IOException;
import java.net.CookieManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpEntityConnection
implements HttpEntityConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHttpEntityConnection.class);
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(HttpEntityConnection.class.getName(), Locale.getDefault());
    static final Executor DEFAULT_EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1, new DaemonThreadFactory());
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASIC = "Basic ";
    private static final String DOMAIN_TYPE_NAME = "domainTypeName";
    private static final String CLIENT_TYPE_ID = "clientTypeId";
    private static final String CLIENT_ID = "clientId";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final int HTTP_STATUS_OK = 200;
    private final User user;
    protected final String baseurl;
    protected final HttpClient httpClient;
    protected final Entities entities;
    protected final String[] headers;
    protected final Duration socketTimeout;
    private boolean closed;

    AbstractHttpEntityConnection(DefaultBuilder builder, String path) {
        this.user = Objects.requireNonNull(builder.user, "user");
        this.baseurl = AbstractHttpEntityConnection.createBaseUrl(builder, path);
        this.socketTimeout = Duration.ofMillis(builder.socketTimeout);
        this.httpClient = AbstractHttpEntityConnection.createHttpClient(builder.connectTimeout, builder.executor);
        this.headers = new String[]{DOMAIN_TYPE_NAME, Objects.requireNonNull(builder.domainType, "domainType").name(), CLIENT_TYPE_ID, Objects.requireNonNull(builder.clientTypeId, CLIENT_TYPE_ID), CLIENT_ID, Objects.requireNonNull(builder.clientId, CLIENT_ID).toString(), AUTHORIZATION, AbstractHttpEntityConnection.createAuthorizationHeader(this.user)};
        this.entities = this.initializeEntities();
    }

    public final Entities entities() {
        return this.entities;
    }

    public final User user() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean connected() {
        HttpClient httpClient = this.httpClient;
        synchronized (httpClient) {
            return !this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                AbstractHttpEntityConnection.handleResponse(this.execute(this.createRequest("close")));
                this.closed = true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beginTransaction() {
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                AbstractHttpEntityConnection.handleResponse(this.execute(this.createRequest("beginTransaction")));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollbackTransaction() {
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                AbstractHttpEntityConnection.handleResponse(this.execute(this.createRequest("rollbackTransaction")));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitTransaction() {
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                AbstractHttpEntityConnection.handleResponse(this.execute(this.createRequest("commitTransaction")));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
    }

    public final Entity select(Entity.Key key) throws DatabaseException {
        return this.selectSingle(Condition.key((Entity.Key)key));
    }

    public final Entity selectSingle(Condition condition) throws DatabaseException {
        return this.selectSingle(EntityConnection.Select.where((Condition)condition).build());
    }

    public final Entity selectSingle(EntityConnection.Select select) throws DatabaseException {
        List selected = this.select(select);
        if (NullOrEmpty.nullOrEmpty((Collection)selected)) {
            throw new RecordNotFoundException(MESSAGES.getString("record_not_found"));
        }
        if (selected.size() > 1) {
            throw new MultipleRecordsFoundException(MESSAGES.getString("many_records_found"));
        }
        return (Entity)selected.get(0);
    }

    public final <T> List<T> select(Column<T> column) throws DatabaseException {
        return this.select(Objects.requireNonNull(column), EntityConnection.Select.all((EntityType)column.entityType()).orderBy(OrderBy.ascending((Column[])new Column[]{column})).build());
    }

    public final <T> List<T> select(Column<T> column, Condition condition) throws DatabaseException {
        return this.select(column, EntityConnection.Select.where((Condition)condition).orderBy(OrderBy.ascending((Column[])new Column[]{column})).build());
    }

    public final List<Entity> select(Condition condition) throws DatabaseException {
        return this.select(EntityConnection.Select.where((Condition)condition).build());
    }

    public final Entity.Key insert(Entity entity) throws DatabaseException {
        return (Entity.Key)this.insert(Collections.singletonList(entity)).iterator().next();
    }

    public final Entity insertSelect(Entity entity) throws DatabaseException {
        return (Entity)this.insertSelect(Collections.singletonList(entity)).iterator().next();
    }

    public final void update(Entity entity) throws DatabaseException {
        this.update(Collections.singletonList(Objects.requireNonNull(entity, "entity")));
    }

    public final Entity updateSelect(Entity entity) throws DatabaseException {
        return (Entity)this.updateSelect(Collections.singletonList(entity)).iterator().next();
    }

    public final void delete(Entity.Key entityKey) throws DatabaseException {
        this.delete(Collections.singletonList(entityKey));
    }

    public final <C extends EntityConnection, T, R> R execute(FunctionType<C, T, R> functionType) throws DatabaseException {
        return this.execute(functionType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <C extends EntityConnection, T, R> R execute(FunctionType<C, T, R> functionType, T argument) throws DatabaseException {
        Objects.requireNonNull(functionType);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (R)AbstractHttpEntityConnection.handleResponse(this.execute(this.createRequest("function", Serializer.serialize(Arrays.asList(functionType, argument)))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
    }

    public final <C extends EntityConnection, T> void execute(ProcedureType<C, T> procedureType) throws DatabaseException {
        this.execute(procedureType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <C extends EntityConnection, T> void execute(ProcedureType<C, T> procedureType, T argument) throws DatabaseException {
        Objects.requireNonNull(procedureType);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                AbstractHttpEntityConnection.handleResponse(this.execute(this.createRequest("procedure", Serializer.serialize(Arrays.asList(procedureType, argument)))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T, R, P> R report(ReportType<T, R, P> reportType, P reportParameters) throws DatabaseException, ReportException {
        Objects.requireNonNull(reportType, "reportType");
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (R)AbstractHttpEntityConnection.handleResponse(this.execute(this.createRequest("report", Serializer.serialize(Arrays.asList(reportType, reportParameters)))));
            }
        }
        catch (DatabaseException | ReportException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
    }

    private Entities initializeEntities() {
        try {
            return (Entities)AbstractHttpEntityConnection.handleResponse(this.execute(this.createRequest("entities")));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw AbstractHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> HttpResponse<T> execute(HttpRequest operation) throws IOException, InterruptedException {
        HttpClient httpClient = this.httpClient;
        synchronized (httpClient) {
            return this.httpClient.send(operation, HttpResponse.BodyHandlers.ofByteArray());
        }
    }

    protected final HttpRequest createRequest(String path) {
        return HttpRequest.newBuilder().uri(URI.create(this.baseurl + path)).POST(HttpRequest.BodyPublishers.noBody()).headers(this.headers).build();
    }

    protected final HttpRequest createRequest(String path, byte[] data) {
        return HttpRequest.newBuilder().uri(URI.create(this.baseurl + path)).POST(HttpRequest.BodyPublishers.ofByteArray(data)).headers(this.headers).build();
    }

    private static HttpClient createHttpClient(int connectTimeout, Executor executor) {
        return HttpClient.newBuilder().executor(executor).cookieHandler(new CookieManager()).connectTimeout(Duration.ofMillis(connectTimeout)).build();
    }

    protected static <T> T handleResponse(HttpResponse<T> response) throws Exception {
        AbstractHttpEntityConnection.throwIfError(response);
        return (T)Serializer.deserialize((byte[])((byte[])response.body()));
    }

    protected static void throwIfError(HttpResponse<?> response) throws Exception {
        if (response.statusCode() != 200) {
            throw (Exception)Serializer.deserialize((byte[])((byte[])response.body()));
        }
    }

    protected static RuntimeException logAndWrap(Exception e) {
        LOG.error(e.getMessage(), (Throwable)e);
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    private static String createBaseUrl(DefaultBuilder builder, String path) {
        return (builder.https ? HTTPS : HTTP) + Objects.requireNonNull(builder.hostName, "hostName") + ":" + (builder.https ? builder.securePort : builder.port) + path;
    }

    private static String createAuthorizationHeader(User user) {
        return BASIC + Base64.getEncoder().encodeToString((user.username() + ":" + String.valueOf(user.password())).getBytes());
    }

    static final class DefaultBuilder
    implements HttpEntityConnection.Builder {
        private DomainType domainType;
        private String hostName = (String)HttpEntityConnection.HOSTNAME.get();
        private int port = (Integer)HttpEntityConnection.PORT.get();
        private int securePort = (Integer)HttpEntityConnection.SECURE_PORT.get();
        private boolean https = (Boolean)HttpEntityConnection.SECURE.get();
        private boolean json = (Boolean)HttpEntityConnection.JSON.get();
        private int socketTimeout = (Integer)HttpEntityConnection.SOCKET_TIMEOUT.get();
        private int connectTimeout = (Integer)HttpEntityConnection.CONNECT_TIMEOUT.get();
        private User user;
        private String clientTypeId;
        private UUID clientId;
        private Executor executor = DEFAULT_EXECUTOR;

        DefaultBuilder() {
        }

        @Override
        public HttpEntityConnection.Builder domainType(DomainType domainType) {
            this.domainType = Objects.requireNonNull(domainType);
            return this;
        }

        @Override
        public HttpEntityConnection.Builder hostName(String hostName) {
            this.hostName = Objects.requireNonNull(hostName);
            return this;
        }

        @Override
        public HttpEntityConnection.Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public HttpEntityConnection.Builder securePort(int securePort) {
            this.securePort = securePort;
            return this;
        }

        @Override
        public HttpEntityConnection.Builder https(boolean https) {
            this.https = https;
            return this;
        }

        @Override
        public HttpEntityConnection.Builder json(boolean json) {
            this.json = json;
            return this;
        }

        @Override
        public HttpEntityConnection.Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        @Override
        public HttpEntityConnection.Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Override
        public HttpEntityConnection.Builder user(User user) {
            this.user = Objects.requireNonNull(user);
            return this;
        }

        @Override
        public HttpEntityConnection.Builder clientTypeId(String clientTypeId) {
            this.clientTypeId = Objects.requireNonNull(clientTypeId);
            return this;
        }

        @Override
        public HttpEntityConnection.Builder clientId(UUID clientId) {
            this.clientId = Objects.requireNonNull(clientId);
            return this;
        }

        @Override
        public HttpEntityConnection.Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor);
            return this;
        }

        @Override
        public EntityConnection build() {
            return this.json ? new JsonHttpEntityConnection(this) : new DefaultHttpEntityConnection(this);
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

