/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.http;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.http.AbstractHttpEntityConnection;
import is.codion.framework.domain.DomainType;
import java.util.UUID;
import java.util.concurrent.Executor;

public interface HttpEntityConnection
extends EntityConnection {
    public static final PropertyValue<String> HOSTNAME = Configuration.stringValue((String)"codion.client.http.hostname", (String)"localhost");
    public static final PropertyValue<Integer> PORT = Configuration.integerValue((String)"codion.client.http.port", (int)8080);
    public static final PropertyValue<Integer> SECURE_PORT = Configuration.integerValue((String)"codion.client.http.securePort", (int)4443);
    public static final PropertyValue<Boolean> SECURE = Configuration.booleanValue((String)"codion.client.http.secure", (boolean)true);
    public static final PropertyValue<Boolean> JSON = Configuration.booleanValue((String)"codion.client.http.json", (boolean)true);
    public static final PropertyValue<Integer> SOCKET_TIMEOUT = Configuration.integerValue((String)"codion.client.http.socketTimeout", (int)2000);
    public static final PropertyValue<Integer> CONNECT_TIMEOUT = Configuration.integerValue((String)"codion.client.http.connectTimeout", (int)2000);

    public static Builder builder() {
        return new AbstractHttpEntityConnection.DefaultBuilder();
    }

    public static interface Builder {
        public Builder domainType(DomainType var1);

        public Builder hostName(String var1);

        public Builder port(int var1);

        public Builder securePort(int var1);

        public Builder https(boolean var1);

        public Builder json(boolean var1);

        public Builder socketTimeout(int var1);

        public Builder connectTimeout(int var1);

        public Builder user(User var1);

        public Builder clientTypeId(String var1);

        public Builder clientId(UUID var1);

        public Builder executor(Executor var1);

        public EntityConnection build();
    }
}

