/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.common.user.User;
import is.codion.common.version.Version;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.Entities;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.function.Consumer;

public interface EntityConnectionProvider
extends AutoCloseable {
    public static final String CONNECTION_TYPE_LOCAL = "local";
    public static final String CONNECTION_TYPE_REMOTE = "remote";
    public static final String CONNECTION_TYPE_HTTP = "http";
    public static final PropertyValue<DomainType> CLIENT_DOMAIN_TYPE = Configuration.value((String)"codion.client.domainType", DomainType::domainType);
    public static final PropertyValue<String> CLIENT_CONNECTION_TYPE = Configuration.stringValue((String)"codion.client.connectionType", (String)"local");

    public Entities entities();

    public <T extends EntityConnection> T connection();

    public String connectionType();

    public String description();

    public boolean connectionValid();

    public void addOnConnectListener(Consumer<EntityConnection> var1);

    public void removeOnConnectListener(Consumer<EntityConnection> var1);

    @Override
    public void close();

    public User user();

    public DomainType domainType();

    public UUID clientId();

    public String clientTypeId();

    public Version clientVersion();

    public static Builder<?, ?> builder() {
        String clientConnectionType = (String)CLIENT_CONNECTION_TYPE.getOrThrow();
        for (Builder builder : ServiceLoader.load(Builder.class)) {
            if (!builder.connectionType().equalsIgnoreCase(clientConnectionType)) continue;
            return builder;
        }
        throw new IllegalArgumentException("No connection provider builder available for requested client connection type: " + clientConnectionType);
    }

    public static interface Builder<T extends EntityConnectionProvider, B extends Builder<T, B>> {
        public String connectionType();

        public B user(User var1);

        public B domainType(DomainType var1);

        public B clientId(UUID var1);

        public B clientTypeId(String var1);

        public B clientVersion(Version var1);

        public B onClose(Consumer<EntityConnectionProvider> var1);

        public T build();
    }
}

