/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db;

import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.operation.FunctionType;
import is.codion.common.db.operation.ProcedureType;
import is.codion.common.db.report.ReportException;
import is.codion.common.db.report.ReportType;
import is.codion.common.user.User;
import is.codion.framework.db.DefaultCopyEntities;
import is.codion.framework.db.DefaultCount;
import is.codion.framework.db.DefaultInsertEntities;
import is.codion.framework.db.DefaultSelect;
import is.codion.framework.db.DefaultUpdate;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.Condition;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public interface EntityConnection
extends AutoCloseable {
    public static final int DEFAULT_QUERY_TIMEOUT_SECONDS = 120;

    public Entities entities();

    public User user();

    public boolean connected();

    @Override
    public void close();

    public boolean transactionOpen();

    public void beginTransaction();

    public void rollbackTransaction();

    public void commitTransaction();

    public void setQueryCacheEnabled(boolean var1);

    public boolean isQueryCacheEnabled();

    public <C extends EntityConnection, T, R> R execute(FunctionType<C, T, R> var1) throws DatabaseException;

    public <C extends EntityConnection, T, R> R execute(FunctionType<C, T, R> var1, T var2) throws DatabaseException;

    public <C extends EntityConnection, T> void execute(ProcedureType<C, T> var1) throws DatabaseException;

    public <C extends EntityConnection, T> void execute(ProcedureType<C, T> var1, T var2) throws DatabaseException;

    public Entity.Key insert(Entity var1) throws DatabaseException;

    public Entity insertSelect(Entity var1) throws DatabaseException;

    public Collection<Entity.Key> insert(Collection<? extends Entity> var1) throws DatabaseException;

    public Collection<Entity> insertSelect(Collection<? extends Entity> var1) throws DatabaseException;

    public void update(Entity var1) throws DatabaseException;

    public Entity updateSelect(Entity var1) throws DatabaseException;

    public void update(Collection<? extends Entity> var1) throws DatabaseException;

    public Collection<Entity> updateSelect(Collection<? extends Entity> var1) throws DatabaseException;

    public int update(Update var1) throws DatabaseException;

    public void delete(Entity.Key var1) throws DatabaseException;

    public void delete(Collection<Entity.Key> var1) throws DatabaseException;

    public int delete(Condition var1) throws DatabaseException;

    public <T> List<T> select(Column<T> var1) throws DatabaseException;

    public <T> List<T> select(Column<T> var1, Condition var2) throws DatabaseException;

    public <T> List<T> select(Column<T> var1, Select var2) throws DatabaseException;

    public Entity select(Entity.Key var1) throws DatabaseException;

    public Entity selectSingle(Condition var1) throws DatabaseException;

    public Entity selectSingle(Select var1) throws DatabaseException;

    public Collection<Entity> select(Collection<Entity.Key> var1) throws DatabaseException;

    public List<Entity> select(Condition var1) throws DatabaseException;

    public List<Entity> select(Select var1) throws DatabaseException;

    public Map<EntityType, Collection<Entity>> dependencies(Collection<? extends Entity> var1) throws DatabaseException;

    public int count(Count var1) throws DatabaseException;

    public <T, R, P> R report(ReportType<T, R, P> var1, P var2) throws DatabaseException, ReportException;

    public void writeBlob(Entity.Key var1, Column<byte[]> var2, byte[] var3) throws DatabaseException;

    public byte[] readBlob(Entity.Key var1, Column<byte[]> var2) throws DatabaseException;

    public static Copy.Builder copyEntities(EntityConnection source, EntityConnection destination) {
        return new DefaultCopyEntities.DefaultBuilder(source, destination);
    }

    public static Insert.Builder insertEntities(EntityConnection connection, Iterator<Entity> entities) {
        return new DefaultInsertEntities.DefaultBuilder(connection, entities);
    }

    public static interface Count {
        public Condition where();

        public Condition having();

        public static Count all(EntityType entityType) {
            return Count.where(Condition.all((EntityType)entityType));
        }

        public static Count where(Condition condition) {
            Objects.requireNonNull(condition);
            return new DefaultCount.DefaultBuilder(condition).build();
        }

        public static Count having(Condition condition) {
            Objects.requireNonNull(condition);
            return new DefaultCount.DefaultBuilder(Condition.all((EntityType)condition.entityType())).having(condition).build();
        }

        public static Builder builder(Condition where) {
            return new DefaultCount.DefaultBuilder(where);
        }

        public static interface Builder {
            public Builder having(Condition var1);

            public Count build();
        }
    }

    public static interface Update {
        public Condition where();

        public Map<Column<?>, Object> columnValues();

        public static Builder all(EntityType entityType) {
            return new DefaultUpdate.DefaultBuilder(Condition.all((EntityType)entityType));
        }

        public static Builder where(Condition condition) {
            return new DefaultUpdate.DefaultBuilder(condition);
        }

        public static interface Builder {
            public <T> Builder set(Column<?> var1, T var2);

            public Update build();
        }
    }

    public static interface Select {
        public Condition where();

        public Condition having();

        public Optional<OrderBy> orderBy();

        public int limit();

        public int offset();

        public boolean forUpdate();

        public int queryTimeout();

        public Optional<Integer> fetchDepth();

        public Optional<Integer> fetchDepth(ForeignKey var1);

        public Map<ForeignKey, Integer> foreignKeyFetchDepths();

        public Collection<Attribute<?>> attributes();

        public static Builder all(EntityType entityType) {
            return new DefaultSelect.DefaultBuilder(Condition.all((EntityType)entityType));
        }

        public static Builder where(Condition condition) {
            return new DefaultSelect.DefaultBuilder(condition);
        }

        public static interface Builder {
            public Builder orderBy(OrderBy var1);

            public Builder limit(int var1);

            public Builder offset(int var1);

            public Builder forUpdate();

            public Builder fetchDepth(int var1);

            public Builder fetchDepth(ForeignKey var1, int var2);

            public <T extends Attribute<?>> Builder attributes(T ... var1);

            public Builder attributes(Collection<? extends Attribute<?>> var1);

            public Builder queryTimeout(int var1);

            public Builder having(Condition var1);

            public Select build();
        }
    }

    public static interface Insert {
        public void execute() throws DatabaseException;

        public static interface Builder {
            public Builder batchSize(int var1);

            public Builder progressReporter(Consumer<Integer> var1);

            public Builder onInsert(Consumer<Collection<Entity.Key>> var1);

            public void execute() throws DatabaseException;

            public Insert build();
        }
    }

    public static interface Copy {
        public void execute() throws DatabaseException;

        public static interface Builder {
            public Builder entityTypes(EntityType ... var1);

            public Builder batchSize(int var1);

            public Builder includePrimaryKeys(boolean var1);

            public Builder condition(Condition var1);

            public void execute() throws DatabaseException;

            public Copy build();
        }
    }
}

