/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db;

import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

final class DefaultUpdate
implements EntityConnection.Update,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Condition where;
    private final Map<Column<?>, Object> columnValues;

    private DefaultUpdate(DefaultBuilder builder) {
        this.where = builder.where;
        this.columnValues = Collections.unmodifiableMap(builder.columnValues);
    }

    @Override
    public Condition where() {
        return this.where;
    }

    @Override
    public Map<Column<?>, Object> columnValues() {
        return this.columnValues;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultUpdate)) {
            return false;
        }
        DefaultUpdate that = (DefaultUpdate)object;
        return Objects.equals(this.where, that.where) && Objects.equals(this.columnValues, that.columnValues);
    }

    public int hashCode() {
        return Objects.hash(this.where, this.columnValues);
    }

    public String toString() {
        return "Update{columnValues=" + this.columnValues + "}";
    }

    static final class DefaultBuilder
    implements EntityConnection.Update.Builder {
        private final Condition where;
        private final Map<Column<?>, Object> columnValues = new LinkedHashMap();

        DefaultBuilder(Condition where) {
            this.where = Objects.requireNonNull(where);
        }

        @Override
        public <T> EntityConnection.Update.Builder set(Column<?> column, T value) {
            Objects.requireNonNull(column, "column");
            if (this.columnValues.containsKey(column)) {
                throw new IllegalStateException("Update already contains a value for column: " + column);
            }
            this.columnValues.put(column, value);
            return this;
        }

        @Override
        public EntityConnection.Update build() {
            return new DefaultUpdate(this);
        }
    }
}

