/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db;

import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.Condition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class DefaultSelect
implements EntityConnection.Select,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Condition where;
    private final Condition having;
    private final Map<ForeignKey, Integer> foreignKeyFetchDepths;
    private final Collection<Attribute<?>> attributes;
    private final OrderBy orderBy;
    private final Integer fetchDepth;
    private final boolean forUpdate;
    private final int limit;
    private final int offset;
    private final int queryTimeout;

    private DefaultSelect(DefaultBuilder builder) {
        this.where = builder.where;
        this.having = builder.having;
        this.foreignKeyFetchDepths = builder.foreignKeyFetchDepths == null ? null : Collections.unmodifiableMap(builder.foreignKeyFetchDepths);
        this.attributes = builder.attributes;
        this.orderBy = builder.orderBy;
        this.fetchDepth = builder.fetchDepth;
        this.forUpdate = builder.forUpdate;
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.queryTimeout = builder.queryTimeout;
    }

    @Override
    public Condition where() {
        return this.where;
    }

    @Override
    public Condition having() {
        return this.having;
    }

    @Override
    public Optional<OrderBy> orderBy() {
        return Optional.ofNullable(this.orderBy);
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public boolean forUpdate() {
        return this.forUpdate;
    }

    @Override
    public Optional<Integer> fetchDepth() {
        return Optional.ofNullable(this.fetchDepth);
    }

    @Override
    public Optional<Integer> fetchDepth(ForeignKey foreignKey) {
        Objects.requireNonNull(foreignKey);
        if (this.foreignKeyFetchDepths().containsKey(foreignKey)) {
            return Optional.of(this.foreignKeyFetchDepths.get(foreignKey));
        }
        return this.fetchDepth();
    }

    @Override
    public Map<ForeignKey, Integer> foreignKeyFetchDepths() {
        return this.foreignKeyFetchDepths == null ? Collections.emptyMap() : this.foreignKeyFetchDepths;
    }

    @Override
    public int queryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public Collection<Attribute<?>> attributes() {
        return this.attributes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultSelect)) {
            return false;
        }
        DefaultSelect that = (DefaultSelect)object;
        return this.forUpdate == that.forUpdate && this.limit == that.limit && this.offset == that.offset && this.where.equals(that.where) && Objects.equals(this.having, that.having) && Objects.equals(this.foreignKeyFetchDepths, that.foreignKeyFetchDepths) && this.attributes.equals(that.attributes) && Objects.equals(this.orderBy, that.orderBy) && Objects.equals(this.fetchDepth, that.fetchDepth);
    }

    public int hashCode() {
        return Objects.hash(this.forUpdate, this.limit, this.offset, this.where, this.foreignKeyFetchDepths, this.attributes, this.orderBy, this.fetchDepth);
    }

    public String toString() {
        return "Select{foreignKeyFetchDepths=" + this.foreignKeyFetchDepths + ", attributes=" + this.attributes + ", orderBy=" + this.orderBy + ", fetchDepth=" + this.fetchDepth + ", forUpdate=" + this.forUpdate + ", limit=" + this.limit + ", offset=" + this.offset + ", queryTimeout=" + this.queryTimeout + "}";
    }

    static final class DefaultBuilder
    implements EntityConnection.Select.Builder {
        private final Condition where;
        private Map<ForeignKey, Integer> foreignKeyFetchDepths;
        private Collection<Attribute<?>> attributes = Collections.emptyList();
        private Condition having;
        private OrderBy orderBy;
        private Integer fetchDepth;
        private boolean forUpdate;
        private int limit = -1;
        private int offset = -1;
        private int queryTimeout = 120;

        DefaultBuilder(Condition where) {
            this.where = Objects.requireNonNull(where);
            this.having = Condition.all((EntityType)where.entityType());
        }

        @Override
        public EntityConnection.Select.Builder orderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public EntityConnection.Select.Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public EntityConnection.Select.Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public EntityConnection.Select.Builder forUpdate() {
            this.forUpdate = true;
            this.fetchDepth = 0;
            return this;
        }

        @Override
        public EntityConnection.Select.Builder fetchDepth(int fetchDepth) {
            this.fetchDepth = fetchDepth;
            return this;
        }

        @Override
        public EntityConnection.Select.Builder fetchDepth(ForeignKey foreignKey, int fetchDepth) {
            Objects.requireNonNull(foreignKey);
            if (this.foreignKeyFetchDepths == null) {
                this.foreignKeyFetchDepths = new HashMap<ForeignKey, Integer>();
            }
            this.foreignKeyFetchDepths.put(foreignKey, fetchDepth);
            return this;
        }

        @Override
        public <T extends Attribute<?>> EntityConnection.Select.Builder attributes(T ... attributes) {
            this.attributes = ((Attribute[])Objects.requireNonNull(attributes)).length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(attributes));
            return this;
        }

        @Override
        public EntityConnection.Select.Builder attributes(Collection<? extends Attribute<?>> attributes) {
            this.attributes = Objects.requireNonNull(attributes).isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(attributes));
            return this;
        }

        @Override
        public EntityConnection.Select.Builder queryTimeout(int queryTimeout) {
            this.queryTimeout = queryTimeout;
            return this;
        }

        @Override
        public EntityConnection.Select.Builder having(Condition having) {
            this.having = Objects.requireNonNull(having);
            return this;
        }

        @Override
        public EntityConnection.Select build() {
            return new DefaultSelect(this);
        }
    }
}

