/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db;

import is.codion.common.db.exception.DatabaseException;
import is.codion.framework.db.DefaultInsertEntities;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.condition.Condition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class DefaultCopyEntities
implements EntityConnection.Copy {
    private final EntityConnection source;
    private final EntityConnection destination;
    private final Collection<EntityType> entityTypes = new ArrayList<EntityType>();
    private final Map<EntityType, Condition> conditions = new HashMap<EntityType, Condition>();
    private final int batchSize;
    private final boolean includePrimaryKeys;

    DefaultCopyEntities(DefaultBuilder builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.entityTypes.addAll(builder.entityTypes);
        this.conditions.putAll(builder.conditions);
        this.batchSize = builder.batchSize;
        this.includePrimaryKeys = builder.includePrimaryKeys;
    }

    @Override
    public void execute() throws DatabaseException {
        for (EntityType entityType : this.entityTypes) {
            Condition entityCondition = this.conditions.get(entityType);
            EntityConnection.Select.Builder conditionBuilder = entityCondition == null ? EntityConnection.Select.all(entityType) : EntityConnection.Select.where(entityCondition);
            List<Entity> entities = this.source.select(conditionBuilder.fetchDepth(0).build());
            if (!this.includePrimaryKeys) {
                entities.forEach(Entity::clearPrimaryKey);
            }
            new DefaultInsertEntities.DefaultBuilder(this.destination, entities.iterator()).batchSize(this.batchSize).execute();
        }
    }

    static final class DefaultBuilder
    implements EntityConnection.Copy.Builder {
        private final EntityConnection source;
        private final EntityConnection destination;
        private final Collection<EntityType> entityTypes = new ArrayList<EntityType>();
        private final Map<EntityType, Condition> conditions = new HashMap<EntityType, Condition>();
        private boolean includePrimaryKeys = true;
        private int batchSize = 100;

        DefaultBuilder(EntityConnection source, EntityConnection destination) {
            this.source = Objects.requireNonNull(source);
            this.destination = Objects.requireNonNull(destination);
        }

        @Override
        public EntityConnection.Copy.Builder entityTypes(EntityType ... entityTypes) {
            this.entityTypes.addAll(Arrays.asList(Objects.requireNonNull(entityTypes)));
            return this;
        }

        @Override
        public EntityConnection.Copy.Builder batchSize(int batchSize) {
            if (batchSize <= 0) {
                throw new IllegalArgumentException("Batch size must be a positive integer: " + batchSize);
            }
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public EntityConnection.Copy.Builder includePrimaryKeys(boolean includePrimaryKeys) {
            this.includePrimaryKeys = includePrimaryKeys;
            return this;
        }

        @Override
        public EntityConnection.Copy.Builder condition(Condition condition) {
            if (!this.entityTypes.contains(Objects.requireNonNull(condition).entityType())) {
                throw new IllegalArgumentException("CopyEntities.Builder does not contain entityType: " + condition.entityType());
            }
            this.conditions.put(condition.entityType(), condition);
            return this;
        }

        @Override
        public void execute() throws DatabaseException {
            this.build().execute();
        }

        @Override
        public EntityConnection.Copy build() {
            return new DefaultCopyEntities(this);
        }
    }
}

