/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db;

import is.codion.common.event.Event;
import is.codion.common.user.User;
import is.codion.common.version.Version;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.Entities;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityConnectionProvider
implements EntityConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEntityConnectionProvider.class);
    private final Object lock = new Object();
    private final Event<EntityConnection> onConnectEvent = Event.event();
    private final User user;
    private final DomainType domainType;
    private final UUID clientId;
    private final Version clientVersion;
    private final String clientTypeId;
    private final Consumer<EntityConnectionProvider> onClose;
    private EntityConnection entityConnection;
    private Entities entities;

    protected AbstractEntityConnectionProvider(AbstractBuilder<?, ?> builder) {
        Objects.requireNonNull(builder);
        this.user = Objects.requireNonNull(builder.user, "A user must be specified");
        this.domainType = Objects.requireNonNull(builder.domainType, "A domainType must be specified");
        this.clientId = Objects.requireNonNull(builder.clientId, "A clientId must be specified");
        this.clientTypeId = builder.clientTypeId;
        this.clientVersion = builder.clientVersion;
        this.onClose = builder.onClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Entities entities() {
        Object object = this.lock;
        synchronized (object) {
            if (this.entities == null) {
                this.doConnect();
            }
            return this.entities;
        }
    }

    @Override
    public final User user() {
        return this.user;
    }

    @Override
    public final DomainType domainType() {
        return this.domainType;
    }

    @Override
    public final UUID clientId() {
        return this.clientId;
    }

    @Override
    public final String clientTypeId() {
        return this.clientTypeId;
    }

    @Override
    public final Version clientVersion() {
        return this.clientVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean connectionValid() {
        Object object = this.lock;
        synchronized (object) {
            if (this.entityConnection == null) {
                return false;
            }
            try {
                return this.entityConnection.connected();
            }
            catch (RuntimeException e) {
                LOG.debug("Connection deemed invalid", (Throwable)e);
                return false;
            }
        }
    }

    @Override
    public final void addOnConnectListener(Consumer<EntityConnection> listener) {
        this.onConnectEvent.addDataListener(listener);
    }

    @Override
    public final void removeOnConnectListener(Consumer<EntityConnection> listener) {
        this.onConnectEvent.removeDataListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EntityConnection connection() {
        Object object = this.lock;
        synchronized (object) {
            this.validateConnection();
            return this.entityConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionValid()) {
                this.close(this.entityConnection);
            }
            this.entityConnection = null;
        }
        if (this.onClose != null) {
            this.onClose.accept(this);
        }
    }

    protected abstract EntityConnection connect();

    protected abstract void close(EntityConnection var1);

    private void validateConnection() {
        if (this.entityConnection == null) {
            this.doConnect();
        } else if (!this.connectionValid()) {
            LOG.info("Previous connection invalid, reconnecting");
            try {
                this.entityConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.entityConnection = null;
            this.doConnect();
        }
    }

    private void doConnect() {
        this.entityConnection = this.connect();
        this.entities = this.entityConnection.entities();
        this.onConnectEvent.accept((Object)this.entityConnection);
    }

    public static abstract class AbstractBuilder<T extends EntityConnectionProvider, B extends EntityConnectionProvider.Builder<T, B>>
    implements EntityConnectionProvider.Builder<T, B> {
        private final String connectionType;
        private User user;
        private DomainType domainType;
        private UUID clientId = UUID.randomUUID();
        private String clientTypeId;
        private Version clientVersion;
        private Consumer<EntityConnectionProvider> onClose;

        protected AbstractBuilder(String connectionType) {
            this.connectionType = Objects.requireNonNull(connectionType);
        }

        @Override
        public final String connectionType() {
            return this.connectionType;
        }

        @Override
        public final B user(User user) {
            this.user = Objects.requireNonNull(user);
            return (B)this;
        }

        @Override
        public final B domainType(DomainType domainType) {
            this.domainType = Objects.requireNonNull(domainType);
            return (B)this;
        }

        @Override
        public final B clientId(UUID clientId) {
            this.clientId = Objects.requireNonNull(clientId);
            return (B)this;
        }

        @Override
        public final B clientTypeId(String clientTypeId) {
            this.clientTypeId = Objects.requireNonNull(clientTypeId);
            return (B)this;
        }

        @Override
        public final B clientVersion(Version clientVersion) {
            this.clientVersion = clientVersion;
            return (B)this;
        }

        @Override
        public final B onClose(Consumer<EntityConnectionProvider> onClose) {
            this.onClose = Objects.requireNonNull(onClose);
            return (B)this;
        }
    }
}

