/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.sqlite;

import is.codion.common.db.database.AbstractDatabase;
import java.sql.SQLException;
import java.util.Objects;

final class SQLiteDatabase
extends AbstractDatabase {
    private static final String AUTO_INCREMENT_QUERY = "SELECT LAST_INSERT_ROWID()";
    private static final int FOREIGN_KEY_ERROR = 787;
    private static final String JDBC_URL_PREFIX = "jdbc:sqlite:";

    SQLiteDatabase(String url) {
        super(url);
    }

    public String name() {
        return SQLiteDatabase.removeUrlPrefixOptionsAndParameters((String)this.url(), (String[])new String[]{JDBC_URL_PREFIX});
    }

    public String autoIncrementQuery(String idSource) {
        return AUTO_INCREMENT_QUERY;
    }

    public String selectForUpdateClause() {
        return "FOR UPDATE";
    }

    public String limitOffsetClause(Integer limit, Integer offset) {
        return SQLiteDatabase.createLimitOffsetClause((Integer)limit, (Integer)offset);
    }

    public boolean isReferentialIntegrityException(SQLException exception) {
        return Objects.requireNonNull(exception).getErrorCode() == 787;
    }
}

