/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.postgresql;

import is.codion.common.db.database.AbstractDatabase;
import is.codion.common.db.database.Database;
import is.codion.common.resource.MessageBundle;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;

final class PostgreSQLDatabase
extends AbstractDatabase {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(PostgreSQLDatabase.class, (ResourceBundle)ResourceBundle.getBundle(PostgreSQLDatabase.class.getName()));
    private static final Map<String, String> ERROR_CODE_MAP = new HashMap<String, String>();
    private static final String INVALID_PASS = "28P01";
    private static final String FOREIGN_KEY_VIOLATION = "23503";
    private static final String FOREIGN_KEY_VIOLATION_DELETE = "23503_delete";
    private static final String UNIQUE_CONSTRAINT_ERROR = "23505";
    private static final String TIMEOUT_ERROR = "57014";
    private static final String NULL_VALUE_ERROR = "23502";
    private static final String CHECK_CONSTRAINT_ERROR = "23514";
    private static final String VALUE_TOO_LARGE_ERROR = "22001";
    private static final String MISSING_PRIVS_ERROR = "42501";
    private static final String JDBC_URL_PREFIX = "jdbc:postgresql://";
    private static final String UNIQUE_KEY_ERROR = "unique_key_error";
    private static final int MAXIMUM_STATEMENT_PARAMETERS = 65535;
    private final boolean nowait;

    PostgreSQLDatabase(String url, boolean nowait) {
        super(url);
        this.nowait = nowait;
    }

    public String name() {
        String name = PostgreSQLDatabase.removeUrlPrefixOptionsAndParameters((String)this.url(), (String[])new String[]{JDBC_URL_PREFIX});
        if (name.contains("/")) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        return name;
    }

    public String selectForUpdateClause() {
        if (this.nowait) {
            return "FOR UPDATE NOWAIT";
        }
        return "FOR UPDATE";
    }

    public String limitOffsetClause(Integer limit, Integer offset) {
        return PostgreSQLDatabase.createLimitOffsetClause((Integer)limit, (Integer)offset);
    }

    public String autoIncrementQuery(String idSource) {
        return "SELECT CURRVAL('" + Objects.requireNonNull(idSource, "idSource") + "')";
    }

    public String sequenceQuery(String sequenceName) {
        return "SELECT NEXTVAL('" + Objects.requireNonNull(sequenceName, "sequenceName") + "')";
    }

    public boolean isAuthenticationException(SQLException exception) {
        return INVALID_PASS.equals(Objects.requireNonNull(exception).getSQLState());
    }

    public boolean isReferentialIntegrityException(SQLException exception) {
        return FOREIGN_KEY_VIOLATION.equals(Objects.requireNonNull(exception).getSQLState());
    }

    public boolean isUniqueConstraintException(SQLException exception) {
        return UNIQUE_CONSTRAINT_ERROR.equals(Objects.requireNonNull(exception).getSQLState());
    }

    public boolean isTimeoutException(SQLException exception) {
        return TIMEOUT_ERROR.equals(Objects.requireNonNull(exception).getSQLState());
    }

    public boolean subqueryRequiresAlias() {
        return true;
    }

    public int maximumNumberOfParameters() {
        return 65535;
    }

    public String errorMessage(SQLException exception, Database.Operation operation) {
        Objects.requireNonNull(exception);
        Objects.requireNonNull(operation);
        String sqlState = exception.getSQLState();
        if (NULL_VALUE_ERROR.equals(sqlState)) {
            return PostgreSQLDatabase.createNullValueErrorMessage(exception.getMessage());
        }
        if (UNIQUE_CONSTRAINT_ERROR.equals(sqlState)) {
            return PostgreSQLDatabase.createUniqueConstraintErrorMessage(exception.getMessage());
        }
        if (FOREIGN_KEY_VIOLATION.equals(sqlState)) {
            return PostgreSQLDatabase.createForeignKeyViolationErrorMessage(operation);
        }
        if (ERROR_CODE_MAP.containsKey(sqlState)) {
            return ERROR_CODE_MAP.get(sqlState);
        }
        return super.errorMessage(exception, operation);
    }

    private static String createNullValueErrorMessage(String exceptionMessage) {
        int indexOfColumn = exceptionMessage.indexOf("column \"");
        int indexOfRelation = exceptionMessage.indexOf("\" of relation");
        if (indexOfColumn != -1 && indexOfRelation != -1) {
            String columnName = exceptionMessage.substring(indexOfColumn + 8, indexOfRelation);
            return MESSAGES.getString("value_missing") + ": " + columnName;
        }
        return exceptionMessage;
    }

    private static String createUniqueConstraintErrorMessage(String exceptionMessage) {
        int indexOfDetail = exceptionMessage.indexOf("Detail: Key");
        int indexOfAlreadyExists = exceptionMessage.indexOf(" already exists.");
        if (indexOfDetail != -1 && indexOfAlreadyExists != -1) {
            String values = exceptionMessage.substring(indexOfDetail + 11, indexOfAlreadyExists);
            return MESSAGES.getString(UNIQUE_KEY_ERROR) + ": " + values;
        }
        return MESSAGES.getString(UNIQUE_KEY_ERROR);
    }

    private static String createForeignKeyViolationErrorMessage(Database.Operation operation) {
        if (operation == Database.Operation.DELETE) {
            return ERROR_CODE_MAP.get(FOREIGN_KEY_VIOLATION_DELETE);
        }
        return ERROR_CODE_MAP.get(FOREIGN_KEY_VIOLATION);
    }

    static {
        ERROR_CODE_MAP.put(UNIQUE_CONSTRAINT_ERROR, MESSAGES.getString(UNIQUE_KEY_ERROR));
        ERROR_CODE_MAP.put(FOREIGN_KEY_VIOLATION, MESSAGES.getString("foreign_key_violation"));
        ERROR_CODE_MAP.put(FOREIGN_KEY_VIOLATION_DELETE, MESSAGES.getString("foreign_key_violation_delete"));
        ERROR_CODE_MAP.put(NULL_VALUE_ERROR, MESSAGES.getString("null_value_error"));
        ERROR_CODE_MAP.put(CHECK_CONSTRAINT_ERROR, MESSAGES.getString("check_constraint_error"));
        ERROR_CODE_MAP.put(MISSING_PRIVS_ERROR, MESSAGES.getString("missing_privileges_error"));
        ERROR_CODE_MAP.put(VALUE_TOO_LARGE_ERROR, MESSAGES.getString("value_too_large_for_column_error"));
    }
}

