/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.oracle;

import is.codion.common.db.database.AbstractDatabase;
import is.codion.common.db.database.Database;
import is.codion.common.resource.MessageBundle;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;

final class OracleDatabase
extends AbstractDatabase {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(OracleDatabase.class, (ResourceBundle)ResourceBundle.getBundle(OracleDatabase.class.getName()));
    private static final String JDBC_URL_DRIVER_PREFIX = "jdbc:oracle:thin:";
    private static final String JDBC_URL_PREFIX = "jdbc:oracle:thin:@";
    private static final String JDBC_URL_WALLET_PREFIX = "jdbc:oracle:thin:/@";
    private static final Map<Integer, String> ERROR_CODE_MAP = new HashMap<Integer, String>();
    private static final int UNIQUE_KEY_ERROR = 1;
    private static final int CHILD_RECORD_ERROR = 2292;
    private static final int NULL_VALUE_ERROR = 1400;
    private static final int INTEGRITY_CONSTRAINT_ERROR = 2291;
    private static final int NULL_VALUE_ERROR_2 = 1407;
    private static final int CHECK_CONSTRAINT_ERROR = 2290;
    private static final int MISSING_PRIVS_ERROR = 1031;
    private static final int LOGIN_CREDS_ERROR = 1017;
    private static final int TABLE_NOT_FOUND_ERROR = 942;
    private static final int UNABLE_TO_CONNECT_ERROR = 1045;
    private static final int VALUE_TOO_LARGE_ERROR = 1401;
    private static final int VIEW_HAS_ERRORS_ERROR = 4063;
    private static final int TIMEOUT_ERROR = 17016;
    private final boolean nowait;

    OracleDatabase(String url) {
        this(url, true);
    }

    OracleDatabase(String url, boolean nowait) {
        super(url);
        this.nowait = nowait;
    }

    public String name() {
        String name = OracleDatabase.removeUrlPrefixOptionsAndParameters((String)this.url(), (String[])new String[]{JDBC_URL_PREFIX, JDBC_URL_WALLET_PREFIX});
        if (name.contains("/")) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        return name.substring(name.lastIndexOf(58) + 1);
    }

    public String autoIncrementQuery(String idSource) {
        return "SELECT " + Objects.requireNonNull(idSource, "idSource") + ".CURRVAL FROM DUAL";
    }

    public String sequenceQuery(String sequenceName) {
        return "SELECT " + Objects.requireNonNull(sequenceName, "sequenceName") + ".NEXTVAL FROM DUAL";
    }

    public String selectForUpdateClause() {
        if (this.nowait) {
            return "FOR UPDATE NOWAIT";
        }
        return "FOR UPDATE";
    }

    public String limitOffsetClause(Integer limit, Integer offset) {
        return OracleDatabase.createOffsetFetchNextClause((Integer)limit, (Integer)offset);
    }

    public String errorMessage(SQLException exception, Database.Operation operation) {
        Objects.requireNonNull(exception);
        if (exception.getErrorCode() == 1400 || exception.getErrorCode() == 1407) {
            String exceptionMessage = exception.getMessage();
            int newlineIndex = exception.getMessage().indexOf(10);
            if (newlineIndex != -1) {
                exceptionMessage = exceptionMessage.substring(0, newlineIndex);
            }
            String errorMsg = exceptionMessage;
            String columnName = errorMsg.substring(errorMsg.lastIndexOf(46) + 2, errorMsg.lastIndexOf(41) - 1);
            return MESSAGES.getString("value_missing") + ": " + columnName;
        }
        if (ERROR_CODE_MAP.containsKey(exception.getErrorCode())) {
            return ERROR_CODE_MAP.get(exception.getErrorCode());
        }
        return exception.getMessage();
    }

    public boolean isAuthenticationException(SQLException exception) {
        return Objects.requireNonNull(exception).getErrorCode() == 1017;
    }

    public boolean isReferentialIntegrityException(SQLException exception) {
        return Objects.requireNonNull(exception).getErrorCode() == 2292 || exception.getErrorCode() == 2291;
    }

    public boolean isUniqueConstraintException(SQLException exception) {
        return Objects.requireNonNull(exception).getErrorCode() == 1;
    }

    public boolean isTimeoutException(SQLException exception) {
        return Objects.requireNonNull(exception).getErrorCode() == 17016;
    }

    static {
        ERROR_CODE_MAP.put(1, MESSAGES.getString("unique_key_error"));
        ERROR_CODE_MAP.put(2292, MESSAGES.getString("child_record_error"));
        ERROR_CODE_MAP.put(1400, MESSAGES.getString("null_value_error"));
        ERROR_CODE_MAP.put(2291, MESSAGES.getString("integrity_constraint_error"));
        ERROR_CODE_MAP.put(1407, MESSAGES.getString("null_value_error"));
        ERROR_CODE_MAP.put(2290, MESSAGES.getString("check_constraint_error"));
        ERROR_CODE_MAP.put(1031, MESSAGES.getString("missing_privileges_error"));
        ERROR_CODE_MAP.put(1017, MESSAGES.getString("login_credentials_error"));
        ERROR_CODE_MAP.put(942, MESSAGES.getString("table_not_found_error"));
        ERROR_CODE_MAP.put(1045, MESSAGES.getString("user_cannot_connect"));
        ERROR_CODE_MAP.put(1401, MESSAGES.getString("value_too_large_for_column_error"));
        ERROR_CODE_MAP.put(4063, MESSAGES.getString("view_has_errors_error"));
    }
}

